/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.ra;

import javax.jms.Connection;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.QueueConnection;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAJMSContext;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.resource.spi.ConnectionManager;
import org.hornetq.jms.referenceable.ConnectionFactoryObjectFactory;
import org.hornetq.jms.referenceable.SerializableObjectRefAddr;
import org.hornetq.ra.HornetQRAConnectionFactory;
import org.hornetq.ra.HornetQRAConnectionManager;
import org.hornetq.ra.HornetQRALogger;
import org.hornetq.ra.HornetQRAManagedConnectionFactory;
import org.hornetq.ra.HornetQRASessionFactoryImpl;

public class HornetQRAConnectionFactoryImpl
implements HornetQRAConnectionFactory {
    static final long serialVersionUID = 7981708919479859360L;
    private static boolean trace = HornetQRALogger.LOGGER.isTraceEnabled();
    private final HornetQRAManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;

    public HornetQRAConnectionFactoryImpl(HornetQRAManagedConnectionFactory mcf, ConnectionManager cm) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("constructor(" + mcf + ", " + cm + ")");
        }
        this.mcf = mcf;
        if (cm == null) {
            this.cm = new HornetQRAConnectionManager();
            if (trace) {
                HornetQRALogger.LOGGER.trace("Created new ConnectionManager=" + this.cm);
            }
        } else {
            this.cm = cm;
        }
        if (trace) {
            HornetQRALogger.LOGGER.trace("Using ManagedConnectionFactory=" + mcf + ", ConnectionManager=" + cm);
        }
    }

    public void setReference(Reference reference) {
        if (trace) {
            HornetQRALogger.LOGGER.trace("setReference(" + reference + ")");
        }
        this.reference = reference;
    }

    public Reference getReference() {
        if (trace) {
            HornetQRALogger.LOGGER.trace("getReference()");
        }
        if (this.reference == null) {
            try {
                this.reference = new Reference(this.getClass().getCanonicalName(), (RefAddr)new SerializableObjectRefAddr("HornetQ-CF", (Object)this), ConnectionFactoryObjectFactory.class.getCanonicalName(), null);
            }
            catch (NamingException e) {
                HornetQRALogger.LOGGER.errorCreatingReference(e);
            }
        }
        return this.reference;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("createQueueConnection()");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 1);
        if (trace) {
            HornetQRALogger.LOGGER.trace("Created queue connection: " + s);
        }
        return s;
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("createQueueConnection(" + userName + ", ****)");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 1);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        if (trace) {
            HornetQRALogger.LOGGER.trace("Created queue connection: " + s);
        }
        return s;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("createTopicConnection()");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 2);
        if (trace) {
            HornetQRALogger.LOGGER.trace("Created topic connection: " + s);
        }
        return s;
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("createTopicConnection(" + userName + ", ****)");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 2);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        if (trace) {
            HornetQRALogger.LOGGER.trace("Created topic connection: " + s);
        }
        return s;
    }

    public Connection createConnection() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("createConnection()");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 0);
        if (trace) {
            HornetQRALogger.LOGGER.trace("Created connection: " + s);
        }
        return s;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("createConnection(" + userName + ", ****)");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 0);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        if (trace) {
            HornetQRALogger.LOGGER.trace("Created connection: " + s);
        }
        return s;
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("createXAQueueConnection()");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 4);
        if (trace) {
            HornetQRALogger.LOGGER.trace("Created queue connection: " + s);
        }
        return s;
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("createXAQueueConnection(" + userName + ", ****)");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 4);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        if (trace) {
            HornetQRALogger.LOGGER.trace("Created queue connection: " + s);
        }
        return s;
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("createXATopicConnection()");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 5);
        if (trace) {
            HornetQRALogger.LOGGER.trace("Created topic connection: " + s);
        }
        return s;
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("createXATopicConnection(" + userName + ", ****)");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 5);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        if (trace) {
            HornetQRALogger.LOGGER.trace("Created topic connection: " + s);
        }
        return s;
    }

    public XAConnection createXAConnection() throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("createXAConnection()");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 3);
        if (trace) {
            HornetQRALogger.LOGGER.trace("Created connection: " + s);
        }
        return s;
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        if (trace) {
            HornetQRALogger.LOGGER.trace("createXAConnection(" + userName + ", ****)");
        }
        HornetQRASessionFactoryImpl s = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 3);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        if (trace) {
            HornetQRALogger.LOGGER.trace("Created connection: " + s);
        }
        return s;
    }

    public JMSContext createContext() {
        return this.createContext(null, null);
    }

    public JMSContext createContext(String userName, String password) {
        return this.createContext(userName, password, 1);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        HornetQRASessionFactoryImpl conn = new HornetQRASessionFactoryImpl(this.mcf, this.cm, 0);
        conn.setUserName(userName);
        conn.setPassword(password);
        try {
            this.validateUser(conn);
        }
        catch (JMSSecurityException e) {
            JMSSecurityRuntimeException e2 = new JMSSecurityRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
        return conn.createContext(sessionMode);
    }

    public JMSContext createContext(int sessionMode) {
        return this.createContext(null, null, sessionMode);
    }

    public XAJMSContext createXAContext() {
        throw new UnsupportedOperationException("JMS 2.0 / not implemented / optional");
    }

    public XAJMSContext createXAContext(String userName, String password) {
        throw new UnsupportedOperationException("JMS 2.0 / not implemented");
    }

    private void validateUser(HornetQRASessionFactoryImpl s) throws JMSException {
        Session session = s.createSession();
        session.close();
    }
}

