/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.domain.controller.DomainControllerLogger;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.coordination.DomainServerUtils;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.ManagedServerBootCmdFactory;
import org.jboss.as.host.controller.ManagedServerBootConfiguration;
import org.jboss.as.host.controller.ManagedServerOperationsFactory;
import org.jboss.as.host.controller.ignored.IgnoredDomainResourceRegistry;
import org.jboss.as.management.client.content.ManagedDMRContentTypeResource;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ApplyRemoteMasterDomainModelHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "apply-remote-domain-model";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("apply-remote-domain-model", null).setPrivateEntry().build();
    protected final DomainController domainController;
    protected final HostControllerEnvironment hostControllerEnvironment;
    protected final LocalHostControllerInfo localHostInfo;
    protected final IgnoredDomainResourceRegistry ignoredResourceRegistry;
    private final HostFileRepository fileRepository;
    private final ContentRepository contentRepository;

    public ApplyRemoteMasterDomainModelHandler(DomainController domainController, HostControllerEnvironment hostControllerEnvironment, HostFileRepository fileRepository, ContentRepository contentRepository, LocalHostControllerInfo localHostInfo, IgnoredDomainResourceRegistry ignoredResourceRegistry) {
        this.domainController = domainController;
        this.hostControllerEnvironment = hostControllerEnvironment;
        this.fileRepository = fileRepository;
        this.contentRepository = contentRepository;
        this.localHostInfo = localHostInfo;
        this.ignoredResourceRegistry = ignoredResourceRegistry;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode domainModel = operation.get("domain-model");
        ModelNode startRoot = Resource.Tools.readModel((Resource)context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS));
        Set<String> ourServerGroups = this.getOurServerGroups(context);
        HashMap<String, HashSet<byte[]>> deploymentHashes = new HashMap<String, HashSet<byte[]>>();
        HashSet<String> relevantDeployments = new HashSet<String>();
        HashSet<byte[]> requiredContent = new HashSet<byte[]>();
        Resource rootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        this.clearDomain(rootResource);
        for (ModelNode resourceDescription : domainModel.asList()) {
            PathAddress resourceAddress = PathAddress.pathAddress((ModelNode)resourceDescription.require("domain-resource-address"));
            if (this.ignoredResourceRegistry.isResourceExcluded(resourceAddress)) continue;
            Resource resource = this.getResource(resourceAddress, rootResource, context);
            if (resourceAddress.size() == 1 && resourceAddress.getElement(0).getKey().equals("extension")) continue;
            resource.writeModel(resourceDescription.get("domain-resource-model"));
            if (resourceAddress.size() == 1) {
                ModelNode model;
                PathElement pe = resourceAddress.getElement(0);
                String peKey = pe.getKey();
                if (peKey.equals("deployment")) {
                    model = resource.getModel();
                    String id = resourceAddress.getElement(0).getValue();
                    if (!model.hasDefined("content")) continue;
                    for (ModelNode contentItem : model.get("content").asList()) {
                        if (!contentItem.hasDefined("hash")) continue;
                        HashSet<byte[]> hashes = (HashSet<byte[]>)deploymentHashes.get(id);
                        if (hashes == null) {
                            hashes = new HashSet<byte[]>();
                            deploymentHashes.put(id, hashes);
                        }
                        hashes.add(contentItem.get("hash").asBytes());
                    }
                    continue;
                }
                if (!peKey.equals("management-client-content") || !(model = resource.getModel()).hasDefined("hash")) continue;
                requiredContent.add(model.get("hash").asBytes());
                continue;
            }
            if (resourceAddress.size() != 2 || !resourceAddress.getElement(0).getKey().equals("server-group") || !ourServerGroups.contains(resourceAddress.getElement(0).getValue()) || !resourceAddress.getElement(1).getKey().equals("deployment")) continue;
            relevantDeployments.add(resourceAddress.getElement(1).getValue());
        }
        for (String id : relevantDeployments) {
            Set hashes = (Set)deploymentHashes.remove(id);
            if (hashes == null) continue;
            requiredContent.addAll(hashes);
        }
        for (byte[] hash : requiredContent) {
            this.fileRepository.getDeploymentFiles(hash);
        }
        if (!context.isBooting()) {
            this.makeAffectedServersRestartRequired(context, startRoot);
        }
        context.stepCompleted();
    }

    private void clearDomain(Resource rootResource) {
        for (Resource.ResourceEntry entry : rootResource.getChildren("path")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("system-property")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("profile")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("interface")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("socket-binding-group")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("deployment")) {
            rootResource.removeChild(entry.getPathElement());
        }
        for (Resource.ResourceEntry entry : rootResource.getChildren("server-group")) {
            rootResource.removeChild(entry.getPathElement());
        }
    }

    protected Resource getResource(PathAddress resourceAddress, Resource rootResource, OperationContext context) {
        if (resourceAddress.size() == 0) {
            return rootResource;
        }
        Resource temp = rootResource;
        int idx = 0;
        for (PathElement element : resourceAddress) {
            if ((temp = temp.getChild(element)) == null) {
                if (idx == 0) {
                    String type = element.getKey();
                    if (type.equals("extension")) continue;
                    if (type.equals("management-client-content") && element.getValue().equals("rollout-plans")) {
                        temp = new ManagedDMRContentTypeResource(element, "rollout-plan", null, this.contentRepository);
                        context.addResource(resourceAddress, temp);
                    }
                }
                if (temp != null) break;
                temp = context.createResource(resourceAddress);
                break;
            }
            ++idx;
        }
        return temp;
    }

    private Set<String> getOurServerGroups(OperationContext context) {
        HashSet<String> result = new HashSet<String>();
        Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
        Resource host = (Resource)root.getChildren("host").iterator().next();
        for (Resource server : host.getChildren("server-config")) {
            ModelNode model = server.getModel();
            result.add(model.get("group").asString());
        }
        return result;
    }

    private void makeAffectedServersRestartRequired(OperationContext context, ModelNode startRoot) {
        Resource domainRootResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode endRoot = Resource.Tools.readModel((Resource)domainRootResource);
        ModelNode hostModel = ((Property)endRoot.require("host").asPropertyList().iterator().next()).getValue();
        ModelNode existingHostModel = ((Property)startRoot.require("host").asPropertyList().iterator().next()).getValue();
        HashSet<ServerIdentity> affectedServers = new HashSet<ServerIdentity>();
        for (String serverName : hostModel.get("server-config").keys()) {
            ModelNode endOps;
            ModelNode startOps = this.createBootOps(context, serverName, startRoot, existingHostModel);
            if (this.bootOpsChanged(startOps, endOps = this.createBootOps(context, serverName, endRoot, hostModel))) {
                affectedServers.add(this.createServerIdentity(hostModel, serverName));
            }
            ManagedServerBootConfiguration startConfig = new ManagedServerBootCmdFactory(serverName, startRoot, existingHostModel, this.hostControllerEnvironment, this.domainController.getExpressionResolver()).createConfiguration();
            ManagedServerBootConfiguration endConfig = new ManagedServerBootCmdFactory(serverName, endRoot, hostModel, this.hostControllerEnvironment, this.domainController.getExpressionResolver()).createConfiguration();
            if (startConfig.getServerLaunchCommand().equals(endConfig.getServerLaunchCommand())) continue;
            affectedServers.add(this.createServerIdentity(hostModel, serverName));
        }
        Map<String, ProxyController> serverProxies = DomainServerUtils.getServerProxies(this.localHostInfo.getLocalHostName(), domainRootResource, context.getResourceRegistration());
        if (!affectedServers.isEmpty()) {
            DomainControllerLogger.ROOT_LOGGER.domainModelChangedOnReConnect(affectedServers);
            Set<ServerIdentity> runningServers = DomainServerUtils.getAllRunningServers(hostModel, this.localHostInfo.getLocalHostName(), serverProxies);
            for (ServerIdentity serverIdentity : affectedServers) {
                if (!runningServers.contains(serverIdentity)) continue;
                PathAddress serverAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"host", (String)serverIdentity.getHostName()), PathElement.pathElement((String)"server", (String)serverIdentity.getServerName())});
                OperationStepHandler handler = context.getResourceRegistration().getOperationHandler(serverAddress, "server-set-restart-required");
                ModelNode op = new ModelNode();
                op.get("operation").set("server-set-restart-required");
                op.get("address").set(serverAddress.toModelNode());
                context.addStep(op, handler, OperationContext.Stage.MODEL, true);
            }
        }
    }

    private ServerIdentity createServerIdentity(ModelNode hostModel, String serverName) {
        return new ServerIdentity(this.localHostInfo.getLocalHostName(), hostModel.require("server-config").require(serverName).require("group").asString(), serverName);
    }

    private boolean bootOpsChanged(ModelNode startOps, ModelNode endOps) {
        List startOpList = startOps.asList();
        List endOpList = endOps.asList();
        if (startOpList.size() != endOpList.size()) {
            return true;
        }
        HashSet startOpSet = new HashSet(startOpList);
        HashSet endOpSet = new HashSet(endOpList);
        return !startOpSet.equals(endOpSet);
    }

    private ModelNode createBootOps(final OperationContext context, String serverName, ModelNode domainModel, ModelNode hostModel) {
        return ManagedServerOperationsFactory.createBootUpdates(serverName, domainModel, hostModel, this.domainController, new ExpressionResolver(){

            public ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
                return context.resolveExpressions(node);
            }
        });
    }
}

