/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

public class SaslInputStream
extends InputStream {
    public static final Log LOG = LogFactory.getLog(SaslInputStream.class);
    private final SaslClient saslClient;
    private final DataInputStream inStream;
    private byte[] buffer;
    private int bufferPtr = 0;
    private int bufferLength = 0;

    public SaslInputStream(InputStream inStream, SaslClient saslClient) {
        this.inStream = new DataInputStream(new BufferedInputStream(inStream));
        this.saslClient = saslClient;
    }

    @Override
    public int read() throws IOException {
        if (this.bufferPtr >= this.bufferLength) {
            int i = 0;
            while (i == 0) {
                i = this.fillBuffer();
            }
            if (i == -1) {
                return -1;
            }
        }
        return this.buffer[this.bufferPtr++] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.bufferPtr >= this.bufferLength) {
            int i = 0;
            while (i == 0) {
                i = this.fillBuffer();
            }
            if (i == -1) {
                return -1;
            }
        }
        if (len <= 0) {
            return 0;
        }
        int available = this.bufferLength - this.bufferPtr;
        if (len < available) {
            available = len;
        }
        if (b != null) {
            System.arraycopy(this.buffer, this.bufferPtr, b, off, available);
        }
        this.bufferPtr += available;
        return available;
    }

    @Override
    public long skip(long n) throws IOException {
        int available = this.bufferLength - this.bufferPtr;
        if (n > (long)available) {
            n = available;
        }
        if (n < 0L) {
            return 0L;
        }
        this.bufferPtr = (int)((long)this.bufferPtr + n);
        return n;
    }

    @Override
    public int available() throws IOException {
        return this.bufferLength - this.bufferPtr;
    }

    @Override
    public void close() throws IOException {
        this.disposeSasl();
        this.bufferPtr = 0;
        this.bufferLength = 0;
        this.inStream.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private int fillBuffer() throws IOException {
        try {
            int length = this.inStream.readInt();
            byte[] saslToken = new byte[length];
            this.inStream.readFully(saslToken);
            this.buffer = this.saslClient.unwrap(saslToken, 0, length);
        }
        catch (EOFException e) {
            return -1;
        }
        catch (SaslException se) {
            try {
                this.disposeSasl();
            }
            catch (SaslException saslException) {
                // empty catch block
            }
            throw se;
        }
        this.bufferPtr = 0;
        this.bufferLength = this.buffer.length;
        return this.bufferLength;
    }

    private void disposeSasl() throws SaslException {
        if (this.saslClient != null) {
            this.saslClient.dispose();
        }
    }
}

