/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.wildfly.extension.picketlink.idm.model.parser.IDMSubsystemReader_1_0;
import org.wildfly.extension.picketlink.idm.model.parser.IDMSubsystemReader_2_0;
import org.wildfly.extension.picketlink.idm.model.parser.IDMSubsystemWriter;

public enum Namespace {
    PICKETLINK_IDENTITY_MANAGEMENT_1_0(1, 0, 0, new IDMSubsystemReader_1_0(), new IDMSubsystemWriter()),
    PICKETLINK_IDENTITY_MANAGEMENT_2_0(2, 0, 0, new IDMSubsystemReader_2_0(), new IDMSubsystemWriter());

    public static final Namespace CURRENT;
    public static final String BASE_URN = "urn:jboss:domain:picketlink-identity-management:";
    private static final Map<String, Namespace> namespaces;
    private final int major;
    private final int minor;
    private final int patch;
    private final XMLElementReader<List<ModelNode>> reader;
    private final XMLElementWriter<SubsystemMarshallingContext> writer;

    private Namespace(int major, int minor, int patch, XMLElementReader<List<ModelNode>> reader, XMLElementWriter<SubsystemMarshallingContext> writer) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.reader = reader;
        this.writer = writer;
    }

    public static Namespace forUri(String uri) {
        return namespaces.get(uri) == null ? null : namespaces.get(uri);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getUri() {
        String patchVersion = "";
        if (this.patch > 0) {
            patchVersion = "." + this.patch;
        }
        return BASE_URN + this.major + "." + this.minor + patchVersion;
    }

    public XMLElementReader<List<ModelNode>> getXMLReader() {
        return this.reader;
    }

    public XMLElementWriter<SubsystemMarshallingContext> getXMLWriter() {
        return this.writer;
    }

    public ModelVersion getModelVersion() {
        if (this.patch > 0) {
            return ModelVersion.create((int)this.getMajor(), (int)this.getMinor(), (int)this.getPatch());
        }
        return ModelVersion.create((int)this.getMajor(), (int)this.getMinor());
    }

    static {
        CURRENT = PICKETLINK_IDENTITY_MANAGEMENT_2_0;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUri();
            if (name == null) continue;
            map.put(name, namespace);
        }
        namespaces = map;
    }
}

