/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mwlabs.wscf.model.sagas.arjunacore;

import com.arjuna.mw.wsas.UserActivityFactory;
import com.arjuna.mw.wsas.activity.ActivityHierarchy;
import com.arjuna.mw.wsas.activity.Outcome;
import com.arjuna.mw.wsas.completionstatus.Failure;
import com.arjuna.mw.wsas.completionstatus.FailureOnly;
import com.arjuna.mw.wsas.completionstatus.Success;
import com.arjuna.mw.wsas.exceptions.ActiveChildException;
import com.arjuna.mw.wsas.exceptions.InvalidActivityException;
import com.arjuna.mw.wsas.exceptions.InvalidTimeoutException;
import com.arjuna.mw.wsas.exceptions.NoActivityException;
import com.arjuna.mw.wsas.exceptions.NoPermissionException;
import com.arjuna.mw.wsas.exceptions.ProtocolViolationException;
import com.arjuna.mw.wsas.exceptions.SystemException;
import com.arjuna.mw.wsas.exceptions.WrongStateException;
import com.arjuna.mw.wsas.status.NoActivity;
import com.arjuna.mw.wsas.status.Status;
import com.arjuna.mw.wscf.common.CoordinatorId;
import com.arjuna.mw.wscf.exceptions.DuplicateParticipantException;
import com.arjuna.mw.wscf.exceptions.InvalidParticipantException;
import com.arjuna.mw.wscf.exceptions.NoCoordinatorException;
import com.arjuna.mw.wscf.logging.wscfLogger;
import com.arjuna.mw.wscf.model.sagas.api.CoordinatorManager;
import com.arjuna.mw.wscf.model.sagas.api.UserCoordinator;
import com.arjuna.mw.wscf.model.sagas.exceptions.CoordinatorCancelledException;
import com.arjuna.mw.wscf.model.sagas.exceptions.CoordinatorConfirmedException;
import com.arjuna.mw.wscf.model.sagas.outcomes.CoordinationOutcome;
import com.arjuna.mw.wscf.model.sagas.participants.Participant;
import com.arjuna.mwlabs.wsas.UserActivityImple;
import com.arjuna.mwlabs.wsas.activity.ActivityImple;
import com.arjuna.mwlabs.wscf.model.sagas.arjunacore.BACoordinator;
import com.arjuna.mwlabs.wscf.model.sagas.arjunacore.CoordinatorControl;

public class CoordinatorServiceImple
implements UserCoordinator,
CoordinatorManager {
    private CoordinatorControl _coordManager = new CoordinatorControl();

    @Override
    public void begin(String coordinationType) throws WrongStateException, SystemException {
        UserActivityFactory.userActivity().start(coordinationType);
    }

    @Override
    public void begin(String coordinationType, int timeout) throws WrongStateException, InvalidTimeoutException, SystemException {
        UserActivityFactory.userActivity().start(coordinationType, timeout);
    }

    public BACoordinator createSubordinate() throws SystemException {
        return this._coordManager.createSubordinate();
    }

    @Override
    public void close() throws InvalidActivityException, WrongStateException, ProtocolViolationException, NoCoordinatorException, CoordinatorCancelledException, NoPermissionException, SystemException {
        block10: {
            try {
                Outcome res = UserActivityFactory.userActivity().end(Success.instance());
                if (res == null) break block10;
                if (res instanceof CoordinationOutcome) {
                    CoordinationOutcome co = (CoordinationOutcome)res;
                    switch (co.result()) {
                        case 4: 
                        case 7: 
                        case 11: {
                            break;
                        }
                        case 3: 
                        case 10: {
                            throw new CoordinatorCancelledException();
                        }
                        case 5: {
                            throw new ProtocolViolationException("HeuristicMixed");
                        }
                        case 8: {
                            throw new WrongStateException();
                        }
                        default: {
                            throw new ProtocolViolationException("HeuristicHazard");
                        }
                    }
                    break block10;
                }
                throw new ProtocolViolationException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_CoordinatorServiceImple_1());
            }
            catch (NoActivityException ex) {
                throw new NoCoordinatorException();
            }
            catch (ActiveChildException activeChildException) {
                // empty catch block
            }
        }
    }

    @Override
    public void cancel() throws InvalidActivityException, WrongStateException, ProtocolViolationException, NoCoordinatorException, CoordinatorConfirmedException, NoPermissionException, SystemException {
        block10: {
            try {
                Outcome res = UserActivityFactory.userActivity().end(Failure.instance());
                if (res == null) break block10;
                if (res instanceof CoordinationOutcome) {
                    CoordinationOutcome co = (CoordinationOutcome)res;
                    switch (co.result()) {
                        case 4: 
                        case 11: {
                            throw new CoordinatorConfirmedException();
                        }
                        case 3: 
                        case 7: 
                        case 10: {
                            break;
                        }
                        case 5: {
                            throw new ProtocolViolationException("HeuristicMixed");
                        }
                        case 8: {
                            throw new WrongStateException();
                        }
                        default: {
                            throw new ProtocolViolationException("HeuristicHazard");
                        }
                    }
                    break block10;
                }
                throw new ProtocolViolationException(wscfLogger.i18NLogger.get_model_sagas_arjunacore_CoordinatorServiceImple_1());
            }
            catch (NoActivityException ex) {
                throw new NoCoordinatorException();
            }
            catch (ActiveChildException activeChildException) {
                // empty catch block
            }
        }
    }

    @Override
    public void complete() throws InvalidActivityException, WrongStateException, ProtocolViolationException, NoCoordinatorException, NoPermissionException, SystemException {
        this._coordManager.complete();
    }

    @Override
    public void setCancelOnly() throws NoCoordinatorException, WrongStateException, SystemException {
        try {
            UserActivityFactory.userActivity().setCompletionStatus(FailureOnly.instance());
        }
        catch (NoActivityException ex) {
            throw new NoCoordinatorException();
        }
    }

    @Override
    public int getTimeout() throws SystemException {
        return UserActivityFactory.userActivity().getTimeout();
    }

    @Override
    public void setTimeout(int timeout) throws InvalidTimeoutException, SystemException {
        UserActivityFactory.userActivity().setTimeout(timeout);
    }

    @Override
    public Status status() throws SystemException {
        ActivityImple curr = this.current();
        if (curr == null) {
            return NoActivity.instance();
        }
        return this._coordManager.status();
    }

    @Override
    public ActivityHierarchy suspend() throws SystemException {
        return UserActivityFactory.userActivity().suspend();
    }

    @Override
    public void resume(ActivityHierarchy tx) throws InvalidActivityException, SystemException {
        UserActivityFactory.userActivity().resume(tx);
    }

    @Override
    public void enlistParticipant(Participant act) throws WrongStateException, DuplicateParticipantException, InvalidParticipantException, NoCoordinatorException, SystemException {
        this._coordManager.enlistParticipant(act);
    }

    @Override
    public void delistParticipant(String participantId) throws InvalidParticipantException, NoCoordinatorException, WrongStateException, SystemException {
        this._coordManager.delistParticipant(participantId);
    }

    @Override
    public void participantCompleted(String participantId) throws NoActivityException, InvalidParticipantException, WrongStateException, SystemException {
        this._coordManager.participantCompleted(participantId);
    }

    @Override
    public void participantFaulted(String participantId) throws NoActivityException, InvalidParticipantException, SystemException {
        this._coordManager.participantFaulted(participantId);
        try {
            this.setCancelOnly();
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    @Override
    public void participantCannotComplete(String participantId) throws NoActivityException, InvalidParticipantException, WrongStateException, SystemException {
        this._coordManager.participantCannotComplete(participantId);
        try {
            this.setCancelOnly();
        }
        catch (Exception ex) {
            throw new SystemException(ex.toString());
        }
    }

    @Override
    public ActivityHierarchy currentActivity() throws SystemException {
        return UserActivityFactory.userActivity().currentActivity();
    }

    @Override
    public CoordinatorId identifier() throws NoActivityException, SystemException {
        ActivityImple curr = this.current();
        if (curr == null) {
            throw new NoActivityException();
        }
        return this._coordManager.identifier();
    }

    public final ActivityImple current() {
        UserActivityImple imple = (UserActivityImple)UserActivityFactory.userActivity();
        return imple.current();
    }
}

