/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.http2;

import io.undertow.UndertowLogger;
import io.undertow.protocols.http2.ConnectionErrorException;
import io.undertow.protocols.http2.HpackDecoder;
import io.undertow.protocols.http2.HpackException;
import io.undertow.protocols.http2.Http2FrameHeaderParser;
import io.undertow.protocols.http2.Http2PushBackParser;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xnio.Bits;

abstract class Http2HeaderBlockParser
extends Http2PushBackParser
implements HpackDecoder.HeaderEmitter {
    private final HeaderMap headerMap = new HeaderMap();
    private boolean beforeHeadersHandled = false;
    private final HpackDecoder decoder;
    private int frameRemaining = -1;
    private boolean invalid = false;

    public Http2HeaderBlockParser(int frameLength, HpackDecoder decoder) {
        super(frameLength);
        this.decoder = decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleData(ByteBuffer resource, Http2FrameHeaderParser header) throws IOException {
        boolean continuationFramesComing = Bits.anyAreClear((int)header.flags, (int)4);
        if (this.frameRemaining == -1) {
            this.frameRemaining = header.length;
        }
        boolean moreDataThisFrame = resource.remaining() < this.frameRemaining;
        int pos = resource.position();
        try {
            if (!this.beforeHeadersHandled && !this.handleBeforeHeader(resource, header)) {
                return;
            }
            this.beforeHeadersHandled = true;
            this.decoder.setHeaderEmitter(this);
            try {
                this.decoder.decode(resource);
            }
            catch (HpackException e) {
                throw new ConnectionErrorException(9, (Throwable)e);
            }
        }
        finally {
            int used = resource.position() - pos;
            this.frameRemaining -= used;
        }
    }

    protected abstract boolean handleBeforeHeader(ByteBuffer var1, Http2FrameHeaderParser var2);

    HeaderMap getHeaderMap() {
        return this.headerMap;
    }

    @Override
    public void emitHeader(HttpString name, String value, boolean neverIndex) {
        this.headerMap.add(name, value);
        for (int i = 0; i < name.length(); ++i) {
            byte c = name.byteAt(i);
            if (c < 65 || c > 90) continue;
            this.invalid = true;
            UndertowLogger.REQUEST_LOGGER.debugf("Malformed request, header %s contains uppercase characters", name);
        }
    }

    @Override
    protected void moreData(int data) {
        super.moreData(data);
        this.frameRemaining += data;
    }

    public boolean isInvalid() {
        return this.invalid;
    }
}

