/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.extensions;

import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketLogger;
import io.undertow.websockets.core.WebSocketMessages;
import io.undertow.websockets.extensions.ExtensionByteBuffer;
import io.undertow.websockets.extensions.ExtensionFunction;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class PerMessageDeflateFunction
implements ExtensionFunction {
    private boolean compressContextTakeover;
    private boolean decompressContextTakeover;
    private final boolean client;
    private final int deflaterLevel;
    private Inflater decompress;
    private Deflater compress;
    private static final ThreadLocal<byte[][]> pool = new ThreadLocal<byte[][]>(){

        @Override
        protected byte[][] initialValue() {
            return new byte[2][];
        }
    };
    private byte[] input;
    private byte[] output;
    private static final int OFFSET = 64;
    public static final byte[] TAIL = new byte[]{0, 0, -1, -1};

    public PerMessageDeflateFunction(boolean client, int deflaterLevel, boolean compressContextTakeover, boolean decompressContextTakeover) {
        this.client = client;
        this.deflaterLevel = deflaterLevel;
        this.decompress = new Inflater(true);
        this.compress = new Deflater(this.deflaterLevel, true);
        this.compressContextTakeover = compressContextTakeover;
        this.decompressContextTakeover = decompressContextTakeover;
        this.input = null;
        this.output = null;
    }

    @Override
    public boolean isClient() {
        return this.client;
    }

    @Override
    public int writeRsv(int rsv) {
        return rsv | 4;
    }

    @Override
    public boolean hasExtensionOpCode() {
        return false;
    }

    @Override
    public void beforeWrite(StreamSinkFrameChannel channel, ExtensionByteBuffer extBuf, int position, int length) throws IOException {
        if (extBuf == null || length == 0) {
            return;
        }
        this.initBuffers(Math.max(extBuf.getInput().capacity(), length));
        for (int i = 0; i < length; ++i) {
            this.input[i] = extBuf.get(position + i);
        }
        this.compress.setInput(this.input, 0, length);
        while (!this.compress.needsInput() && !this.compress.finished()) {
            int n = this.compress.deflate(this.output, 0, this.output.length, 2);
            if (n == 0) continue;
            for (int i = 0; i < n; ++i) {
                extBuf.put(this.output[i]);
            }
        }
    }

    @Override
    public void beforeFlush(StreamSinkFrameChannel channel, ExtensionByteBuffer extBuf, int position, int length) throws IOException {
        extBuf.put((byte)0);
        if (!this.compressContextTakeover) {
            this.compress.reset();
        }
    }

    @Override
    public void afterRead(StreamSourceFrameChannel channel, ExtensionByteBuffer extBuf, int position, int length) throws IOException {
        int i;
        int n;
        if (extBuf == null) {
            return;
        }
        this.initBuffers(Math.max(extBuf.getInput().capacity(), length));
        if (length > 0) {
            for (int i2 = 0; i2 < length; ++i2) {
                this.input[i2] = extBuf.get(position + i2);
            }
            this.decompress.setInput(this.input, 0, length);
            while (!this.decompress.needsInput() && !this.decompress.finished()) {
                try {
                    n = this.decompress.inflate(this.output, 0, this.output.length);
                    if (n <= 0) continue;
                    for (i = 0; i < n; ++i) {
                        extBuf.put(this.output[i]);
                    }
                }
                catch (DataFormatException e) {
                    WebSocketLogger.EXTENSION_LOGGER.debug(e.getMessage(), e);
                    throw WebSocketMessages.MESSAGES.badCompressedPayload();
                }
            }
        }
        if (length == -1) {
            this.decompress.setInput(TAIL);
            while (!this.decompress.needsInput() && !this.decompress.finished()) {
                try {
                    n = this.decompress.inflate(this.output, 0, this.output.length);
                    if (n <= 0) continue;
                    for (i = 0; i < n; ++i) {
                        extBuf.put(this.output[i]);
                    }
                }
                catch (DataFormatException e) {
                    WebSocketLogger.EXTENSION_LOGGER.debug(e.getMessage(), e);
                    throw WebSocketMessages.MESSAGES.badCompressedPayload();
                }
            }
        }
        if (length == -1 && !this.decompressContextTakeover) {
            this.decompress.reset();
        }
    }

    private void initBuffers(int length) {
        if (this.input == null || this.output == null || this.input.length < length || this.output.length < length + 64) {
            if (pool.get()[0] == null || pool.get()[0].length < length) {
                PerMessageDeflateFunction.pool.get()[0] = new byte[length];
            }
            if (pool.get()[1] == null || pool.get()[1].length < length + 64) {
                PerMessageDeflateFunction.pool.get()[1] = new byte[length + 64];
            }
            this.input = pool.get()[0];
            this.output = pool.get()[1];
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PerMessageDeflateFunction)) {
            return false;
        }
        PerMessageDeflateFunction that = (PerMessageDeflateFunction)o;
        if (this.client != that.client) {
            return false;
        }
        if (this.compressContextTakeover != that.compressContextTakeover) {
            return false;
        }
        if (this.decompressContextTakeover != that.decompressContextTakeover) {
            return false;
        }
        return this.deflaterLevel == that.deflaterLevel;
    }

    public int hashCode() {
        int result = this.compressContextTakeover ? 1 : 0;
        result = 31 * result + (this.decompressContextTakeover ? 1 : 0);
        result = 31 * result + (this.client ? 1 : 0);
        result = 31 * result + this.deflaterLevel;
        return result;
    }
}

