/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.search.util.configuration.impl;

import java.util.Properties;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.StringHelper;
import org.infinispan.hibernate.search.impl.LoggerFactory;
import org.infinispan.hibernate.search.logging.Log;

public class ConfigurationParseHelper {
    private static final Log log = LoggerFactory.make();

    private ConfigurationParseHelper() {
    }

    public static Integer getIntValue(Properties cfg, String key) {
        String propValue = cfg.getProperty(key);
        if (propValue == null) {
            return null;
        }
        if (StringHelper.isEmpty((String)propValue.trim())) {
            throw log.configurationPropertyCantBeEmpty(key);
        }
        return ConfigurationParseHelper.parseInt(propValue, 0, "Unable to parse " + key + ": " + propValue);
    }

    public static final int parseInt(String value, int defValue, String errorMsgOnParseFailure) {
        if (StringHelper.isEmpty((String)value)) {
            return defValue;
        }
        return ConfigurationParseHelper.parseInt(value, errorMsgOnParseFailure);
    }

    public static int parseInt(String value, String errorMsgOnParseFailure) {
        if (value == null) {
            throw new SearchException(errorMsgOnParseFailure);
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nfe) {
            throw log.getInvalidIntegerValueException(errorMsgOnParseFailure, nfe);
        }
    }

    public static final boolean getBooleanValue(Properties cfg, String key, boolean defaultValue) {
        String propValue = cfg.getProperty(key);
        if (propValue == null) {
            return defaultValue;
        }
        return ConfigurationParseHelper.parseBoolean(propValue, "Property '" + key + "' needs to be either literal 'true' or 'false'");
    }

    public static final boolean parseBoolean(String value, String errorMsgOnParseFailure) {
        if (value == null) {
            throw new SearchException(errorMsgOnParseFailure);
        }
        if ("false".equalsIgnoreCase(value.trim())) {
            return false;
        }
        if ("true".equalsIgnoreCase(value.trim())) {
            return true;
        }
        throw new SearchException(errorMsgOnParseFailure);
    }

    public static final String getString(Properties cfg, String key, String defaultValue) {
        if (cfg == null) {
            return defaultValue;
        }
        String propValue = cfg.getProperty(key);
        return propValue == null ? defaultValue : propValue;
    }
}

