/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.auth;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.security.SecurityContext;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.mapping.MappingType;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.fed.WSTrustException;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.factories.JBossAuthCacheInvalidationFactory;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientFactory;
import org.picketlink.identity.federation.core.wstrust.STSClientPool;
import org.picketlink.identity.federation.core.wstrust.SamlCredential;
import org.picketlink.identity.federation.core.wstrust.auth.SecurityActions;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.w3c.dom.Element;

public abstract class AbstractSTSLoginModule
implements LoginModule {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String SHARED_TOKEN = "org.picketlink.identity.federation.core.wstrust.lm.stsToken";
    public static final String OPTIONS_CREDENTIALS = "useOptionsCredentials";
    public static final String OPTIONS_PW_STACKING = "password-stacking";
    public static final String STS_CONFIG_FILE = "configFile";
    public static final String ROLE_KEY = "roleKey";
    public static final String ENDPOINT_ADDRESS = "endpointAddress";
    public static final String PORT_NAME = "portName";
    public static final String SERVICE_NAME = "serviceName";
    public static final String USERNAME_KEY = "username";
    public static final String PASSWORD_KEY = "password";
    public static final String IS_BATCH = "isBatch";
    public static final String INITIAL_CLIENTS_IN_POOL = "initialClientsInPool";
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Element samlToken;
    protected boolean success;
    protected Map<String, ?> options;
    protected Map sharedState;
    protected boolean passwordStacking;
    protected boolean useFirstPass;
    protected boolean useOptionsCredentials;
    protected String roleKey = "Role";
    protected boolean enableCacheInvalidation = false;
    protected boolean injectCallerPrincipalGroup = false;
    protected String securityDomain = null;
    protected boolean isBatch = false;
    protected int initialClientsInPool = 0;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String initialClientsInPoolString;
        String batchIssueString;
        String callerPrincipalGroup;
        String cacheInvalidation;
        String roleKeyStr;
        Boolean useOptionsCreds;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.options = options;
        this.sharedState = sharedState;
        String pwStackingOption = (String)options.get(OPTIONS_PW_STACKING);
        boolean bl = this.passwordStacking = pwStackingOption != null;
        if (this.passwordStacking) {
            this.useFirstPass = "useFirstPass".equals(pwStackingOption);
        }
        if ((useOptionsCreds = Boolean.valueOf((String)options.get(OPTIONS_CREDENTIALS))) != null) {
            this.useOptionsCredentials = useOptionsCreds;
        }
        if ((roleKeyStr = (String)options.get(ROLE_KEY)) != null && roleKeyStr.length() > 0) {
            this.roleKey = roleKeyStr;
        }
        if ((cacheInvalidation = (String)options.get("cache.invalidation")) != null && !cacheInvalidation.isEmpty()) {
            this.enableCacheInvalidation = Boolean.parseBoolean(cacheInvalidation);
            this.securityDomain = (String)options.get("jboss.security.security_domain");
            if (this.securityDomain == null || this.securityDomain.isEmpty()) {
                throw logger.optionNotSet("jboss.security.security_domain");
            }
        }
        if ((callerPrincipalGroup = (String)options.get("inject.callerprincipal")) != null && !callerPrincipalGroup.isEmpty()) {
            this.injectCallerPrincipalGroup = Boolean.parseBoolean(callerPrincipalGroup);
        }
        if (StringUtil.isNotNull((String)(batchIssueString = (String)options.get(IS_BATCH)))) {
            this.isBatch = Boolean.parseBoolean(batchIssueString);
        }
        if (StringUtil.isNotNull((String)(initialClientsInPoolString = (String)options.get(INITIAL_CLIENTS_IN_POOL)))) {
            try {
                this.initialClientsInPool = Integer.parseInt(initialClientsInPoolString);
            }
            catch (Exception e) {
                logger.cannotParseParameterValue(initialClientsInPoolString, (Throwable)e);
            }
        }
    }

    @Override
    public boolean login() throws LoginException {
        STSClientPool pool;
        boolean bl;
        STSClient stsClient = null;
        try {
            STSClientConfig stsClientConfig;
            Element token;
            STSClientConfig.Builder builder = this.createBuilder();
            if (this.useOptionsCredentials) {
                this.useCredentialsFromOptions(builder, this.options);
            } else if (this.isUseFirstPass()) {
                this.useCredentialsFromSharedState(builder);
            } else {
                this.useCredentialsFromCallback(builder);
            }
            if (this.passwordStacking) {
                this.setPasswordStackingCredentials(builder);
            }
            if ((token = this.invokeSTS(stsClient = this.createWSTrustClient(stsClientConfig = builder.build()))) == null) {
                throw logger.authCouldNotIssueSAMLToken();
            }
            this.setSuccess(true);
            this.setSamlToken(token);
            this.setSharedToken(token);
            bl = true;
        }
        catch (WSTrustException e) {
            try {
                throw logger.authLoginError((Throwable)e);
            }
            catch (Throwable throwable) {
                STSClientPool pool2;
                if (stsClient != null && (pool2 = STSClientFactory.getInstance()) != null) {
                    pool2.returnClient(stsClient);
                }
                throw throwable;
            }
        }
        if (stsClient != null && (pool = STSClientFactory.getInstance()) != null) {
            pool.returnClient(stsClient);
        }
        return bl;
    }

    public abstract Element invokeSTS(STSClient var1) throws WSTrustException, LoginException;

    @Override
    public boolean commit() throws LoginException {
        if (this.success) {
            SamlCredential samlCredential = new SamlCredential(this.samlToken);
            boolean added = this.subject.getPublicCredentials().add(samlCredential);
            this.populateSubject();
            if (added) {
                logger.trace("Added Credential " + samlCredential);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        this.success = false;
        this.clearState();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.clearState();
        return true;
    }

    protected STSClientConfig.Builder createBuilder() {
        if (this.options.containsKey(STS_CONFIG_FILE)) {
            return new STSClientConfig.Builder(this.getRequiredOption(this.getOptions(), STS_CONFIG_FILE));
        }
        STSClientConfig.Builder builder = new STSClientConfig.Builder();
        builder.endpointAddress((String)this.options.get(ENDPOINT_ADDRESS));
        builder.portName((String)this.options.get(PORT_NAME)).serviceName((String)this.options.get(SERVICE_NAME));
        builder.username((String)this.options.get(USERNAME_KEY)).password((String)this.options.get(PASSWORD_KEY));
        builder.setBatch(this.isBatch);
        String passwordString = (String)this.options.get(PASSWORD_KEY);
        if (passwordString != null && passwordString.startsWith("MASK-")) {
            String salt = (String)this.options.get("salt");
            if (StringUtil.isNullOrEmpty((String)salt)) {
                throw logger.optionNotSet("Salt");
            }
            String iCount = (String)this.options.get("iterationCount");
            if (StringUtil.isNullOrEmpty((String)iCount)) {
                throw logger.optionNotSet("Iteration Count");
            }
            int iterationCount = Integer.parseInt(iCount);
            try {
                builder.password(StringUtil.decode((String)passwordString, (String)salt, (int)iterationCount));
            }
            catch (Exception e) {
                throw logger.unableToDecodePasswordError("Unable to decode password:" + passwordString);
            }
        }
        return builder;
    }

    protected void useCredentialsFromCallback(STSClientConfig.Builder builder) throws LoginException {
        NameCallback nameCallback = new NameCallback("user:");
        PasswordCallback passwordCallback = new PasswordCallback("password:", true);
        try {
            this.getCallbackHandler().handle(new Callback[]{nameCallback, passwordCallback});
            String userNameStr = nameCallback.getName();
            if (StringUtil.isNotNull((String)userNameStr)) {
                builder.username(userNameStr);
            } else {
                logger.trace("UserName from callback is null");
            }
            char[] passChars = passwordCallback.getPassword();
            if (passChars != null) {
                builder.password(new String(passChars));
            } else {
                logger.trace("Password from callback is null");
            }
        }
        catch (IOException e) {
            throw logger.authLoginError((Throwable)e);
        }
        catch (UnsupportedCallbackException e) {
            throw logger.authLoginError((Throwable)e);
        }
    }

    private void setPasswordStackingCredentials(STSClientConfig.Builder builder) {
        Map sharedState = this.sharedState;
        sharedState.put("javax.security.auth.login.name", builder.getUsername());
        sharedState.put("javax.security.auth.login.password", builder.getPassword());
    }

    protected void useCredentialsFromSharedState(STSClientConfig.Builder builder) {
        builder.username(this.getSharedUsername()).password(new String(this.getSharedPassword()));
    }

    protected void useCredentialsFromOptions(STSClientConfig.Builder builder, Map<String, ?> options2) {
    }

    protected STSClientConfig getConfiguration(Map<String, ?> options) {
        String configFile = this.getRequiredOption(options, STS_CONFIG_FILE);
        return new STSClientConfig.Builder(configFile).build();
    }

    protected STSClient createWSTrustClient(STSClientConfig config) {
        try {
            STSClientPool pool = STSClientFactory.getInstance();
            if (this.initialClientsInPool > 0) {
                pool.createPool(this.initialClientsInPool, config);
            }
            return pool.getClient(config);
        }
        catch (Exception e) {
            throw logger.authCouldNotCreateWSTrustClient((Throwable)e);
        }
    }

    protected String getRequiredOption(Map<String, ?> options, String optionName) {
        String option = (String)options.get(optionName);
        if (option == null) {
            throw logger.optionNotSet(optionName);
        }
        return option;
    }

    protected boolean isSuccess() {
        return this.success;
    }

    protected void setSuccess(boolean success) {
        this.success = success;
    }

    protected Subject getSubject() {
        return this.subject;
    }

    protected CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    protected void setSamlToken(Element samlToken) {
        this.samlToken = samlToken;
    }

    protected void setSharedToken(Object token) {
        if (this.sharedState == null) {
            return;
        }
        Map state = this.sharedState;
        state.put(SHARED_TOKEN, token);
    }

    protected Object getSharedToken() {
        if (this.sharedState == null) {
            return null;
        }
        return this.sharedState.get(SHARED_TOKEN);
    }

    protected Map<String, ?> getOptions() {
        return this.options;
    }

    protected String getSharedUsername() {
        if (this.sharedState == null) {
            return null;
        }
        Object sharedName = this.sharedState.get("javax.security.auth.login.name");
        if (sharedName == null) {
            return null;
        }
        if (sharedName instanceof String) {
            return (String)sharedName;
        }
        if (sharedName instanceof Principal) {
            return ((Principal)sharedName).getName();
        }
        throw new RuntimeException("sharedState javax.security.auth.login.name is supposed to contain String or Principal, but contains " + sharedName.getClass().getName());
    }

    protected char[] getSharedPassword() {
        if (this.sharedState == null) {
            return null;
        }
        Object object = this.sharedState.get("javax.security.auth.login.password");
        if (object instanceof char[]) {
            return (char[])object;
        }
        if (object instanceof String) {
            return ((String)object).toCharArray();
        }
        return null;
    }

    protected boolean isUseFirstPass() {
        return this.useFirstPass;
    }

    protected boolean isUsePasswordStacking() {
        return this.passwordStacking;
    }

    protected boolean isUseOptionsConfig() {
        return this.useOptionsCredentials;
    }

    private void clearState() {
        AbstractSTSLoginModule.removeAllSamlCredentials(this.subject);
        this.samlToken = null;
    }

    public static void removeAllSamlCredentials(Subject subject) {
        Set<SamlCredential> samlCredentials = subject.getPublicCredentials(SamlCredential.class);
        if (!samlCredentials.isEmpty()) {
            subject.getPublicCredentials().removeAll(samlCredentials);
        }
    }

    protected void populateSubject() {
        List<String> roles;
        MappingManager mappingManager = this.getMappingManager();
        if (mappingManager == null) {
            return;
        }
        MappingContext principalMappingContext = null;
        MappingContext roleMappingContext = null;
        try {
            principalMappingContext = mappingManager.getMappingContext(MappingType.PRINCIPAL.toString());
        }
        catch (NoSuchMethodError nse) {
            principalMappingContext = mappingManager.getMappingContext(Principal.class);
        }
        try {
            roleMappingContext = mappingManager.getMappingContext(MappingType.ROLE.toString());
        }
        catch (NoSuchMethodError nse) {
            roleMappingContext = mappingManager.getMappingContext(RoleGroup.class);
        }
        HashMap<String, Element> contextMap = new HashMap<String, Element>();
        contextMap.put(SHARED_TOKEN, this.samlToken);
        AssertionType assertion = null;
        try {
            assertion = SAMLUtil.fromElement(this.samlToken);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (principalMappingContext != null) {
            principalMappingContext.performMapping(contextMap, null);
            Principal principal = (Principal)principalMappingContext.getMappingResult().getMappedObject();
            this.subject.getPrincipals().add(principal);
            if (this.enableCacheInvalidation) {
                JBossAuthCacheInvalidationFactory.TimeCacheExpiry cacheExpiry = JBossAuthCacheInvalidationFactory.getCacheExpiry();
                XMLGregorianCalendar expiry = AssertionUtil.getExpiration(assertion);
                if (expiry != null) {
                    cacheExpiry.register(this.securityDomain, expiry.toGregorianCalendar().getTime(), principal);
                } else {
                    logger.samlAssertionWithoutExpiration(assertion.getID());
                }
            }
        }
        if (roleMappingContext != null) {
            roleMappingContext.performMapping(contextMap, null);
            RoleGroup group = (RoleGroup)roleMappingContext.getMappingResult().getMappedObject();
            SimpleGroup rolePrincipal = new SimpleGroup(group.getRoleName());
            for (Role role : group.getRoles()) {
                rolePrincipal.addMember((Principal)new SimplePrincipal(role.getRoleName()));
            }
            this.subject.getPrincipals().add((Principal)rolePrincipal);
        } else {
            ArrayList<String> roleKeys = new ArrayList<String>();
            roleKeys.addAll(StringUtil.tokenize((String)this.roleKey));
            roles = AssertionUtil.getRoles(assertion, roleKeys);
            if (roles.size() > 0) {
                SimpleGroup group = new SimpleGroup("Roles");
                for (String role : roles) {
                    group.addMember((Principal)new SimplePrincipal(role));
                }
                this.subject.getPrincipals().add((Principal)group);
            }
        }
        if (this.injectCallerPrincipalGroup) {
            SimpleGroup callerPrincipal = new SimpleGroup("CallerPrincipal");
            roles = AssertionUtil.getRoles(assertion, null);
            for (String string : roles) {
                callerPrincipal.addMember((Principal)new SimplePrincipal(string));
            }
            this.subject.getPrincipals().add((Principal)callerPrincipal);
        }
    }

    protected MappingManager getMappingManager() {
        SecurityContext securityContext = SecurityActions.getSecurityContext();
        if (securityContext == null) {
            return null;
        }
        return securityContext.getMappingManager();
    }
}

