/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.core;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionManager {
    private static final String SESSION_MANAGER = "SESSION_MANAGER";
    private final Map<String, HttpSession> registry = Collections.synchronizedMap(new HashMap());

    public static SessionManager get(ServletContext context) throws IllegalArgumentException {
        SessionManager sessionManager = (SessionManager)context.getAttribute(SESSION_MANAGER);
        if (sessionManager == null) {
            throw new IllegalArgumentException("No SessionManager found in the given ServletContext.");
        }
        return sessionManager;
    }

    public SessionManager(ServletContext context, InitializationCallback initializationCallback) {
        if (context.getAttribute(SESSION_MANAGER) != null) {
            throw new IllegalStateException("SessionManager already configured.");
        }
        context.setAttribute(SESSION_MANAGER, (Object)this);
        initializationCallback.registerSessionListener(SessionManagerListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Principal principal, HttpSession session) {
        session.setAttribute("picketlink.principal", (Object)principal);
        Map<String, HttpSession> map = this.registry;
        synchronized (map) {
            this.registry.put(principal.getName(), session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Principal principal) {
        Map<String, HttpSession> map = this.registry;
        synchronized (map) {
            String principalName = principal.getName();
            HttpSession session = this.registry.get(principalName);
            if (session != null) {
                Principal sessionPrincipal = this.getPrincipal(session);
                if (sessionPrincipal == null || !sessionPrincipal.getName().equals(principalName)) {
                    throw new RuntimeException("Principal [" + principalName + "] not associated with session [" + session.getId() + "] or session is associated with a different principal [" + sessionPrincipal.getName() + "].");
                }
                this.removeSession(session);
                session.invalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(HttpSession session) {
        Principal principal = this.getPrincipal(session);
        if (principal != null) {
            Map<String, HttpSession> map = this.registry;
            synchronized (map) {
                this.registry.remove(principal.getName());
            }
        }
    }

    private Principal getPrincipal(HttpSession session) {
        return (Principal)session.getAttribute("picketlink.principal");
    }

    public static interface InitializationCallback {
        public void registerSessionListener(Class<? extends HttpSessionListener> var1);
    }

    public static class SessionManagerListener
    implements HttpSessionListener {
        public void sessionCreated(HttpSessionEvent se) {
        }

        public void sessionDestroyed(HttpSessionEvent se) {
            SessionManager sessionManager = SessionManager.get(se.getSession().getServletContext());
            if (sessionManager != null) {
                sessionManager.removeSession(se.getSession());
            }
        }
    }
}

