/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.federation.IDPType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEvent;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.impl.EmptyRoleGenerator;
import org.picketlink.identity.federation.core.interfaces.RoleGenerator;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.picketlink.identity.federation.web.handlers.saml2.SecurityActions;

public class RolesGenerationHandler
extends BaseSAML2Handler {
    private transient RoleGenerator roleGenerator = new EmptyRoleGenerator();

    @Override
    public void initChainConfig(SAML2HandlerChainConfig handlerChainConfig) throws ConfigurationException {
        super.initChainConfig(handlerChainConfig);
        Object config = this.handlerChainConfig.getParameter("CONFIGURATION");
        if (config instanceof IDPType) {
            IDPType idpType = (IDPType)config;
            String roleGeneratorString = idpType.getRoleGenerator();
            this.insantiateRoleValidator(roleGeneratorString);
        }
    }

    @Override
    public void initHandlerConfig(SAML2HandlerConfig handlerConfig) throws ConfigurationException {
        super.initHandlerConfig(handlerConfig);
        String roleGeneratorString = (String)this.handlerConfig.getParameter("ATTRIBUTE_MANAGER");
        this.insantiateRoleValidator(roleGeneratorString);
    }

    @Override
    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getSAML2Object() instanceof LogoutRequestType) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.SP) {
            return;
        }
        HTTPContext httpContext = (HTTPContext)request.getContext();
        HttpSession session = httpContext.getRequest().getSession(false);
        Map<String, Object> requestOptions = request.getOptions();
        PicketLinkAuditHelper auditHelper = (PicketLinkAuditHelper)requestOptions.get("AUDIT_HELPER");
        String contextPath = (String)requestOptions.get("CONTEXT_PATH");
        Principal userPrincipal = (Principal)session.getAttribute("picketlink.principal");
        List<String> roles = (List<String>)session.getAttribute("picketlink.roles");
        if (roles == null) {
            roles = this.roleGenerator.generateRoles(userPrincipal);
            if (auditHelper != null) {
                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                auditEvent.setWhoIsAuditing(contextPath);
                auditEvent.setType(PicketLinkAuditEventType.GENERATED_ROLES);
                auditEvent.setOptionalString(userPrincipal.getName() + "(" + Arrays.toString(roles.toArray()) + ")");
                auditHelper.audit(auditEvent);
            }
            session.setAttribute("picketlink.roles", roles);
        }
        response.setRoles(roles);
    }

    private void insantiateRoleValidator(String attribStr) throws ConfigurationException {
        if (attribStr != null && !"".equals(attribStr)) {
            try {
                Class<?> clazz = SecurityActions.loadClass(this.getClass(), attribStr);
                this.roleGenerator = (RoleGenerator)clazz.newInstance();
                logger.trace("RoleGenerator set to " + this.roleGenerator);
            }
            catch (Exception e) {
                logger.samlHandlerRoleGeneratorSetupError((Throwable)e);
                throw logger.configurationError((Throwable)e);
            }
        }
    }
}

