/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Parameter;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Invalidation", description="Component responsible for invalidating entries on remote caches when entries are written to locally.")
public class InvalidationInterceptor
extends BaseRpcInterceptor
implements JmxStatisticsExposer {
    private final AtomicLong invalidations = new AtomicLong(0L);
    private CommandsFactory commandsFactory;
    private boolean statisticsEnabled;
    private static final Log log = LogFactory.getLog(InvalidationInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void injectDependencies(CommandsFactory commandsFactory) {
        this.commandsFactory = commandsFactory;
    }

    @Start
    private void start() {
        this.setStatisticsEnabled(this.cacheConfiguration.jmxStatistics().enabled());
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (!this.isPutForExternalRead(command)) {
            return this.handleInvalidate(ctx, command, command.getKey());
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleInvalidate(ctx, command, command.getKey());
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (!this.isLocalModeForced(command) && ctx.isOriginLocal()) {
            this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(this.defaultSynchronous));
        }
        return retval;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object[] keys = command.getMap() == null ? null : command.getMap().keySet().toArray();
        return this.handleInvalidate(ctx, command, keys);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        log.tracef("Entering InvalidationInterceptor's prepare phase.  Ctx flags are empty", new Object[0]);
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            if (ctx.getTransaction() == null) {
                throw new IllegalStateException("We must have an associated transaction");
            }
            List<WriteCommand> mods = Arrays.asList(command.getModifications());
            this.broadcastInvalidateForPrepare(mods, ctx);
        } else {
            log.tracef("Nothing to invalidate - no modifications in the transaction.", new Object[0]);
        }
        return retval;
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (ctx.isOriginLocal()) {
            boolean sync = !command.isUnlock();
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(this.rpcManager.getTransport().getMembers());
            this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(sync));
        }
        return retVal;
    }

    private Object handleInvalidate(InvocationContext ctx, WriteCommand command, Object ... keys) throws Throwable {
        Object retval = this.invokeNextInterceptor(ctx, command);
        if (command.isSuccessful() && !ctx.isInTxScope() && keys != null && keys.length != 0 && !this.isLocalModeForced(command)) {
            this.invalidateAcrossCluster(this.isSynchronous(command), keys, ctx);
        }
        return retval;
    }

    private void broadcastInvalidateForPrepare(List<WriteCommand> modifications, InvocationContext ctx) throws Throwable {
        if (ctx.isInTxScope()) {
            if (modifications.isEmpty()) {
                return;
            }
            InvalidationFilterVisitor filterVisitor = new InvalidationFilterVisitor(modifications.size());
            filterVisitor.visitCollection(null, modifications);
            if (filterVisitor.containsPutForExternalRead) {
                log.debug("Modification list contains a putForExternalRead operation.  Not invalidating.");
            } else if (filterVisitor.containsLocalModeFlag) {
                log.debug("Modification list contains a local mode flagged operation.  Not invalidating.");
            } else {
                try {
                    this.invalidateAcrossCluster(this.defaultSynchronous, filterVisitor.result.toArray(), ctx);
                }
                catch (Throwable t) {
                    log.unableToRollbackEvictionsDuringPrepare(t);
                    if (t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    throw new RuntimeException("Unable to broadcast invalidation messages", t);
                }
            }
        }
    }

    private void invalidateAcrossCluster(boolean synchronous, Object[] keys, InvocationContext ctx) throws Throwable {
        this.incrementInvalidations();
        InvalidateCommand invalidateCommand = this.commandsFactory.buildInvalidateCommand(InfinispanCollections.emptySet(), keys);
        if (log.isDebugEnabled()) {
            log.debug("Cache [" + this.rpcManager.getAddress() + "] replicating " + invalidateCommand);
        }
        VisitableCommand command = invalidateCommand;
        if (ctx.isInTxScope()) {
            TxInvocationContext txCtx = (TxInvocationContext)ctx;
            command = this.commandsFactory.buildPrepareCommand(txCtx.getGlobalTransaction(), Collections.singletonList(invalidateCommand), true);
        }
        this.rpcManager.invokeRemotely(null, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(synchronous));
    }

    private void incrementInvalidations() {
        if (this.statisticsEnabled) {
            this.invalidations.incrementAndGet();
        }
    }

    private boolean isPutForExternalRead(FlagAffectedCommand command) {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            log.trace("Put for external read called.  Suppressing clustered invalidation.");
            return true;
        }
        return false;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.invalidations.set(0L);
    }

    @Override
    @ManagedAttribute(displayName="Statistics enabled", description="Enables or disables the gathering of statistics by this component", dataType=DataType.TRAIT, writable=true)
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(@Parameter(name="enabled", description="Whether statistics should be enabled or disabled (true/false)") boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @ManagedAttribute(description="Number of invalidations", displayName="Number of invalidations", measurementType=MeasurementType.TRENDSUP)
    public long getInvalidations() {
        return this.invalidations.get();
    }

    public static class InvalidationFilterVisitor
    extends AbstractVisitor {
        Set<Object> result;
        public boolean containsPutForExternalRead = false;
        public boolean containsLocalModeFlag = false;

        public InvalidationFilterVisitor(int maxSetSize) {
            this.result = new HashSet<Object>(maxSetSize);
        }

        private void processCommand(FlagAffectedCommand command) {
            this.containsLocalModeFlag = this.containsLocalModeFlag || command.getFlags() != null && command.getFlags().contains((Object)Flag.CACHE_MODE_LOCAL);
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.processCommand(command);
            this.containsPutForExternalRead = this.containsPutForExternalRead || command.getFlags() != null && command.getFlags().contains((Object)Flag.PUT_FOR_EXTERNAL_READ);
            this.result.add(command.getKey());
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            this.processCommand(command);
            this.result.add(command.getKey());
            return null;
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            this.processCommand(command);
            this.result.addAll(command.getAffectedKeys());
            return null;
        }
    }
}

