/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.TimeoutValidationResponseFilter;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.concurrent.TimeoutException;

public class SelfDeliverFilter
implements TimeoutValidationResponseFilter {
    private final Address localAddress;
    private boolean selfDelivered;

    public SelfDeliverFilter(Address localAddress) {
        this.localAddress = localAddress;
        this.selfDelivered = false;
    }

    @Override
    public boolean isAcceptable(Response response, Address sender) {
        if (sender.equals(this.localAddress)) {
            this.selfDelivered = true;
        }
        return true;
    }

    @Override
    public boolean needMoreResponses() {
        return !this.selfDelivered;
    }

    @Override
    public void validate() throws TimeoutException {
        if (!this.selfDelivered) {
            throw new TimeoutException("Timeout waiting for member " + this.localAddress);
        }
    }
}

