/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.audit;

import java.util.Arrays;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.audit.AbstractFileAuditLogHandler;
import org.jboss.as.controller.audit.AuditLogHandler;
import org.jboss.as.controller.audit.FileAuditLogHandler;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.audit.AuditLogHandlerResourceDefinition;
import org.jboss.as.domain.management.audit.HandlerUtil;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class FileAuditLogHandlerResourceDefinition
extends AuditLogHandlerResourceDefinition {
    public static final SimpleAttributeDefinition PATH = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("path", ModelType.STRING).setAllowNull(false)).setAllowExpression(true)).setMinSize(1)).build();
    public static final SimpleAttributeDefinition RELATIVE_TO = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("relative-to", ModelType.STRING).setAllowNull(true)).setMinSize(1)).build();
    protected static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{FORMATTER, PATH, RELATIVE_TO, MAX_FAILURE_COUNT};

    public FileAuditLogHandlerResourceDefinition(ManagedAuditLogger auditLogger, PathManagerService pathManager) {
        super(auditLogger, pathManager, PathElement.pathElement((String)"file-handler"), DomainManagementResolver.getDeprecatedResolver("core.management.audit-log", "core.management.file-handler"), (OperationStepHandler)new FileAuditLogHandlerAddHandler(auditLogger, pathManager, ATTRIBUTES), (OperationStepHandler)new AuditLogHandlerResourceDefinition.HandlerRemoveHandler(auditLogger));
        this.setDeprecated(ModelVersion.create((int)1, (int)7));
    }

    public FileAuditLogHandlerResourceDefinition(ManagedAuditLogger auditLogger, PathManagerService pathManager, PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        super(auditLogger, pathManager, pathElement, descriptionResolver, addHandler, removeHandler);
    }

    public static ModelNode createServerAddOperation(PathAddress address, ModelNode fileHandler) {
        ModelNode add = Util.createAddOperation((PathAddress)address);
        for (AttributeDefinition def : ATTRIBUTES) {
            if (!fileHandler.get(def.getName()).isDefined()) continue;
            add.get(def.getName()).set(fileHandler.get(def.getName()));
        }
        return add;
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        HandlerWriteAttributeHandler write = this.getWriteAttributeHandler(this.auditLogger, this.pathManager, ATTRIBUTES);
        for (AttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute(def, null, (OperationStepHandler)write);
        }
    }

    protected HandlerWriteAttributeHandler getWriteAttributeHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition ... attributeDefinitions) {
        return new HandlerWriteAttributeHandler(auditLogger, pathManager, attributeDefinitions);
    }

    private static FileAuditLogHandler createFileAuditLogHandler(PathManagerService pathManager, OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = Util.getNameFromAddress((ModelNode)operation.require("address"));
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        String relativeTo = model.hasDefined(RELATIVE_TO.getName()) ? RELATIVE_TO.resolveModelAttribute(context, model).asString() : null;
        String path = PATH.resolveModelAttribute(context, model).asString();
        String formatterName = FORMATTER.resolveModelAttribute(context, model).asString();
        int maxFailureCount = MAX_FAILURE_COUNT.resolveModelAttribute(context, model).asInt();
        return new FileAuditLogHandler(name, formatterName, maxFailureCount, pathManager, path, relativeTo);
    }

    protected static <T> T[] joinArrays(T[] array1, T[] array2) {
        if (array2 == null) {
            return array1;
        }
        if (array1 == null) {
            return array2;
        }
        T[] joinedArrays = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, joinedArrays, array1.length, array2.length);
        return joinedArrays;
    }

    protected static class HandlerWriteAttributeHandler
    extends AuditLogHandlerResourceDefinition.HandlerWriteAttributeHandler {
        public HandlerWriteAttributeHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition ... attributeDefinitions) {
            super(auditLogger, pathManager, attributeDefinitions);
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected AbstractFileAuditLogHandler createHandler(PathManagerService pathManager, OperationContext context, ModelNode operation) throws OperationFailedException {
            return FileAuditLogHandlerResourceDefinition.createFileAuditLogHandler(pathManager, context, operation);
        }

        protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
            if (!super.handleApplyAttributeRuntime(context, operation, attributeName, resolvedValue, currentValue, handbackHolder)) {
                this.auditLogger.getUpdater().updateHandler((AuditLogHandler)this.createHandler(this.pathManager, context, operation));
            }
            return false;
        }

        protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
            if (!super.handlerRevertUpdateToRuntime(context, operation, attributeName, valueToRestore, valueToRevert, handback)) {
                this.auditLogger.getUpdater().rollbackChanges();
            }
        }
    }

    protected static class FileAuditLogHandlerAddHandler
    extends AbstractAddStepHandler {
        protected final ManagedAuditLogger auditLogger;
        protected final PathManagerService pathManager;

        protected FileAuditLogHandlerAddHandler(ManagedAuditLogger auditLogger, PathManagerService pathManager, AttributeDefinition[] attributes) {
            super(attributes);
            this.auditLogger = auditLogger;
            this.pathManager = pathManager;
        }

        protected void populateModel(OperationContext context, ModelNode operation, final Resource resource) throws OperationFailedException {
            super.populateModel(context, operation, resource);
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    HandlerUtil.checkNoOtherHandlerWithTheSameName(context);
                    String formatterName = resource.getModel().get(AuditLogHandlerResourceDefinition.FORMATTER.getName()).asString();
                    if (!HandlerUtil.lookForFormatter(context, context.getCurrentAddress(), formatterName)) {
                        throw DomainManagementLogger.ROOT_LOGGER.noFormatterCalled(formatterName);
                    }
                }
            }, OperationContext.Stage.MODEL);
        }

        protected boolean requiresRuntime(OperationContext context) {
            return true;
        }

        protected AbstractFileAuditLogHandler createHandler(PathManagerService pathManager, OperationContext context, ModelNode operation) throws OperationFailedException {
            return FileAuditLogHandlerResourceDefinition.createFileAuditLogHandler(pathManager, context, operation);
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.auditLogger.getUpdater().addHandler((AuditLogHandler)this.createHandler(this.pathManager, context, operation));
        }

        protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
            this.auditLogger.getUpdater().rollbackChanges();
        }
    }
}

