/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.controller;

import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class FindNonProgressingOperationHandler
implements OperationStepHandler {
    private static final AttributeDefinition STABILITY_TIMEOUT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"timeout", (ModelType)ModelType.INT, (boolean)false).setDefaultValue(new ModelNode(15))).setValidator((ParameterValidator)new IntRangeValidator(0, true))).setMeasurementUnit(MeasurementUnit.SECONDS)).build();
    static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("find-non-progressing-operation", DomainManagementResolver.getResolver("core", "management-operations")).setReplyType(ModelType.STRING).withFlag(OperationEntry.Flag.HOST_CONTROLLER_ONLY).build();
    static final OperationStepHandler INSTANCE = new FindNonProgressingOperationHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        long timeout = TimeUnit.SECONDS.toNanos(STABILITY_TIMEOUT.resolveModelAttribute(context, operation).asLong());
        DomainManagementLogger.ROOT_LOGGER.debugf("Identification of operation not progressing after [%d] ns has been requested", timeout);
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode result = context.getResult();
        for (Resource.ResourceEntry child : resource.getChildren("active-operation")) {
            ModelNode model = child.getModel();
            if (model.get("exclusive-running-time").asLong() <= timeout) continue;
            result.set(child.getName());
            break;
        }
    }
}

