/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.login.LoginException;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.SubjectIdentity;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.KeytabService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedSetValue;

class KeytabIdentityFactoryService
implements Service<KeytabIdentityFactoryService> {
    private static final String SERVICE_SUFFIX = "keytab_factory";
    private final InjectedSetValue<KeytabService> keytabServices = new InjectedSetValue();
    private volatile KeytabService defaultService = null;
    private volatile Map<String, KeytabService> hostServiceMap = null;

    KeytabIdentityFactoryService() {
    }

    public void start(StartContext context) throws StartException {
        Set services = this.keytabServices.getValue();
        this.hostServiceMap = new HashMap<String, KeytabService>(services.size());
        for (KeytabService current : services) {
            for (String currentHost : current.getForHosts()) {
                if ("*".equals(currentHost)) {
                    if (this.defaultService != null) continue;
                    this.defaultService = current;
                    continue;
                }
                if (this.hostServiceMap.containsKey(currentHost)) continue;
                this.hostServiceMap.put(currentHost, current);
            }
        }
        for (KeytabService current : services) {
            int end;
            int start;
            String currentHost;
            String principal = current.getPrincipal();
            currentHost = principal.substring((start = principal.indexOf(47)) > -1 ? start + 1 : 0, (end = principal.indexOf(64)) > -1 ? end : principal.length() - 1);
            if (!this.hostServiceMap.containsKey(currentHost)) {
                this.hostServiceMap.put(currentHost, current);
            }
            if ((principal = principal.substring(0, end > -1 ? end : principal.length() - 1)).equals(currentHost) || this.hostServiceMap.containsKey(principal)) continue;
            this.hostServiceMap.put(principal, current);
        }
    }

    public void stop(StopContext context) {
        this.defaultService = null;
        this.hostServiceMap = null;
    }

    public KeytabIdentityFactoryService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    Injector<KeytabService> getKeytabInjector() {
        return this.keytabServices.injector();
    }

    SubjectIdentity getSubjectIdentity(String protocol, String forHost) {
        KeytabService selectedService = null;
        String name = protocol + "/" + forHost;
        selectedService = this.hostServiceMap.get(name);
        if (selectedService == null) {
            DomainManagementLogger.SECURITY_LOGGER.tracef("No mapping for name '%s' to KeytabService, attempting to use host only match.", name);
            selectedService = this.hostServiceMap.get(forHost);
            if (selectedService == null) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("No mapping for host '%s' to KeytabService, attempting to use default.", forHost);
                selectedService = this.defaultService;
            }
        }
        if (selectedService != null) {
            if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("Selected KeytabService with principal '%s' for host '%s'", selectedService.getPrincipal(), forHost);
            }
            try {
                return selectedService.createSubjectIdentity(false);
            }
            catch (LoginException e) {
                DomainManagementLogger.SECURITY_LOGGER.keytabLoginFailed(selectedService.getPrincipal(), forHost, e);
            }
        } else {
            DomainManagementLogger.SECURITY_LOGGER.tracef("No KeytabService available for host '%s' unable to return SubjectIdentity.", forHost);
        }
        return null;
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{KeytabIdentityFactoryService.SERVICE_SUFFIX});
        }

        public static ServiceBuilder<?> addDependency(ServiceBuilder<?> sb, Injector<KeytabIdentityFactoryService> injector, String realmName) {
            ServiceBuilder.DependencyType type = ServiceBuilder.DependencyType.REQUIRED;
            sb.addDependency(type, ServiceUtil.createServiceName(realmName), KeytabIdentityFactoryService.class, injector);
            return sb;
        }
    }
}

