/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapReferralException;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.LdapConnectionHandler;
import org.jboss.as.domain.management.security.LdapEntry;
import org.jboss.as.domain.management.security.LdapSearcher;

class LdapUserSearcherFactory {
    protected static final int searchTimeLimit = 10000;

    LdapUserSearcherFactory() {
    }

    static LdapSearcher<LdapEntry, String> createForUsernameIsDn() {
        return new LdapSearcher<LdapEntry, String>(){

            @Override
            public LdapEntry search(LdapConnectionHandler connectionHandler, String suppliedName) {
                return new LdapEntry(suppliedName, suppliedName);
            }
        };
    }

    static LdapSearcher<LdapEntry, String> createForUsernameFilter(String baseDn, boolean recursive, String userDnAttribute, String attribute, String usernameLoad) {
        return new LdapUserSearcherImpl(baseDn, recursive, userDnAttribute, attribute, null, usernameLoad);
    }

    static LdapSearcher<LdapEntry, String> createForAdvancedFilter(String baseDn, boolean recursive, String userDnAttribute, String filter, String usernameLoad) {
        return new LdapUserSearcherImpl(baseDn, recursive, userDnAttribute, null, filter, usernameLoad);
    }

    private static class LdapUserSearcherImpl
    implements LdapSearcher<LdapEntry, String> {
        final String baseDn;
        final boolean recursive;
        final String userDnAttribute;
        final String userNameAttribute;
        final String advancedFilter;
        final String usernameLoad;

        private LdapUserSearcherImpl(String baseDn, boolean recursive, String userDnAttribute, String userNameAttribute, String advancedFilter, String usernameLoad) {
            this.baseDn = baseDn;
            this.recursive = recursive;
            this.userDnAttribute = userDnAttribute;
            this.userNameAttribute = userNameAttribute;
            this.advancedFilter = advancedFilter;
            this.usernameLoad = usernameLoad;
            if (DomainManagementLogger.SECURITY_LOGGER.isTraceEnabled()) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("LdapUserSearcherImpl baseDn=%s", baseDn);
                DomainManagementLogger.SECURITY_LOGGER.tracef("LdapUserSearcherImpl recursive=%b", recursive);
                DomainManagementLogger.SECURITY_LOGGER.tracef("LdapUserSearcherImpl userDnAttribute=%s", userDnAttribute);
                DomainManagementLogger.SECURITY_LOGGER.tracef("LdapUserSearcherImpl userNameAttribute=%s", userNameAttribute);
                DomainManagementLogger.SECURITY_LOGGER.tracef("LdapUserSearcherImpl advancedFilter=%s", advancedFilter);
                DomainManagementLogger.SECURITY_LOGGER.tracef("LdapUserSearcherImpl usernameLoad=%s", usernameLoad);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LdapEntry search(LdapConnectionHandler connectionHandler, String suppliedName) throws IOException, NamingException {
            NamingEnumeration<SearchResult> searchEnumeration = null;
            try {
                URI fullUri;
                SearchControls searchControls = new SearchControls();
                if (this.recursive) {
                    DomainManagementLogger.SECURITY_LOGGER.trace("Performing recursive search");
                    searchControls.setSearchScope(2);
                } else {
                    DomainManagementLogger.SECURITY_LOGGER.trace("Performing single level search");
                    searchControls.setSearchScope(1);
                }
                if (this.usernameLoad == null) {
                    searchControls.setReturningAttributes(new String[]{this.userDnAttribute});
                } else {
                    searchControls.setReturningAttributes(new String[]{this.userDnAttribute, this.usernameLoad});
                }
                searchControls.setTimeLimit(10000);
                Object[] filterArguments = new Object[]{suppliedName};
                String filter = this.userNameAttribute != null ? "(" + this.userNameAttribute + "={0})" : this.advancedFilter;
                DomainManagementLogger.SECURITY_LOGGER.tracef("Searching for user '%s' using filter '%s'.", suppliedName, filter);
                String distinguishedUserDN = null;
                String username = this.usernameLoad == null ? suppliedName : null;
                URI referralAddress = null;
                Attributes attributes = null;
                LdapConnectionHandler currentConnectionHandler = connectionHandler;
                searchEnumeration = currentConnectionHandler.getConnection().search(this.baseDn, filter, filterArguments, searchControls);
                try {
                    if (!searchEnumeration.hasMore()) {
                        DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found in directory.", suppliedName);
                        throw DomainManagementLogger.SECURITY_LOGGER.userNotFoundInDirectory(suppliedName);
                    }
                }
                catch (LdapReferralException e) {
                    Object info = e.getReferralInfo();
                    try {
                        fullUri = new URI(info.toString());
                        referralAddress = new URI(fullUri.getScheme(), null, fullUri.getHost(), fullUri.getPort(), null, null, null);
                        distinguishedUserDN = fullUri.getPath().substring(1);
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Received referral with address '%s' for dn '%s'", referralAddress.toString(), distinguishedUserDN);
                        currentConnectionHandler = currentConnectionHandler.findForReferral(referralAddress);
                        if (currentConnectionHandler == null) {
                            DomainManagementLogger.SECURITY_LOGGER.tracef("Unable to follow referral to '%s' for user '%s'", fullUri, suppliedName);
                            throw DomainManagementLogger.SECURITY_LOGGER.userNotFoundInDirectory(suppliedName);
                        }
                    }
                    catch (URISyntaxException ue) {
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Unable to construct URI from referral: %s", info);
                        throw DomainManagementLogger.SECURITY_LOGGER.nameNotFound(suppliedName);
                    }
                    DirContext context = currentConnectionHandler.getConnection();
                    attributes = context.getAttributes(distinguishedUserDN, searchControls.getReturningAttributes());
                }
                SearchResult result = null;
                if (attributes == null) {
                    result = searchEnumeration.next();
                    if (!result.isRelative()) {
                        String name = result.getName();
                        try {
                            fullUri = new URI(name);
                            referralAddress = new URI(fullUri.getScheme(), null, fullUri.getHost(), fullUri.getPort(), null, null, null);
                            distinguishedUserDN = fullUri.getPath().substring(1);
                            DomainManagementLogger.SECURITY_LOGGER.tracef("Received referral with address '%s' for dn '%s'", referralAddress.toString(), distinguishedUserDN);
                        }
                        catch (URISyntaxException usi) {
                            DomainManagementLogger.SECURITY_LOGGER.tracef("Unable to construct URI from referral name: %s", name);
                            throw DomainManagementLogger.SECURITY_LOGGER.nameNotFound(suppliedName);
                        }
                    }
                    attributes = result.getAttributes();
                }
                if (attributes != null) {
                    Attribute usernameAttr;
                    Attribute dn;
                    if (distinguishedUserDN == null && (dn = attributes.get(this.userDnAttribute)) != null) {
                        distinguishedUserDN = (String)dn.get();
                    }
                    if (this.usernameLoad != null && (usernameAttr = attributes.get(this.usernameLoad)) != null) {
                        username = (String)usernameAttr.get();
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Converted username '%s' to '%s'", suppliedName, username);
                    }
                }
                if (distinguishedUserDN == null && result != null) {
                    distinguishedUserDN = result.getName() + ("".equals(this.baseDn) ? "" : "," + this.baseDn);
                }
                if (username == null) {
                    throw DomainManagementLogger.SECURITY_LOGGER.usernameNotLoaded(suppliedName);
                }
                DomainManagementLogger.SECURITY_LOGGER.tracef("DN '%s' found for user '%s'", distinguishedUserDN, username);
                LdapEntry ldapEntry = new LdapEntry(username, distinguishedUserDN, referralAddress);
                return ldapEntry;
            }
            finally {
                if (searchEnumeration != null) {
                    try {
                        searchEnumeration.close();
                    }
                    catch (Exception ignored) {}
                }
            }
        }
    }
}

