/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

class WrapperSSLContext
extends SSLContext {
    WrapperSSLContext(SSLContext toWrap, String[] enabledCipherSuites, String[] enabledProtocols) {
        super(new WrapperSpi(toWrap, enabledCipherSuites, enabledProtocols), toWrap.getProvider(), toWrap.getProtocol());
    }

    private static class WrapperSpi
    extends SSLContextSpi {
        private final String[] enabledCipherSuites;
        private final String[] enabledProtocols;
        private final SSLContext wrapped;

        private WrapperSpi(SSLContext wrapped, String[] enabledCipherSuites, String[] enabledProtocols) {
            this.wrapped = wrapped;
            this.enabledCipherSuites = enabledCipherSuites;
            this.enabledProtocols = enabledProtocols;
        }

        @Override
        protected SSLEngine engineCreateSSLEngine() {
            SSLEngine engine = this.wrapped.createSSLEngine();
            this.setSslParams(engine);
            return engine;
        }

        @Override
        protected SSLEngine engineCreateSSLEngine(String host, int port) {
            SSLEngine engine = this.wrapped.createSSLEngine(host, port);
            this.setSslParams(engine);
            return engine;
        }

        private void setSslParams(SSLEngine engine) {
            if (this.enabledCipherSuites.length > 0) {
                engine.setEnabledCipherSuites(this.enabledCipherSuites);
            }
            if (this.enabledProtocols.length > 0) {
                engine.setEnabledProtocols(this.enabledProtocols);
            }
        }

        @Override
        protected SSLSessionContext engineGetClientSessionContext() {
            return this.wrapped.getClientSessionContext();
        }

        @Override
        protected SSLSessionContext engineGetServerSessionContext() {
            return this.wrapped.getServerSessionContext();
        }

        @Override
        protected SSLServerSocketFactory engineGetServerSocketFactory() {
            return new WrapperSSLServerSocketFactory(this.wrapped.getServerSocketFactory());
        }

        @Override
        protected SSLSocketFactory engineGetSocketFactory() {
            return new WrapperSSLSocketFactory(this.wrapped.getSocketFactory());
        }

        @Override
        protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
            this.wrapped.init(km, tm, sr);
        }

        private class WrapperSSLServerSocketFactory
        extends SSLServerSocketFactory {
            private final SSLServerSocketFactory wrapped;

            private WrapperSSLServerSocketFactory(SSLServerSocketFactory wrapped) {
                this.wrapped = wrapped;
            }

            @Override
            public String[] getDefaultCipherSuites() {
                return this.wrapped.getDefaultCipherSuites();
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return this.wrapped.getSupportedCipherSuites();
            }

            @Override
            public ServerSocket createServerSocket(int port) throws IOException {
                ServerSocket socket = this.wrapped.createServerSocket(port);
                this.setSslParams(socket);
                return socket;
            }

            @Override
            public ServerSocket createServerSocket(int port, int backlog) throws IOException {
                ServerSocket socket = this.wrapped.createServerSocket(port, backlog);
                this.setSslParams(socket);
                return socket;
            }

            @Override
            public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
                ServerSocket socket = this.wrapped.createServerSocket(port, backlog, ifAddress);
                this.setSslParams(socket);
                return socket;
            }

            private void setSslParams(ServerSocket socket) {
                if (socket instanceof SSLServerSocket) {
                    SSLServerSocket sslSocket = (SSLServerSocket)socket;
                    if (WrapperSpi.this.enabledCipherSuites.length > 0) {
                        sslSocket.setEnabledCipherSuites(WrapperSpi.this.enabledCipherSuites);
                    }
                    if (WrapperSpi.this.enabledProtocols.length > 0) {
                        sslSocket.setEnabledProtocols(WrapperSpi.this.enabledProtocols);
                    }
                }
            }
        }

        private class WrapperSSLSocketFactory
        extends SSLSocketFactory {
            private final SSLSocketFactory wrapped;

            private WrapperSSLSocketFactory(SSLSocketFactory wrapped) {
                this.wrapped = wrapped;
            }

            @Override
            public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
                Socket socket = this.wrapped.createSocket(s, host, port, autoClose);
                this.setSslParams(socket);
                return socket;
            }

            @Override
            public String[] getDefaultCipherSuites() {
                return this.wrapped.getDefaultCipherSuites();
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return this.wrapped.getSupportedCipherSuites();
            }

            @Override
            public Socket createSocket(String host, int port) throws IOException {
                Socket socket = this.wrapped.createSocket(host, port);
                this.setSslParams(socket);
                return socket;
            }

            @Override
            public Socket createSocket(InetAddress host, int port) throws IOException {
                Socket socket = this.wrapped.createSocket(host, port);
                this.setSslParams(socket);
                return socket;
            }

            @Override
            public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
                Socket socket = this.wrapped.createSocket(host, port, localHost, localPort);
                this.setSslParams(socket);
                return socket;
            }

            @Override
            public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                Socket socket = this.wrapped.createSocket(address, port, localAddress, localPort);
                this.setSslParams(socket);
                return socket;
            }

            private void setSslParams(Socket socket) {
                if (socket instanceof SSLSocket) {
                    SSLSocket sslSocket = (SSLSocket)socket;
                    if (WrapperSpi.this.enabledCipherSuites.length > 0) {
                        sslSocket.setEnabledCipherSuites(WrapperSpi.this.enabledCipherSuites);
                    }
                    if (WrapperSpi.this.enabledProtocols.length > 0) {
                        sslSocket.setEnabledProtocols(WrapperSpi.this.enabledProtocols);
                    }
                }
            }
        }
    }
}

