/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentFactory;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.interceptors.UserInterceptorFactory;
import org.jboss.as.ee.managedbean.component.ManagedBeanComponentDescription;
import org.jboss.as.ee.weld.WeldDeploymentMarker;
import org.jboss.as.ejb3.component.EJBComponentDescription;
import org.jboss.as.ejb3.component.stateful.SerializedCdiInterceptorsKey;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.WeldStartService;
import org.jboss.as.weld.deployment.WeldClassIntrospector;
import org.jboss.as.weld.ejb.EjbRequestScopeActivationInterceptor;
import org.jboss.as.weld.ejb.Jsr299BindingsCreateInterceptor;
import org.jboss.as.weld.ejb.Jsr299BindingsInterceptor;
import org.jboss.as.weld.ejb.WeldInterceptorBindingsService;
import org.jboss.as.weld.injection.WeldComponentService;
import org.jboss.as.weld.injection.WeldConstructionStartInterceptor;
import org.jboss.as.weld.injection.WeldInjectionContextInterceptor;
import org.jboss.as.weld.injection.WeldInjectionInterceptor;
import org.jboss.as.weld.injection.WeldInterceptorInjectionInterceptor;
import org.jboss.as.weld.injection.WeldManagedReferenceFactory;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.util.Utils;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.weld.ejb.spi.InterceptorBindings;

public class WeldComponentIntegrationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        final DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(Attachments.CLASS_INDEX);
        if (!WeldDeploymentMarker.isWeldDeployment((DeploymentUnit)deploymentUnit)) {
            return;
        }
        DeploymentUnit topLevelDeployment = Utils.getRootDeploymentUnit(deploymentUnit);
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(org.jboss.as.ee.component.Attachments.EE_MODULE_DESCRIPTION);
        final ServiceName weldBootstrapService = topLevelDeployment.getServiceName().append(WeldBootstrapService.SERVICE_NAME);
        final ServiceName weldStartService = topLevelDeployment.getServiceName().append(WeldStartService.SERVICE_NAME);
        WeldClassIntrospector.install(deploymentUnit, phaseContext.getServiceTarget());
        eeModuleDescription.setDefaultClassIntrospectorServiceName(WeldClassIntrospector.serviceName(deploymentUnit));
        for (ComponentDescription component : eeModuleDescription.getComponentDescriptions()) {
            final String beanName = component instanceof EJBComponentDescription ? component.getComponentName() : null;
            component.getConfigurators().addFirst(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    Class componentClass = configuration.getComponentClass();
                    DeploymentUnit deploymentUnit = context.getDeploymentUnit();
                    ModuleClassLoader classLoader = ((Module)deploymentUnit.getAttachment(Attachments.MODULE)).getClassLoader();
                    HashSet<Class> interceptorClasses = new HashSet<Class>();
                    for (InterceptorDescription interceptorDescription : description.getAllInterceptors()) {
                        try {
                            ClassIndex index = classIndex.classIndex(interceptorDescription.getInterceptorClassName());
                            interceptorClasses.add(index.getModuleClass());
                        }
                        catch (ClassNotFoundException e) {
                            throw WeldLogger.ROOT_LOGGER.couldNotLoadInterceptorClass(interceptorDescription.getInterceptorClassName(), e);
                        }
                    }
                    WeldComponentIntegrationProcessor.this.addWeldIntegration(context.getServiceTarget(), configuration, description, componentClass, beanName, weldBootstrapService, weldStartService, interceptorClasses, (ClassLoader)classLoader, description.getBeanDeploymentArchiveId());
                    if (description instanceof StatefulComponentDescription) {
                        configuration.getInterceptorContextKeys().add(SerializedCdiInterceptorsKey.class);
                    }
                }
            });
        }
    }

    private void addWeldIntegration(ServiceTarget target, ComponentConfiguration configuration, ComponentDescription description, Class<?> componentClass, String beanName, ServiceName weldServiceName, ServiceName weldStartService, Set<Class<?>> interceptorClasses, ClassLoader classLoader, String beanDeploymentArchiveId) {
        final ServiceName serviceName = configuration.getComponentDescription().getServiceName().append(new String[]{"WeldInstantiator"});
        final WeldComponentService weldComponentService = new WeldComponentService(componentClass, beanName, interceptorClasses, classLoader, beanDeploymentArchiveId, description.isCDIInterceptorEnabled(), description);
        ServiceBuilder builder = target.addService(serviceName, (Service)weldComponentService).addDependency(weldServiceName, WeldBootstrapService.class, weldComponentService.getWeldContainer()).addDependency(weldStartService);
        configuration.setInstanceFactory((ComponentFactory)WeldManagedReferenceFactory.INSTANCE);
        configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>(){

            public void configureDependency(ServiceBuilder<?> serviceBuilder, ComponentStartService service) throws DeploymentUnitProcessingException {
                serviceBuilder.addDependency(serviceName);
            }
        });
        if (description instanceof EJBComponentDescription) {
            ServiceName bindingServiceName = this.addWeldInterceptorBindingService(target, configuration, componentClass, beanName, weldServiceName, weldStartService, beanDeploymentArchiveId);
            EjbRequestScopeActivationInterceptor.Factory requestFactory = new EjbRequestScopeActivationInterceptor.Factory(weldServiceName);
            configuration.addComponentInterceptor((InterceptorFactory)requestFactory, 800, false);
            this.addJsr299BindingsCreateInterceptor(configuration, description, beanName, weldServiceName, (ServiceBuilder<WeldComponentService>)builder, bindingServiceName);
            this.addCommonLifecycleInterceptionSupport(configuration, (ServiceBuilder<WeldComponentService>)builder, bindingServiceName, weldServiceName);
            configuration.addComponentInterceptor((InterceptorFactory)new UserInterceptorFactory(Jsr299BindingsInterceptor.factory(InterceptionType.AROUND_INVOKE, builder, bindingServiceName), Jsr299BindingsInterceptor.factory(InterceptionType.AROUND_TIMEOUT, builder, bindingServiceName)), 2816, false);
            if (description.isPassivationApplicable()) {
                configuration.addPrePassivateInterceptor(Jsr299BindingsInterceptor.factory(InterceptionType.PRE_PASSIVATE, builder, bindingServiceName), 1536);
                configuration.addPostActivateInterceptor(Jsr299BindingsInterceptor.factory(InterceptionType.POST_ACTIVATE, builder, bindingServiceName), 1536);
            }
        } else if (description instanceof ManagedBeanComponentDescription) {
            ServiceName bindingServiceName = this.addWeldInterceptorBindingService(target, configuration, componentClass, beanName, weldServiceName, weldStartService, beanDeploymentArchiveId);
            this.addJsr299BindingsCreateInterceptor(configuration, description, beanName, weldServiceName, (ServiceBuilder<WeldComponentService>)builder, bindingServiceName);
            this.addCommonLifecycleInterceptionSupport(configuration, (ServiceBuilder<WeldComponentService>)builder, bindingServiceName, weldServiceName);
            configuration.addComponentInterceptor((InterceptorFactory)new UserInterceptorFactory(Jsr299BindingsInterceptor.factory(InterceptionType.AROUND_INVOKE, builder, bindingServiceName), Jsr299BindingsInterceptor.factory(InterceptionType.AROUND_TIMEOUT, builder, bindingServiceName)), 2816, false);
        } else if (!Utils.isComponentWithView(description)) {
            description.setIgnoreLifecycleInterceptors(true);
            configuration.addPostConstructInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new AbstractInjectionTargetDelegatingInterceptor(){

                @Override
                protected void run(Object instance) {
                    weldComponentService.getInjectionTarget().postConstruct(instance);
                }
            }), 4096);
            configuration.addPreDestroyInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new AbstractInjectionTargetDelegatingInterceptor(){

                @Override
                protected void run(Object instance) {
                    weldComponentService.getInjectionTarget().preDestroy(instance);
                }
            }), 2816);
        }
        builder.install();
        configuration.addPostConstructInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new WeldInjectionContextInterceptor(weldComponentService)), 768);
        configuration.addPostConstructInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new WeldInterceptorInjectionInterceptor(interceptorClasses)), 2304);
        configuration.addPostConstructInterceptor(WeldInjectionInterceptor.FACTORY, 3328);
    }

    private ServiceName addWeldInterceptorBindingService(ServiceTarget target, ComponentConfiguration configuration, Class<?> componentClass, String beanName, ServiceName weldServiceName, ServiceName weldStartService, String beanDeploymentArchiveId) {
        WeldInterceptorBindingsService weldInterceptorBindingsService = new WeldInterceptorBindingsService(beanDeploymentArchiveId, beanName, componentClass);
        ServiceName bindingServiceName = configuration.getComponentDescription().getServiceName().append(WeldInterceptorBindingsService.SERVICE_NAME);
        target.addService(bindingServiceName, (Service)weldInterceptorBindingsService).addDependency(weldServiceName, WeldBootstrapService.class, weldInterceptorBindingsService.getWeldContainer()).addDependency(weldStartService).install();
        return bindingServiceName;
    }

    private void addJsr299BindingsCreateInterceptor(ComponentConfiguration configuration, ComponentDescription description, String beanName, ServiceName weldServiceName, ServiceBuilder<WeldComponentService> builder, ServiceName bindingServiceName) {
        Jsr299BindingsCreateInterceptor createInterceptor = new Jsr299BindingsCreateInterceptor(description.getBeanDeploymentArchiveId(), beanName);
        configuration.addPostConstructInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)createInterceptor), 1664);
        builder.addDependency(weldServiceName, WeldBootstrapService.class, createInterceptor.getWeldContainer());
        builder.addDependency(bindingServiceName, InterceptorBindings.class, createInterceptor.getInterceptorBindings());
    }

    private void addCommonLifecycleInterceptionSupport(ComponentConfiguration configuration, ServiceBuilder<WeldComponentService> builder, ServiceName bindingServiceName, ServiceName weldServiceName) {
        configuration.addPreDestroyInterceptor(Jsr299BindingsInterceptor.factory(InterceptionType.PRE_DESTROY, builder, bindingServiceName), 2816);
        configuration.addAroundConstructInterceptor(Jsr299BindingsInterceptor.factory(InterceptionType.AROUND_CONSTRUCT, builder, bindingServiceName), 3072);
        configuration.addPostConstructInterceptor(Jsr299BindingsInterceptor.factory(InterceptionType.POST_CONSTRUCT, builder, bindingServiceName), 4096);
        EjbRequestScopeActivationInterceptor.Factory postConstructRequestContextActivationFactory = new EjbRequestScopeActivationInterceptor.Factory(weldServiceName);
        configuration.addPostConstructInterceptor((InterceptorFactory)postConstructRequestContextActivationFactory, 3712);
        configuration.addAroundConstructInterceptor((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)WeldConstructionStartInterceptor.INSTANCE), 2560);
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static abstract class AbstractInjectionTargetDelegatingInterceptor
    implements Interceptor {
        private AbstractInjectionTargetDelegatingInterceptor() {
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            ManagedReference reference = (ManagedReference)((ComponentInstance)context.getPrivateData(ComponentInstance.class)).getInstanceData(BasicComponentInstance.INSTANCE_KEY);
            if (reference != null) {
                this.run(reference.getInstance());
            }
            return context.proceed();
        }

        protected abstract void run(Object var1);
    }
}

