/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.discovery;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.weld.discovery.AnnotationType;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.as.weld.util.Indices;
import org.jboss.as.weld.util.Reflections;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.weld.bootstrap.api.BootstrapService;
import org.jboss.weld.resources.spi.AnnotationDiscovery;
import org.jboss.weld.resources.spi.ExtendedAnnotationDiscovery;

public class WeldAnnotationDiscovery
implements ExtendedAnnotationDiscovery,
BootstrapService {
    private static final DotName INHERITED_NAME = DotName.createSimple((String)Inherited.class.getName());
    private static final DotName OBJECT_NAME = DotName.createSimple((String)Object.class.getName());
    private CompositeIndex index;
    private final LoadingCache<Class<? extends Annotation>, Set<AnnotationType>> annotatedAnnotations = CacheBuilder.newBuilder().build((CacheLoader)new LoadAnnotatedAnnotations());

    public WeldAnnotationDiscovery(CompositeIndex index) {
        this.index = index;
    }

    public boolean containsAnnotation(Class<?> javaClass, Class<? extends Annotation> requiredAnnotation) {
        if (this.index == null) {
            throw WeldLogger.ROOT_LOGGER.cannotUseAtRuntime(AnnotationDiscovery.class.getSimpleName());
        }
        DotName className = DotName.createSimple((String)javaClass.getName());
        DotName requiredAnnotationName = DotName.createSimple((String)requiredAnnotation.getName());
        return this.containsAnnotation(className, requiredAnnotationName, javaClass, requiredAnnotation);
    }

    private boolean containsAnnotation(DotName className, DotName requiredAnnotationName, Class<?> originalClass, Class<? extends Annotation> requiredAnnotation) {
        ClassInfo clazz = this.index.getClassByName(className);
        if (clazz == null) {
            return Reflections.containsAnnotation(originalClass, requiredAnnotation);
        }
        if (clazz.annotations().containsKey(requiredAnnotationName)) {
            return true;
        }
        for (DotName annotation : clazz.annotations().keySet()) {
            ClassInfo annotationClassInfo = this.index.getClassByName(annotation);
            if (annotationClassInfo != null) {
                if (!annotationClassInfo.annotations().containsKey(requiredAnnotationName)) continue;
                return true;
            }
            try {
                Class<?> annotationClass = originalClass.getClassLoader().loadClass(annotation.toString());
                if (!annotationClass.isAnnotationPresent(requiredAnnotation)) continue;
                return true;
            }
            catch (ClassNotFoundException ignored) {
            }
        }
        DotName superName = clazz.superName();
        return superName != null && !OBJECT_NAME.equals((Object)superName) && this.containsAnnotation(superName, requiredAnnotationName, originalClass, requiredAnnotation);
    }

    public Set<String> getAnnotationsAnnotatedWith(Class<? extends Annotation> annotation) {
        if (this.index == null) {
            throw WeldLogger.ROOT_LOGGER.cannotUseAtRuntime(ExtendedAnnotationDiscovery.class.getSimpleName());
        }
        try {
            return ImmutableSet.copyOf((Collection)Collections2.transform((Collection)((Collection)this.annotatedAnnotations.get(annotation)), AnnotationType.TO_FQCN));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanupAfterBoot() {
        this.annotatedAnnotations.cleanUp();
        this.index = null;
    }

    public void cleanup() {
        this.cleanupAfterBoot();
    }

    private class LoadAnnotatedAnnotations
    extends CacheLoader<Class<? extends Annotation>, Set<AnnotationType>> {
        private LoadAnnotatedAnnotations() {
        }

        public Set<AnnotationType> load(Class<? extends Annotation> key) throws Exception {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (AnnotationInstance instance : WeldAnnotationDiscovery.this.index.getAnnotations(DotName.createSimple((String)key.getName()))) {
                ClassInfo clazz;
                AnnotationTarget target = instance.target();
                if (!(target instanceof ClassInfo) || !Indices.isAnnotation(clazz = (ClassInfo)target)) continue;
                builder.add((Object)new AnnotationType(clazz.name(), clazz.annotations().containsKey(INHERITED_NAME)));
            }
            return builder.build();
        }
    }
}

