/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.compensations.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.narayana.compensations.api.NoTransactionException;
import org.jboss.narayana.compensations.api.TransactionLoggedHandler;
import org.jboss.narayana.compensations.api.TxLogged;
import org.jboss.narayana.compensations.impl.BAControler;
import org.jboss.narayana.compensations.impl.BAControllerFactory;
import org.jboss.narayana.compensations.impl.ParticipantInterceptor;
import org.jboss.narayana.compensations.impl.ParticipantManager;

@TxLogged
@Interceptor
@Priority(value=198)
public class TxLoggedInterceptor
extends ParticipantInterceptor {
    @Override
    @AroundInvoke
    public Object intercept(InvocationContext ic) throws Exception {
        return super.intercept(ic);
    }

    @Override
    protected ParticipantManager enlistParticipant(Method method) throws Exception {
        BAControler baControler = BAControllerFactory.getInstance();
        if (!baControler.isBARunning()) {
            throw new NoTransactionException("Methods annotated with '" + TxLogged.class.getName() + "' must be invoked in the context of a compensation based transaction");
        }
        Class<? extends TransactionLoggedHandler> transactionLogHandler = this.getTransactionLoggedHandler(method);
        return baControler.enlist(null, null, transactionLogHandler);
    }

    private Class<? extends TransactionLoggedHandler> getTransactionLoggedHandler(Method method) {
        Annotation[] annotations;
        for (Annotation a : annotations = method.getAnnotations()) {
            if (!(a instanceof TxLogged)) continue;
            return ((TxLogged)a).value();
        }
        return null;
    }
}

