/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.authentication.levels.internal;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.picketlink.authentication.levels.Level;
import org.picketlink.authentication.levels.SecurityLevelManager;
import org.picketlink.authentication.levels.SecurityLevelResolver;
import org.picketlink.authentication.levels.annotations.DefaultSecurityLevel;
import org.picketlink.producer.LevelFactoryResolver;

@ApplicationScoped
public class DefaultSecurityLevelManager
implements SecurityLevelManager {
    private Level defaultSecurityLevel;
    @Inject
    @DefaultSecurityLevel
    private Instance<Level> levelInstance;
    @Inject
    @Any
    private Instance<SecurityLevelResolver> resolverInstances;
    @Inject
    private LevelFactoryResolver lfr;

    @Inject
    public void init() {
        this.defaultSecurityLevel = this.levelInstance.isUnsatisfied() ? this.lfr.resolve().createLevel("1") : (Level)this.levelInstance.get();
    }

    public Level resolveSecurityLevel() {
        Level highestLevel = this.defaultSecurityLevel;
        for (SecurityLevelResolver resolver : this.resolverInstances) {
            Level level = resolver.resolve();
            if (highestLevel.compareTo(level) >= 0) continue;
            highestLevel = level;
        }
        return highestLevel;
    }
}

