/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.renewer;

import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.ws.handler.MessageContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.SignatureProperties;
import org.apache.cxf.sts.cache.CacheUtils;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.token.provider.ConditionsProvider;
import org.apache.cxf.sts.token.provider.DefaultConditionsProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.realm.SAMLRealm;
import org.apache.cxf.sts.token.renewer.TokenRenewer;
import org.apache.cxf.sts.token.renewer.TokenRenewerParameters;
import org.apache.cxf.sts.token.renewer.TokenRenewerResponse;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractSamlPolicyValidator;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.builder.SAML1ComponentBuilder;
import org.apache.wss4j.common.saml.builder.SAML2ComponentBuilder;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml1.core.Conditions;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAMLTokenRenewer
implements TokenRenewer {
    public static final long DEFAULT_MAX_EXPIRY = 1800L;
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLTokenRenewer.class);
    private boolean signToken = true;
    private ConditionsProvider conditionsProvider = new DefaultConditionsProvider();
    private Map<String, SAMLRealm> realmMap = new HashMap<String, SAMLRealm>();
    private long maxExpiry = 1800L;
    private boolean verifyProofOfPossession = true;
    private boolean allowRenewalAfterExpiry;

    @Override
    public boolean canHandleToken(ReceivedToken renewTarget) {
        return this.canHandleToken(renewTarget, null);
    }

    @Override
    public boolean canHandleToken(ReceivedToken renewTarget, String realm) {
        if (realm != null && !this.realmMap.containsKey(realm)) {
            return false;
        }
        Object token = renewTarget.getToken();
        if (token instanceof Element) {
            Element tokenElement = (Element)token;
            String namespace = tokenElement.getNamespaceURI();
            String localname = tokenElement.getLocalName();
            if (("urn:oasis:names:tc:SAML:1.0:assertion".equals(namespace) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(namespace)) && "Assertion".equals(localname)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setVerifyProofOfPossession(boolean verifyProofOfPossession) {
        this.verifyProofOfPossession = verifyProofOfPossession;
    }

    public boolean isAllowRenewalAfterExpiry() {
        return this.allowRenewalAfterExpiry;
    }

    @Override
    public void setAllowRenewalAfterExpiry(boolean allowRenewalAfterExpiry) {
        this.allowRenewalAfterExpiry = allowRenewalAfterExpiry;
    }

    public void setMaxExpiry(long newExpiry) {
        this.maxExpiry = newExpiry;
    }

    public long getMaxExpiry() {
        return this.maxExpiry;
    }

    @Override
    public TokenRenewerResponse renewToken(TokenRenewerParameters tokenParameters) {
        TokenRenewerResponse response = new TokenRenewerResponse();
        ReceivedToken tokenToRenew = tokenParameters.getToken();
        if (tokenToRenew == null || tokenToRenew.getToken() == null || tokenToRenew.getState() != ReceivedToken.STATE.EXPIRED && tokenToRenew.getState() != ReceivedToken.STATE.VALID) {
            LOG.log(Level.WARNING, "The token to renew is null or invalid");
            throw new STSException("The token to renew is null or invalid", STSException.INVALID_REQUEST);
        }
        TokenStore tokenStore = tokenParameters.getTokenStore();
        if (tokenStore == null) {
            LOG.log(Level.FINE, "A cache must be configured to use the SAMLTokenRenewer");
            throw new STSException("Can't renew SAML assertion", STSException.REQUEST_FAILED);
        }
        try {
            SamlAssertionWrapper assertion = new SamlAssertionWrapper((Element)tokenToRenew.getToken());
            byte[] oldSignature = assertion.getSignatureValue();
            int hash = Arrays.hashCode(oldSignature);
            SecurityToken cachedToken = tokenStore.getToken(Integer.toString(hash));
            if (cachedToken == null) {
                LOG.log(Level.FINE, "The token to be renewed must be stored in the cache");
                throw new STSException("Can't renew SAML assertion", STSException.REQUEST_FAILED);
            }
            this.validateAssertion(assertion, tokenToRenew, cachedToken, tokenParameters);
            SamlAssertionWrapper renewedAssertion = new SamlAssertionWrapper(assertion.getXmlObject());
            String oldId = this.createNewId(renewedAssertion);
            tokenStore.remove(oldId);
            tokenStore.remove(Integer.toString(hash));
            this.createNewConditions(renewedAssertion, tokenParameters);
            this.signAssertion(renewedAssertion, tokenParameters);
            Document doc = DOMUtils.createDocument();
            Element token = renewedAssertion.toDOM(doc);
            if (renewedAssertion.getSaml1() != null) {
                token.setIdAttributeNS(null, "AssertionID", true);
            } else {
                token.setIdAttributeNS(null, "ID", true);
            }
            doc.appendChild(token);
            this.storeTokenInCache(tokenStore, renewedAssertion, tokenParameters.getPrincipal(), tokenParameters);
            response.setToken(token);
            response.setTokenId(renewedAssertion.getId());
            DateTime validFrom = null;
            DateTime validTill = null;
            if (renewedAssertion.getSamlVersion().equals(SAMLVersion.VERSION_20)) {
                validFrom = renewedAssertion.getSaml2().getConditions().getNotBefore();
                validTill = renewedAssertion.getSaml2().getConditions().getNotOnOrAfter();
            } else {
                validFrom = renewedAssertion.getSaml1().getConditions().getNotBefore();
                validTill = renewedAssertion.getSaml1().getConditions().getNotOnOrAfter();
            }
            response.setCreated(validFrom.toDate());
            response.setExpires(validTill.toDate());
            LOG.fine("SAML Token successfully renewed");
            return response;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "", ex);
            throw new STSException("Can't renew SAML assertion", (Throwable)ex, STSException.REQUEST_FAILED);
        }
    }

    public void setConditionsProvider(ConditionsProvider conditionsProvider) {
        this.conditionsProvider = conditionsProvider;
    }

    public ConditionsProvider getConditionsProvider() {
        return this.conditionsProvider;
    }

    public boolean isSignToken() {
        return this.signToken;
    }

    public void setSignToken(boolean signToken) {
        this.signToken = signToken;
    }

    public void setRealmMap(Map<String, SAMLRealm> realms) {
        this.realmMap = realms;
    }

    public Map<String, SAMLRealm> getRealmMap() {
        return this.realmMap;
    }

    private void validateAssertion(SamlAssertionWrapper assertion, ReceivedToken tokenToRenew, SecurityToken token, TokenRenewerParameters tokenParameters) throws WSSecurityException {
        String appliesToAddress;
        Properties props = token.getProperties();
        if (props == null) {
            LOG.log(Level.WARNING, "Error in getting properties from cached token");
            throw new STSException("Error in getting properties from cached token", STSException.REQUEST_FAILED);
        }
        String isAllowRenewal = (String)props.get("org.apache.cxf.sts.token.renewing.allow");
        String isAllowRenewalAfterExpiry = (String)props.get("org.apache.cxf.sts.token.renewing.allow.after.expiry");
        if (isAllowRenewal == null || !Boolean.valueOf(isAllowRenewal).booleanValue()) {
            LOG.log(Level.WARNING, "The token is not allowed to be renewed");
            throw new STSException("The token is not allowed to be renewed", STSException.REQUEST_FAILED);
        }
        if (tokenToRenew.getState() == ReceivedToken.STATE.EXPIRED) {
            if (!this.allowRenewalAfterExpiry || isAllowRenewalAfterExpiry == null || !Boolean.valueOf(isAllowRenewalAfterExpiry).booleanValue()) {
                LOG.log(Level.WARNING, "Renewal after expiry is not allowed");
                throw new STSException("Renewal after expiry is not allowed", STSException.REQUEST_FAILED);
            }
            DateTime expiryDate = this.getExpiryDate(assertion);
            DateTime currentDate = new DateTime();
            if (currentDate.getMillis() - expiryDate.getMillis() > this.maxExpiry * 1000L) {
                LOG.log(Level.WARNING, "The token expired too long ago to be renewed");
                throw new STSException("The token expired too long ago to be renewed", STSException.REQUEST_FAILED);
            }
        }
        ProofOfPossessionValidator popValidator = new ProofOfPossessionValidator();
        if (this.verifyProofOfPossession) {
            STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
            Crypto sigCrypto = stsProperties.getSignatureCrypto();
            CallbackHandler callbackHandler = stsProperties.getCallbackHandler();
            RequestData requestData = new RequestData();
            requestData.setSigVerCrypto(sigCrypto);
            WSSConfig wssConfig = WSSConfig.getNewInstance();
            requestData.setWssConfig(wssConfig);
            requestData.setCallbackHandler(callbackHandler);
            WSDocInfo docInfo = new WSDocInfo(((Element)tokenToRenew.getToken()).getOwnerDocument());
            assertion.parseSubject((SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(requestData, docInfo), sigCrypto, callbackHandler);
            SAMLKeyInfo keyInfo = assertion.getSubjectKeyInfo();
            if (keyInfo == null) {
                keyInfo = new SAMLKeyInfo((byte[])null);
            }
            if (!popValidator.checkProofOfPossession(tokenParameters, keyInfo)) {
                throw new STSException("Failed to verify the proof of possession of the key associated with the saml token. No matching key found in the request.", STSException.INVALID_REQUEST);
            }
        }
        if ((appliesToAddress = tokenParameters.getAppliesToAddress()) != null) {
            if (assertion.getSaml1() != null) {
                List restrConditions = assertion.getSaml1().getConditions().getAudienceRestrictionConditions();
                if (!this.matchSaml1AudienceRestriction(appliesToAddress, restrConditions)) {
                    LOG.log(Level.WARNING, "The AppliesTo address does not match the Audience Restriction");
                    throw new STSException("The AppliesTo address does not match the Audience Restriction", STSException.INVALID_REQUEST);
                }
            } else {
                List audienceRestrs = assertion.getSaml2().getConditions().getAudienceRestrictions();
                if (!this.matchSaml2AudienceRestriction(appliesToAddress, audienceRestrs)) {
                    LOG.log(Level.WARNING, "The AppliesTo address does not match the Audience Restriction");
                    throw new STSException("The AppliesTo address does not match the Audience Restriction", STSException.INVALID_REQUEST);
                }
            }
        }
    }

    private boolean matchSaml1AudienceRestriction(String appliesTo, List<AudienceRestrictionCondition> restrConditions) {
        boolean found = false;
        if (restrConditions != null && !restrConditions.isEmpty()) {
            for (AudienceRestrictionCondition restrCondition : restrConditions) {
                if (restrCondition.getAudiences() == null) continue;
                for (org.opensaml.saml1.core.Audience audience : restrCondition.getAudiences()) {
                    if (!appliesTo.equals(audience.getUri())) continue;
                    return true;
                }
            }
        }
        return found;
    }

    private boolean matchSaml2AudienceRestriction(String appliesTo, List<AudienceRestriction> audienceRestrictions) {
        boolean found = false;
        if (audienceRestrictions != null && !audienceRestrictions.isEmpty()) {
            for (AudienceRestriction audienceRestriction : audienceRestrictions) {
                if (audienceRestriction.getAudiences() == null) continue;
                for (Audience audience : audienceRestriction.getAudiences()) {
                    if (!appliesTo.equals(audience.getAudienceURI())) continue;
                    return true;
                }
            }
        }
        return found;
    }

    private void signAssertion(SamlAssertionWrapper assertion, TokenRenewerParameters tokenParameters) throws Exception {
        if (this.signToken) {
            String signatureAlgorithm;
            STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
            Crypto signatureCrypto = stsProperties.getSignatureCrypto();
            CallbackHandler callbackHandler = stsProperties.getCallbackHandler();
            SignatureProperties signatureProperties = stsProperties.getSignatureProperties();
            String alias = stsProperties.getSignatureUsername();
            String realm = tokenParameters.getRealm();
            SAMLRealm samlRealm = null;
            if (realm != null && this.realmMap.containsKey(realm)) {
                samlRealm = this.realmMap.get(realm);
            }
            if (samlRealm != null) {
                if (samlRealm.getSignatureCrypto() != null) {
                    LOG.fine("SAMLRealm signature keystore used");
                    signatureCrypto = samlRealm.getSignatureCrypto();
                    callbackHandler = samlRealm.getCallbackHandler();
                    alias = samlRealm.getSignatureAlias();
                }
                if (samlRealm.getSignatureProperties() != null) {
                    signatureProperties = samlRealm.getSignatureProperties();
                }
            }
            if ((signatureAlgorithm = tokenParameters.getKeyRequirements().getSignatureAlgorithm()) == null) {
                signatureAlgorithm = signatureProperties.getSignatureAlgorithm();
            } else {
                List<String> supportedAlgorithms = signatureProperties.getAcceptedSignatureAlgorithms();
                if (!supportedAlgorithms.contains(signatureAlgorithm)) {
                    signatureAlgorithm = signatureProperties.getSignatureAlgorithm();
                    LOG.fine("SignatureAlgorithm not supported, defaulting to: " + signatureAlgorithm);
                }
            }
            String c14nAlgorithm = tokenParameters.getKeyRequirements().getC14nAlgorithm();
            if (c14nAlgorithm == null) {
                c14nAlgorithm = signatureProperties.getC14nAlgorithm();
            } else {
                List<String> supportedAlgorithms = signatureProperties.getAcceptedC14nAlgorithms();
                if (!supportedAlgorithms.contains(c14nAlgorithm)) {
                    c14nAlgorithm = signatureProperties.getC14nAlgorithm();
                    LOG.fine("C14nAlgorithm not supported, defaulting to: " + c14nAlgorithm);
                }
            }
            if ((alias == null || "".equals(alias)) && signatureCrypto != null) {
                alias = signatureCrypto.getDefaultX509Identifier();
                LOG.fine("Signature alias is null so using default alias: " + alias);
            }
            WSPasswordCallback[] cb = new WSPasswordCallback[]{new WSPasswordCallback(alias, 3)};
            LOG.fine("Creating SAML Token");
            callbackHandler.handle((Callback[])cb);
            String password = cb[0].getPassword();
            LOG.fine("Signing SAML Token");
            boolean useKeyValue = signatureProperties.isUseKeyValue();
            assertion.signAssertion(alias, password, signatureCrypto, useKeyValue, c14nAlgorithm, signatureAlgorithm);
        } else if (assertion.getSaml1().getSignature() != null) {
            assertion.getSaml1().setSignature(null);
        } else if (assertion.getSaml2().getSignature() != null) {
            assertion.getSaml2().setSignature(null);
        }
    }

    private void createNewConditions(SamlAssertionWrapper assertion, TokenRenewerParameters tokenParameters) {
        ConditionsBean conditions = this.conditionsProvider.getConditions(this.convertToProviderParameters(tokenParameters));
        if (assertion.getSaml1() != null) {
            org.opensaml.saml1.core.Assertion saml1Assertion = assertion.getSaml1();
            saml1Assertion.setIssueInstant(new DateTime());
            Conditions saml1Conditions = SAML1ComponentBuilder.createSamlv1Conditions((ConditionsBean)conditions);
            saml1Assertion.setConditions(saml1Conditions);
        } else {
            Assertion saml2Assertion = assertion.getSaml2();
            saml2Assertion.setIssueInstant(new DateTime());
            org.opensaml.saml2.core.Conditions saml2Conditions = SAML2ComponentBuilder.createConditions((ConditionsBean)conditions);
            saml2Assertion.setConditions(saml2Conditions);
        }
    }

    private TokenProviderParameters convertToProviderParameters(TokenRenewerParameters renewerParameters) {
        TokenProviderParameters providerParameters = new TokenProviderParameters();
        providerParameters.setAppliesToAddress(renewerParameters.getAppliesToAddress());
        providerParameters.setEncryptionProperties(renewerParameters.getEncryptionProperties());
        providerParameters.setKeyRequirements(renewerParameters.getKeyRequirements());
        providerParameters.setPrincipal(renewerParameters.getPrincipal());
        providerParameters.setRealm(renewerParameters.getRealm());
        providerParameters.setStsProperties(renewerParameters.getStsProperties());
        providerParameters.setTokenRequirements(renewerParameters.getTokenRequirements());
        providerParameters.setTokenStore(renewerParameters.getTokenStore());
        providerParameters.setWebServiceContext(renewerParameters.getWebServiceContext());
        Map<String, Object> additionalProperties = renewerParameters.getAdditionalProperties();
        if (additionalProperties == null) {
            additionalProperties = new HashMap<String, Object>();
        }
        additionalProperties.put(ReceivedToken.class.getName(), renewerParameters.getToken());
        providerParameters.setAdditionalProperties(additionalProperties);
        return providerParameters;
    }

    private String createNewId(SamlAssertionWrapper assertion) {
        if (assertion.getSaml1() != null) {
            org.opensaml.saml1.core.Assertion saml1Assertion = assertion.getSaml1();
            String oldId = saml1Assertion.getID();
            saml1Assertion.setID(IDGenerator.generateID((String)"_"));
            return oldId;
        }
        Assertion saml2Assertion = assertion.getSaml2();
        String oldId = saml2Assertion.getID();
        saml2Assertion.setID(IDGenerator.generateID((String)"_"));
        return oldId;
    }

    private void storeTokenInCache(TokenStore tokenStore, SamlAssertionWrapper assertion, Principal principal, TokenRenewerParameters tokenParameters) throws WSSecurityException {
        byte[] signatureValue = assertion.getSignatureValue();
        if (tokenStore != null && signatureValue != null && signatureValue.length > 0) {
            DateTime validTill = null;
            validTill = assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) ? assertion.getSaml2().getConditions().getNotOnOrAfter() : assertion.getSaml1().getConditions().getNotOnOrAfter();
            SecurityToken securityToken = CacheUtils.createSecurityTokenForStorage(assertion.getElement(), assertion.getId(), validTill.toDate(), tokenParameters.getPrincipal(), tokenParameters.getRealm(), tokenParameters.getTokenRequirements().getRenewing());
            CacheUtils.storeTokenInCache(securityToken, tokenParameters.getTokenStore(), signatureValue);
        }
    }

    private DateTime getExpiryDate(SamlAssertionWrapper assertion) {
        if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20)) {
            return assertion.getSaml2().getConditions().getNotOnOrAfter();
        }
        return assertion.getSaml1().getConditions().getNotOnOrAfter();
    }

    private static class ProofOfPossessionValidator
    extends AbstractSamlPolicyValidator {
        private ProofOfPossessionValidator() {
        }

        public boolean checkProofOfPossession(TokenRenewerParameters tokenParameters, SAMLKeyInfo subjectKeyInfo) {
            MessageContext messageContext = tokenParameters.getWebServiceContext().getMessageContext();
            List handlerResults = CastUtils.cast((List)((List)messageContext.get((Object)"RECV_RESULTS")));
            ArrayList signedResults = new ArrayList();
            if (handlerResults != null && handlerResults.size() > 0) {
                WSHandlerResult handlerResult = (WSHandlerResult)handlerResults.get(0);
                List results = handlerResult.getResults();
                ArrayList<Integer> signedActions = new ArrayList<Integer>(2);
                signedActions.add(2);
                signedActions.add(64);
                signedResults.addAll(WSSecurityUtil.fetchAllActionResults((List)results, signedActions));
            }
            TLSSessionInfo tlsInfo = (TLSSessionInfo)messageContext.get((Object)TLSSessionInfo.class.getName());
            Certificate[] tlsCerts = null;
            if (tlsInfo != null) {
                tlsCerts = tlsInfo.getPeerCertificates();
            }
            return this.compareCredentials(subjectKeyInfo, signedResults, tlsCerts);
        }
    }
}

