/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.logging;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYCLSV", length=4)
public interface ClusteringServerLogger {
    public static final String ROOT_LOGGER_CATEGORY = "org.wildfly.clustering.server";
    public static final ClusteringServerLogger ROOT_LOGGER = (ClusteringServerLogger)Logger.getMessageLogger(ClusteringServerLogger.class, (String)"org.wildfly.clustering.server");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="This node will now operate as the singleton provider of the %s service")
    public void electedMaster(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="This node will no longer operate as the singleton provider of the %s service")
    public void electedSlave(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="%s elected as the singleton provider of the %s service")
    public void elected(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=4, value="No response received from master node of the %s service, retrying...")
    public void noResponseFromMaster(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="Failed to start %s service")
    public void serviceStartFailed(@Cause StartException var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=6, value="Failed to reach quorum of %2$d for %1$s service. No singleton master will be elected.")
    public void quorumNotReached(String var1, int var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Just reached required quorum of %2$d for %1$s service. If this cluster loses another member, no node will be chosen to provide this service.")
    public void quorumJustReached(String var1, int var2);

    @Message(id=8, value="Expected service %s value from singleton master only, but instead received %d results.")
    public IllegalStateException unexpectedResponseCount(String var1, int var2);

    @Message(id=9, value="Singleton service %s is not started.")
    public IllegalStateException notStarted(String var1);
}

