/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import java.io.Serializable;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.server.singleton.SingletonService;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.SingletonServiceBuilderFactory;

public class CacheSingletonServiceBuilderFactory
implements SingletonServiceBuilderFactory {
    final String containerName;
    final String cacheName;

    public CacheSingletonServiceBuilderFactory(String containerName, String cacheName) {
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    public <T extends Serializable> SingletonServiceBuilder<T> createSingletonServiceBuilder(final ServiceName name, Service<T> service) {
        final SingletonService<T> singleton = new SingletonService<T>(name, service);
        return new SingletonServiceBuilder<T>(){

            public SingletonServiceBuilder<T> requireQuorum(int quorum) {
                singleton.setQuorum(quorum);
                return this;
            }

            public SingletonServiceBuilder<T> electionPolicy(SingletonElectionPolicy policy) {
                singleton.setElectionPolicy(policy);
                return this;
            }

            public ServiceBuilder<T> build(ServiceTarget target) {
                return singleton.build(target, CacheSingletonServiceBuilderFactory.this.containerName, CacheSingletonServiceBuilderFactory.this.cacheName);
            }

            public ServiceName getServiceName() {
                return name;
            }
        };
    }
}

