/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.IOException;
import java.rmi.UnmarshalException;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.naming.NamingException;
import javax.transaction.NotSupportedException;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientContextIdentifier;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.remoting3.Channel;

@MessageLogger(projectCode="EJBCLIENT")
public interface Logs
extends BasicLogger {
    public static final Logs MAIN = Logger.getMessageLogger(Logs.class, "org.jboss.ejb.client");
    public static final Logs REMOTING = Logger.getMessageLogger(Logs.class, "org.jboss.ejb.client.remoting");
    public static final Logs TXN = Logger.getMessageLogger(Logs.class, "org.jboss.ejb.client.txn");

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="JBoss EJB Client version %s")
    public void greeting(String var1);

    @Message(id=0, value="Module name cannot be null or empty")
    public IllegalArgumentException emptyModuleName();

    @Message(id=1, value="Bean name cannot be null or empty")
    public IllegalArgumentException emptyBeanName();

    @Message(id=2, value="Bean interface type cannot be null")
    public IllegalArgumentException nullViewType();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Incorrect max-allowed-connected-nodes value %s specified for cluster named %s. Defaulting to %s")
    public void incorrectMaxAllowedConnectedNodesValueForCluster(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=4, value="Incorrect connection timeout value %s specified for cluster named %s. Defaulting to %s")
    public void incorrectConnectionTimeoutValueForCluster(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=5, value="Incorrect connection timeout value %s specified for node %s in cluster named %s. Defaulting to %s")
    public void incorrectConnectionTimeoutValueForNodeInCluster(String var1, String var2, String var3, String var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=6, value="No host/port configured for connection named %s. Skipping connection creation")
    public void skippingConnectionCreationDueToMissingHostOrPort(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=7, value="Incorrect port value %s specified for connection named %s. Skipping connection creation")
    public void skippingConnectionCreationDueToInvalidPortNumber(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=8, value="Incorrect connection timeout value %s specified for connection named %s. Defaulting to %s")
    public void incorrectConnectionTimeoutValueForConnection(String var1, String var2, String var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=9, value="Incorrect invocation timeout value %s specified. Defaulting to %s")
    public void incorrectInvocationTimeoutValue(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10, value="Incorrect reconnect tasks timeout value %s specified. Defaulting to %s")
    public void incorrectReconnectTasksTimeoutValue(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="Discarding result for invocation id %s since no waiting context found")
    public void discardingInvocationResult(short var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12, value="Cannot create a EJB receiver for %s since there was no match for a target destination")
    public void cannotCreateEJBReceiverDueToUnknownTarget(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=13, value="Successful version handshake completed for receiver context %s on channel %s")
    public void successfulVersionHandshake(EJBReceiverContext var1, Channel var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=14, value="Version handshake not completed for receiver context %s. Closing receiver context")
    public void versionHandshakeNotCompleted(EJBReceiverContext var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=15, value="Initial module availability report for %s wasn't received during the receiver context association")
    public void initialModuleAvailabilityReportNotReceived(EJBReceiver var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16, value="Channel %s can no longer process messages")
    public void channelCanNoLongerProcessMessages(Channel var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17, value="Received server version %d and marshalling strategies %s")
    public void receivedServerVersionAndMarshallingStrategies(int var1, Set<String> var2);

    @Message(id=18, value="%s cannot be null")
    public IllegalArgumentException paramCannotBeNull(String var1);

    @Message(id=19, value="Node name cannot be null or empty string, while adding a node to cluster named %s")
    public IllegalArgumentException nodeNameCannotBeNullOrEmptyStringForCluster(String var1);

    @Message(id=20, value="%s cannot be null or empty string")
    public IllegalArgumentException paramCannotBeNullOrEmptyString(String var1);

    @Message(id=21, value="EJB client context selector may not be changed")
    public SecurityException ejbClientContextSelectorMayNotBeChanged();

    @Message(id=22, value="No EJB client context is available")
    public IllegalStateException noEJBClientContextAvailable();

    @Message(id=23, value="EJB client interceptor %s is already registered")
    public IllegalArgumentException ejbClientInterceptorAlreadyRegistered(EJBClientInterceptor var1);

    @Message(id=24, value="No EJB receiver available for handling [appName:%s, moduleName:%s, distinctName:%s] combination")
    public IllegalStateException noEJBReceiverAvailableForDeployment(String var1, String var2, String var3);

    @Message(id=25, value="No EJB receiver available for handling [appName:%s, moduleName:%s, distinctName:%s] combination for invocation context %s")
    public IllegalStateException noEJBReceiverAvailableForDeploymentDuringInvocation(String var1, String var2, String var3, EJBClientInvocationContext var4);

    @Message(id=26, value="%s has not been associated with %s")
    public IllegalStateException receiverNotAssociatedWithClientContext(EJBReceiver var1, EJBClientContext var2);

    @Message(id=27, value="No EJBReceiver available for node name %s")
    public IllegalStateException noEJBReceiverForNode(String var1);

    @Message(id=28, value="No EJB receiver contexts available in cluster %s")
    public IllegalStateException noReceiverContextsInCluster(String var1);

    @Message(id=29, value="No cluster context available for cluster named %s")
    public IllegalStateException noClusterContextAvailable(String var1);

    @Message(id=30, value="sendRequest() called during wrong phase")
    public IllegalStateException sendRequestCalledDuringWrongPhase();

    @Message(id=31, value="No receiver associated with invocation")
    public IllegalStateException noReceiverAssociatedWithInvocation();

    @Message(id=32, value="Cannot retry a request which hasn't previously been completed")
    public IllegalStateException cannotRetryRequest();

    @Message(id=33, value="getResult() called during wrong phase")
    public IllegalStateException getResultCalledDuringWrongPhase();

    @Message(id=34, value="discardResult() called during wrong phase")
    public IllegalStateException discardResultCalledDuringWrongPhase();

    @Message(id=35, value="Not supported")
    public NamingException unsupportedNamingOperation();

    @Message(id=36, value="Read only naming context, operation not supported")
    public NamingException unsupportedNamingOperationForReadOnlyContext();

    @Message(id=37, value="Could not load ejb proxy class %s")
    public NamingException couldNotLoadProxyClass(String var1);

    @Message(id=38, value="Transaction enlistment did not yield a transaction ID")
    public IllegalStateException txEnlistmentDidNotYieldTxId();

    @Message(id=39, value="Cannot enlist transaction")
    public IllegalStateException cannotEnlistTx();

    @Message(id=40, value="EJB communication channel %s is not yet ready to receive invocations (perhaps version handshake hasn't been completed), for receiver context %s")
    public IllegalStateException channelNotReadyForCommunication(String var1, EJBReceiverContext var2);

    @Message(id=41, value="A session bean does not have a primary key class")
    public RuntimeException primaryKeyNotRelevantForSessionBeans();

    @Message(id=42, value="Failed to find EJB client configuration file specified in %s system property")
    public RuntimeException failedToFindEjbClientConfigFileSpecifiedBySysProp(@Cause Exception var1, String var2);

    @Message(id=43, value="Error reading EJB client properties file %s")
    public RuntimeException failedToReadEjbClientConfigFile(@Cause Exception var1, String var2);

    @Message(id=44, value="No transaction context available")
    public IllegalStateException noTxContextAvailable();

    @Message(id=45, value="User transactions not supported by this context")
    public IllegalStateException userTxNotSupportedByTxContext();

    @Message(id=46, value="A transaction is already associated with this thread")
    public NotSupportedException txAlreadyAssociatedWithThread();

    @Message(id=47, value="A transaction is not associated with this thread")
    public IllegalStateException noTxAssociatedWithThread();

    @Message(id=48, value="Transaction for this thread is not active")
    public IllegalStateException txNotActiveForThread();

    @Message(id=49, value="Cannot proceed with invocation since transaction is pinned to node %s which has been excluded from handling invocation for the current invocation context %s")
    public IllegalStateException txNodeIsExcludedForInvocation(String var1, EJBClientInvocationContext var2);

    @Message(id=50, value="Node of the current transaction %s does not accept %s")
    public IllegalStateException nodeDoesNotAcceptLocator(String var1, EJBLocator<?> var2);

    @Message(id=51, value="Cannot proceed with invocation since the locator %s has an affinity on node %s which has been excluded from current invocation context %s")
    public IllegalStateException requiredNodeExcludedFromInvocation(EJBLocator<?> var1, String var2, EJBClientInvocationContext var3);

    @Message(id=52, value="%s for cluster %s is not of type org.jboss.ejb.client.ClusterNodeSelector")
    public RuntimeException unexpectedClusterNodeSelectorClassType(Class<?> var1, String var2);

    @Message(id=53, value="Could not create the cluster node selector for cluster %s")
    public RuntimeException couldNotCreateClusterNodeSelector(@Cause Exception var1, String var2);

    @Message(id=54, value="Cannot specify both a callback handler and a username/password")
    public IllegalStateException cannotSpecifyBothCallbackHandlerAndUserPass();

    @Message(id=55, value="Could not decode base64 encoded password")
    public RuntimeException couldNotDecodeBase64Password(@Cause Exception var1);

    @Message(id=56, value="Cannot specify both a plain text and base64 encoded password")
    public IllegalStateException cannotSpecifyBothPlainTextAndEncodedPassword();

    @Message(id=57, value="%s not of type org.jboss.ejb.client.DeploymentNodeSelector")
    public RuntimeException unexpectedDeploymentNodeSelectorClassType(Class<?> var1);

    @Message(id=58, value="Could not create the deployment node selector")
    public RuntimeException couldNotCreateDeploymentNodeSelector(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=59, value="Could not send a message over remoting channel, to cancel invocation for invocation id %s")
    public void failedToSendInvocationCancellationMessage(short var1, @Cause Exception var2);

    @Message(id=60, value="Failed to create scoped EJB client context")
    public RuntimeException failedToCreateScopedEjbClientContext(@Cause Exception var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=61, value="Cannot send a transaction recovery message to the server since the protocol version of EJBReceiver %s doesn't support it")
    public void transactionRecoveryMessageNotSupported(EJBReceiver var1);

    @Message(id=100, value="Object '%s' is not a valid proxy object")
    public IllegalArgumentException unknownProxy(Object var1);

    @Message(id=101, value="Proxy object '%s' was not generated by %s")
    public IllegalArgumentException proxyNotOurs(Object var1, String var2);

    @Message(id=102, value="No asynchronous operation in progress")
    public IllegalStateException noAsyncInProgress();

    @Message(id=400, value="Remote invocation failed due to an exception")
    public ExecutionException remoteInvFailed(@Cause Throwable var1);

    @Message(id=401, value="Result was discarded (one-way invocation)")
    public IllegalStateException oneWayInvocation();

    @Message(id=402, value="Remote invocation request was cancelled")
    public CancellationException requestCancelled();

    @Message(id=403, value="Timed out")
    public TimeoutException timedOut();

    @Message(id=404, value="Operation not allowed since this EJB client context %s has been closed")
    public IllegalStateException ejbClientContextIsClosed(EJBClientContext var1);

    @Message(id=405, value="An EJB client context is already registered for EJB client context identifier %s")
    public IllegalStateException ejbClientContextAlreadyRegisteredForIdentifier(EJBClientContextIdentifier var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=406, value="Unexpected exception when discarding invocation result")
    public void exceptionOnDiscardResult(@Cause IOException var1);

    @Message(id=407, value="Issue regarding unmarshalling of EJB parameters (possible Out of Memory issue).")
    public UnmarshalException ejbClientInvocationParamsException(@Cause Exception var1);
}

