/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.spi;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jboss.logging.Logger;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.spi.SpiUtils;

public abstract class AbstractHandleableCloseable<T extends HandleableCloseable<T>>
implements HandleableCloseable<T> {
    private static final Logger log;
    private static final boolean LEAK_DEBUGGING;
    private final Executor executor;
    private final StackTraceElement[] backtrace;
    private final boolean autoClose;
    private final Object closeLock = new Object();
    private State state = State.OPEN;
    private IOException failure = null;
    private Map<HandleableCloseable.Key, CloseHandler<? super T>> closeHandlers = null;

    protected AbstractHandleableCloseable(Executor executor) {
        this(executor, true);
    }

    protected AbstractHandleableCloseable(Executor executor, boolean autoClose) {
        if (executor == null) {
            throw new NullPointerException("executor is null");
        }
        this.executor = executor;
        this.backtrace = LEAK_DEBUGGING ? Thread.currentThread().getStackTrace() : null;
        this.autoClose = autoClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isOpen() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.state == State.OPEN;
        }
    }

    protected void closeAction() throws IOException {
        this.closeComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        IOException failure;
        log.tracef("Closing %s synchronously", (Object)this);
        boolean first = false;
        Object object = this.closeLock;
        synchronized (object) {
            switch (this.state) {
                case OPEN: {
                    first = true;
                    this.state = State.CLOSING;
                    break;
                }
                case CLOSING: {
                    break;
                }
                case CLOSED: {
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (first) {
            try {
                this.closeAction();
            }
            catch (IOException e) {
                Map<HandleableCloseable.Key, CloseHandler<T>> closeHandlers;
                log.tracef((Throwable)e, "Close of %s failed", (Object)this);
                Object object2 = this.closeLock;
                synchronized (object2) {
                    this.state = State.CLOSED;
                    closeHandlers = this.closeHandlers;
                    this.closeHandlers = null;
                    this.closeLock.notifyAll();
                }
                if (closeHandlers != null) {
                    for (CloseHandler<? super T> closeHandler : closeHandlers.values()) {
                        SpiUtils.safeHandleClose(closeHandler, this, null);
                    }
                }
                throw e;
            }
            catch (Throwable t) {
                Map<HandleableCloseable.Key, CloseHandler<T>> closeHandlers;
                log.errorf(t, "Close action for %s failed to execute (resource may be left in an indeterminate state)", (Object)this);
                Iterator<CloseHandler<T>> i$ = this.closeLock;
                synchronized (i$) {
                    this.state = State.CLOSED;
                    closeHandlers = this.closeHandlers;
                    this.closeHandlers = null;
                    this.closeLock.notifyAll();
                }
                if (closeHandlers != null) {
                    for (CloseHandler<? super T> closeHandler : closeHandlers.values()) {
                        SpiUtils.safeHandleClose(closeHandler, this, null);
                    }
                }
                throw new IllegalStateException(t);
            }
        }
        Object closeHandlers = this.closeLock;
        synchronized (closeHandlers) {
            while (this.state != State.CLOSED) {
                try {
                    this.closeLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException("Interrupted while waiting for close to complete");
                }
            }
            failure = this.failure;
            this.failure = null;
        }
        if (failure != null) {
            IOException clone = AbstractHandleableCloseable.clone(failure);
            if (failure != clone) {
                SpiUtils.glueStackTraces(failure, Thread.currentThread().getStackTrace(), 1, "asynchronous close");
            }
            throw clone;
        }
    }

    private static <T extends IOException> T clone(T original) {
        Throwable cause = original.getCause();
        Class<?> originalClass = original.getClass();
        try {
            Constructor<?> constructor = originalClass.getConstructor(String.class, Throwable.class);
            IOException clone = (IOException)constructor.newInstance(original.getMessage(), cause);
            clone.setStackTrace(original.getStackTrace());
            return (T)clone;
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        try {
            Constructor<?> constructor = originalClass.getConstructor(String.class);
            IOException clone = (IOException)constructor.newInstance(original.getMessage());
            clone.initCause(cause);
            clone.setStackTrace(original.getStackTrace());
            return (T)clone;
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        try {
            Constructor<?> constructor = originalClass.getConstructor(new Class[0]);
            IOException clone = (IOException)constructor.newInstance(new Object[0]);
            clone.initCause(cause);
            clone.setStackTrace(original.getStackTrace());
            return (T)clone;
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        return original;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeComplete() {
        Map<HandleableCloseable.Key, CloseHandler<T>> closeHandlers;
        Object object = this.closeLock;
        synchronized (object) {
            switch (this.state) {
                case OPEN: {
                    log.tracef("Closing %s asynchronously", (Object)this);
                }
                case CLOSING: {
                    log.tracef("Completed close of %s", (Object)this);
                    this.state = State.CLOSED;
                    closeHandlers = this.closeHandlers;
                    this.closeHandlers = null;
                    break;
                }
                case CLOSED: {
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.closeLock.notifyAll();
        }
        if (closeHandlers != null) {
            for (CloseHandler<? super T> closeHandler : closeHandlers.values()) {
                AbstractHandleableCloseable.runCloseTask(new CloseHandlerTask(closeHandler, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeFailed(IOException cause) {
        Map<HandleableCloseable.Key, CloseHandler<T>> closeHandlers;
        Object object = this.closeLock;
        synchronized (object) {
            switch (this.state) {
                case CLOSING: {
                    log.tracef((Throwable)cause, "Completed close of %s with failure", (Object)this);
                    this.state = State.CLOSED;
                    this.failure = cause;
                    closeHandlers = this.closeHandlers;
                    this.closeHandlers = null;
                    break;
                }
                case CLOSED: {
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.closeLock.notifyAll();
        }
        if (closeHandlers != null) {
            for (CloseHandler<? super T> closeHandler : closeHandlers.values()) {
                AbstractHandleableCloseable.runCloseTask(new CloseHandlerTask(closeHandler, cause));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitClosed() throws InterruptedException {
        Object object = this.closeLock;
        synchronized (object) {
            while (this.state != State.CLOSED) {
                this.closeLock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitClosedUninterruptibly() {
        boolean intr = false;
        try {
            Object object = this.closeLock;
            synchronized (object) {
                while (this.state != State.CLOSED) {
                    try {
                        this.closeLock.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAsync() {
        boolean first;
        log.tracef("Closing %s asynchronously", (Object)this);
        Object object = this.closeLock;
        synchronized (object) {
            switch (this.state) {
                case OPEN: {
                    first = true;
                    this.state = State.CLOSING;
                    break;
                }
                case CLOSING: 
                case CLOSED: {
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (first) {
            try {
                this.closeAction();
            }
            catch (IOException e) {
                Map<HandleableCloseable.Key, CloseHandler<T>> closeHandlers;
                log.tracef((Throwable)e, "Close of %s failed", (Object)this);
                Object object2 = this.closeLock;
                synchronized (object2) {
                    this.state = State.CLOSED;
                    closeHandlers = this.closeHandlers;
                    this.closeHandlers = null;
                    this.closeLock.notifyAll();
                }
                if (closeHandlers != null) {
                    for (CloseHandler<? super T> closeHandler : closeHandlers.values()) {
                        AbstractHandleableCloseable.runCloseTask(new CloseHandlerTask(closeHandler, e));
                    }
                }
            }
            catch (Throwable t) {
                log.errorf(t, "Close action for %s failed to execute (resource may be left in an indeterminate state)", (Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleableCloseable.Key addCloseHandler(CloseHandler<? super T> handler) {
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        Object object = this.closeLock;
        synchronized (object) {
            if (this.state == State.OPEN || this.state == State.CLOSING) {
                KeyImpl key = new KeyImpl(this);
                Map<HandleableCloseable.Key, CloseHandler<T>> closeHandlers = this.closeHandlers;
                if (closeHandlers == null) {
                    IdentityHashMap<HandleableCloseable.Key, CloseHandler<T>> newMap = new IdentityHashMap<HandleableCloseable.Key, CloseHandler<T>>();
                    this.closeHandlers = newMap;
                    newMap.put(key, handler);
                } else {
                    closeHandlers.put(key, handler);
                }
                return key;
            }
        }
        AbstractHandleableCloseable.runCloseTask(new CloseHandlerTask(handler, null));
        return new NullKey();
    }

    private static void runCloseTask(Runnable task) {
        try {
            task.run();
        }
        catch (Throwable t) {
            log.tracef(t, "Got exception running close task %s", (Object)task);
        }
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            super.finalize();
        }
        finally {
            if (this.autoClose && this.isOpen()) {
                if (LEAK_DEBUGGING) {
                    LeakThrowable t = new LeakThrowable();
                    t.setStackTrace(this.backtrace);
                    log.warnf((Throwable)t, "Leaked a %s instance: %s", (Object)this.getClass().getName(), (Object)this);
                } else {
                    log.tracef("Leaked a %s instance: %s", (Object)this.getClass().getName(), (Object)this);
                }
                this.closeAsync();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkOpen() throws NotOpenException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.state != State.OPEN) {
                throw new NotOpenException(this.toString() + " is not open");
            }
        }
    }

    static {
        boolean b;
        log = Logger.getLogger("org.jboss.remoting.resource");
        try {
            b = Boolean.parseBoolean(AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("jboss.remoting.leakdebugging", "false");
                }
            }));
        }
        catch (SecurityException se) {
            b = false;
        }
        LEAK_DEBUGGING = b;
    }

    final class CloseHandlerTask
    implements Runnable {
        private final CloseHandler<? super T> handler;
        private final IOException exception;

        CloseHandlerTask(CloseHandler<? super T> handler, IOException exception) {
            this.handler = handler;
            this.exception = exception;
        }

        @Override
        public void run() {
            SpiUtils.safeHandleClose(this.handler, AbstractHandleableCloseable.this, this.exception);
        }
    }

    static final class LeakThrowable
    extends Throwable {
        LeakThrowable() {
        }

        @Override
        public String toString() {
            return "a leaked reference";
        }
    }

    private static final class KeyImpl<T extends HandleableCloseable<T>>
    implements HandleableCloseable.Key {
        private final AbstractHandleableCloseable<T> instance;

        private KeyImpl(AbstractHandleableCloseable<T> instance) {
            this.instance = instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Object object = ((AbstractHandleableCloseable)this.instance).closeLock;
            synchronized (object) {
                Map closeHandlers = ((AbstractHandleableCloseable)this.instance).closeHandlers;
                if (closeHandlers != null) {
                    closeHandlers.remove(this);
                }
            }
        }
    }

    private static final class NullKey
    implements HandleableCloseable.Key {
        private NullKey() {
        }

        @Override
        public void remove() {
        }
    }

    static enum State {
        OPEN,
        CLOSING,
        CLOSED;

    }
}

