/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.impl.PostTransactionWorkQueueSynchronization;
import org.hibernate.search.backend.impl.QueueingProcessor;
import org.hibernate.search.backend.impl.WorkQueue;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.interceptor.IndexingOverride;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.impl.Maps;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class TransactionalWorker
implements Worker {
    private static final Log log = LoggerFactory.make();
    protected final ConcurrentMap<Object, PostTransactionWorkQueueSynchronization> synchronizationPerTransaction = Maps.createIdentityWeakKeyConcurrentMap(64, 32);
    private QueueingProcessor queueingProcessor;
    private ExtendedSearchIntegrator factory;
    private InstanceInitializer instanceInitializer;
    private boolean transactionExpected;

    @Override
    public void performWork(Work work, TransactionContext transactionContext) {
        Class<?> entityType = this.instanceInitializer.getClassFromWork(work);
        EntityIndexBinding indexBindingForEntity = this.factory.getIndexBinding(entityType);
        if (indexBindingForEntity == null && this.factory.getDocumentBuilderContainedEntity(entityType) == null) {
            throw new SearchException("Unable to perform work. Entity Class is not @Indexed nor hosts @ContainedIn: " + entityType);
        }
        if ((work = this.interceptWork(indexBindingForEntity, work)) == null) {
            return;
        }
        if (transactionContext.isTransactionInProgress()) {
            Object transactionIdentifier = transactionContext.getTransactionIdentifier();
            PostTransactionWorkQueueSynchronization txSync = (PostTransactionWorkQueueSynchronization)this.synchronizationPerTransaction.get(transactionIdentifier);
            if (txSync == null || txSync.isConsumed()) {
                txSync = new PostTransactionWorkQueueSynchronization(transactionIdentifier, this.queueingProcessor, this.synchronizationPerTransaction, this.factory);
                transactionContext.registerSynchronization(txSync);
                this.synchronizationPerTransaction.put(transactionIdentifier, txSync);
            }
            txSync.add(work);
        } else {
            if (this.transactionExpected) {
                log.pushedChangesOutOfTransaction();
            }
            WorkQueue queue = new WorkQueue(this.factory);
            this.queueingProcessor.add(work, queue);
            this.queueingProcessor.prepareWorks(queue);
            this.queueingProcessor.performWorks(queue);
        }
    }

    private Work interceptWork(EntityIndexBinding indexBindingForEntity, Work work) {
        IndexingOverride operation;
        if (indexBindingForEntity == null) {
            return work;
        }
        EntityIndexingInterceptor interceptor = indexBindingForEntity.getEntityIndexingInterceptor();
        if (interceptor == null) {
            return work;
        }
        switch (work.getType()) {
            case ADD: {
                operation = interceptor.onAdd(work.getEntity());
                break;
            }
            case UPDATE: {
                operation = interceptor.onUpdate(work.getEntity());
                break;
            }
            case DELETE: {
                operation = interceptor.onDelete(work.getEntity());
                break;
            }
            case COLLECTION: {
                operation = interceptor.onCollectionUpdate(work.getEntity());
                break;
            }
            case PURGE: 
            case PURGE_ALL: 
            case INDEX: 
            case DELETE_BY_QUERY: {
                operation = IndexingOverride.APPLY_DEFAULT;
                break;
            }
            default: {
                throw new AssertionFailure("Unknown work type: " + (Object)((Object)work.getType()));
            }
        }
        Work result = work;
        Class<?> entityClass = work.getEntityClass();
        switch (operation) {
            case APPLY_DEFAULT: {
                break;
            }
            case SKIP: {
                result = null;
                log.forceSkipIndexOperationViaInterception(entityClass, work.getType());
                break;
            }
            case UPDATE: {
                result = new Work(work.getTenantIdentifier(), work.getEntity(), work.getId(), WorkType.UPDATE);
                log.forceUpdateOnIndexOperationViaInterception(entityClass, work.getType());
                break;
            }
            case REMOVE: {
                result = new Work(work.getTenantIdentifier(), work.getEntity(), work.getId(), WorkType.DELETE, work.isIdentifierWasRolledBack());
                log.forceRemoveOnIndexOperationViaInterception(entityClass, work.getType());
                break;
            }
            default: {
                throw new AssertionFailure("Unknown action type: " + (Object)((Object)operation));
            }
        }
        return result;
    }

    @Override
    public void initialize(Properties props, WorkerBuildContext context, QueueingProcessor queueingProcessor) {
        this.queueingProcessor = queueingProcessor;
        this.factory = context.getUninitializedSearchIntegrator();
        this.transactionExpected = context.isTransactionManagerExpected();
        this.instanceInitializer = context.getInstanceInitializer();
    }

    @Override
    public void close() {
    }

    @Override
    public void flushWorks(TransactionContext transactionContext) {
        Object transaction;
        PostTransactionWorkQueueSynchronization txSync;
        if (transactionContext.isTransactionInProgress() && (txSync = (PostTransactionWorkQueueSynchronization)this.synchronizationPerTransaction.get(transaction = transactionContext.getTransactionIdentifier())) != null && !txSync.isConsumed()) {
            txSync.flushWorks();
        }
    }
}

