/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.encoding.BufferManagerReadStream;
import com.sun.corba.se.impl.encoding.CDRInputObject;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.giopmsgheaders.LocateReplyOrReplyMessage;
import com.sun.corba.se.pept.encoding.InputObject;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.transport.CorbaConnection;
import com.sun.corba.se.spi.transport.CorbaResponseWaitingRoom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;

public class CorbaResponseWaitingRoomImpl
implements CorbaResponseWaitingRoom {
    private ORB orb;
    private ORBUtilSystemException wrapper;
    private CorbaConnection connection;
    private final Map<Integer, OutCallDesc> out_calls;

    public CorbaResponseWaitingRoomImpl(ORB orb, CorbaConnection connection) {
        this.orb = orb;
        this.wrapper = ORBUtilSystemException.get(orb, "rpc.transport");
        this.connection = connection;
        this.out_calls = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public void registerWaiter(MessageMediator mediator) {
        CorbaMessageMediator messageMediator = (CorbaMessageMediator)mediator;
        if (this.orb.transportDebugFlag) {
            this.dprint(".registerWaiter: " + this.opAndId(messageMediator));
        }
        Integer requestId = messageMediator.getRequestIdInteger();
        OutCallDesc call = new OutCallDesc();
        call.thread = Thread.currentThread();
        call.messageMediator = messageMediator;
        this.out_calls.put(requestId, call);
    }

    @Override
    public void unregisterWaiter(MessageMediator mediator) {
        CorbaMessageMediator messageMediator = (CorbaMessageMediator)mediator;
        if (this.orb.transportDebugFlag) {
            this.dprint(".unregisterWaiter: " + this.opAndId(messageMediator));
        }
        Integer requestId = messageMediator.getRequestIdInteger();
        this.out_calls.remove(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputObject waitForResponse(MessageMediator mediator) {
        CorbaMessageMediator messageMediator = (CorbaMessageMediator)mediator;
        try {
            InputObject returnStream = null;
            if (this.orb.transportDebugFlag) {
                this.dprint(".waitForResponse->: " + this.opAndId(messageMediator));
            }
            Integer requestId = messageMediator.getRequestIdInteger();
            if (messageMediator.isOneWay()) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".waitForResponse: one way - not waiting: " + this.opAndId(messageMediator));
                }
                InputObject inputObject = null;
                return inputObject;
            }
            OutCallDesc call = this.out_calls.get(requestId);
            if (call == null) {
                throw this.wrapper.nullOutCall(CompletionStatus.COMPLETED_MAYBE);
            }
            Object object = call.done;
            synchronized (object) {
                while (call.inputObject == null && call.exception == null) {
                    try {
                        if (this.orb.transportDebugFlag) {
                            this.dprint(".waitForResponse: waiting: " + this.opAndId(messageMediator));
                        }
                        call.done.wait();
                    }
                    catch (InterruptedException ie) {}
                }
                if (call.exception != null) {
                    if (this.orb.transportDebugFlag) {
                        this.dprint(".waitForResponse: exception: " + this.opAndId(messageMediator));
                    }
                    throw call.exception;
                }
                returnStream = call.inputObject;
            }
            if (returnStream != null) {
                ((CDRInputObject)returnStream).unmarshalHeader();
            }
            object = returnStream;
            return object;
        }
        finally {
            if (this.orb.transportDebugFlag) {
                this.dprint(".waitForResponse<-: " + this.opAndId(messageMediator));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void responseReceived(InputObject is) {
        CDRInputObject inputObject = (CDRInputObject)is;
        LocateReplyOrReplyMessage header = (LocateReplyOrReplyMessage)inputObject.getMessageHeader();
        Integer requestId = new Integer(header.getRequestId());
        OutCallDesc call = this.out_calls.get(requestId);
        if (this.orb.transportDebugFlag) {
            this.dprint(".responseReceived: id/" + requestId + ": " + header);
        }
        if (call == null) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".responseReceived: id/" + requestId + ": no waiter: " + header);
            }
            return;
        }
        Object object = call.done;
        synchronized (object) {
            CorbaMessageMediator messageMediator = (CorbaMessageMediator)call.messageMediator;
            if (this.orb.transportDebugFlag) {
                this.dprint(".responseReceived: " + this.opAndId(messageMediator) + ": notifying waiters");
            }
            messageMediator.setReplyHeader(header);
            messageMediator.setInputObject(is);
            inputObject.setMessageMediator(messageMediator);
            call.inputObject = is;
            call.done.notify();
        }
    }

    @Override
    public int numberRegistered() {
        return this.out_calls.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalExceptionToAllWaiters(SystemException systemException) {
        if (this.orb.transportDebugFlag) {
            this.dprint(".signalExceptionToAllWaiters: " + systemException);
        }
        Map<Integer, OutCallDesc> map = this.out_calls;
        synchronized (map) {
            if (this.orb.transportDebugFlag) {
                this.dprint(".signalExceptionToAllWaiters: out_calls size :" + this.out_calls.size());
            }
            for (OutCallDesc call : this.out_calls.values()) {
                if (this.orb.transportDebugFlag) {
                    this.dprint(".signalExceptionToAllWaiters: signaling " + call);
                }
                Object object = call.done;
                synchronized (object) {
                    try {
                        CorbaMessageMediator corbaMsgMediator = (CorbaMessageMediator)call.messageMediator;
                        CDRInputObject inputObject = (CDRInputObject)corbaMsgMediator.getInputObject();
                        if (inputObject != null) {
                            BufferManagerReadStream bufferManager = (BufferManagerReadStream)inputObject.getBufferManager();
                            int requestId = corbaMsgMediator.getRequestId();
                            bufferManager.cancelProcessing(requestId);
                        }
                    }
                    catch (Exception e) {
                    }
                    finally {
                        call.inputObject = null;
                        call.exception = systemException;
                        call.done.notifyAll();
                    }
                }
            }
        }
    }

    @Override
    public MessageMediator getMessageMediator(int requestId) {
        Integer id = new Integer(requestId);
        OutCallDesc call = this.out_calls.get(id);
        if (call == null) {
            return null;
        }
        return call.messageMediator;
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaResponseWaitingRoomImpl", msg);
    }

    protected String opAndId(CorbaMessageMediator mediator) {
        return ORBUtility.operationNameAndRequestId(mediator);
    }

    static final class OutCallDesc {
        Object done = new Object();
        Thread thread;
        MessageMediator messageMediator;
        SystemException exception;
        InputObject inputObject;

        OutCallDesc() {
        }
    }
}

