/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.mod_cluster;

import java.util.Map;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.DefaultCheckersAndConverter;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.mod_cluster.LoadMetricDefinition;
import org.wildfly.extension.mod_cluster.ModClusterLogger;

class CapacityCheckerAndConverter
extends DefaultCheckersAndConverter {
    static final CapacityCheckerAndConverter INSTANCE = new CapacityCheckerAndConverter();

    CapacityCheckerAndConverter() {
    }

    public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
        return ModClusterLogger.ROOT_LOGGER.capacityIsExpressionOrGreaterThanIntegerMaxValue(attributes.get(LoadMetricDefinition.CAPACITY.getName()));
    }

    protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
        if (this.checkForExpression(attributeValue) || attributeValue.isDefined() && !this.isIntegerValue(attributeValue.asDouble())) {
            return true;
        }
        Long converted = this.convert(attributeValue);
        return converted != null && (converted > Integer.MAX_VALUE || converted < Integer.MIN_VALUE);
    }

    protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
        Long converted = this.convert(attributeValue);
        if (converted != null && converted <= Integer.MAX_VALUE && converted >= Integer.MIN_VALUE) {
            attributeValue.set((int)converted.longValue());
        }
    }

    protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
        return false;
    }

    private Long convert(ModelNode attributeValue) {
        double raw;
        if (attributeValue.isDefined() && !this.checkForExpression(attributeValue) && this.isIntegerValue(raw = attributeValue.asDouble())) {
            return Math.round(raw);
        }
        return null;
    }

    private boolean isIntegerValue(double raw) {
        return raw == (double)Math.round(raw);
    }
}

