/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.addressRewrite;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.wsf.spi.metadata.config.SOAPAddressRewriteMetadata;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.addressRewrite.SEDProcessor;

public class SoapAddressRewriteHelper {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";

    public static String getRewrittenPublishedEndpointUrl(String wsdlAddress, String epAddress, SOAPAddressRewriteMetadata sarm) {
        if (wsdlAddress == null) {
            return null;
        }
        if (SoapAddressRewriteHelper.isRewriteRequired(sarm, wsdlAddress)) {
            String origUriScheme = SoapAddressRewriteHelper.getUriScheme(wsdlAddress);
            String newUriScheme = SoapAddressRewriteHelper.getUriScheme(epAddress);
            return SoapAddressRewriteHelper.rewriteSoapAddress(sarm, wsdlAddress, epAddress, SoapAddressRewriteHelper.rewriteUriScheme(sarm, origUriScheme, newUriScheme));
        }
        return wsdlAddress;
    }

    public static String getRewrittenPublishedEndpointUrl(String address, SOAPAddressRewriteMetadata sarm) {
        try {
            if (SoapAddressRewriteHelper.isPathRewriteRequired(sarm) || SoapAddressRewriteHelper.isSchemeRewriteRequired(sarm)) {
                URL url = new URL(address);
                String uriScheme = SoapAddressRewriteHelper.rewriteUriScheme(sarm, SoapAddressRewriteHelper.getUriScheme(address), null);
                String port = SoapAddressRewriteHelper.getDotPortNumber(uriScheme, sarm);
                StringBuilder builder = new StringBuilder();
                builder.append(uriScheme);
                builder.append("://");
                builder.append(url.getHost());
                builder.append(port);
                String path = url.getPath();
                builder.append(SoapAddressRewriteHelper.isPathRewriteRequired(sarm) ? SEDProcessor.newInstance(sarm.getWebServicePathRewriteRule()).processLine(path) : path);
                String newUrl = builder.toString();
                Loggers.ADDRESS_REWRITE_LOGGER.addressRewritten(address, newUrl);
                return newUrl;
            }
            Loggers.ADDRESS_REWRITE_LOGGER.rewriteNotRequired(address);
            return address;
        }
        catch (MalformedURLException e) {
            Loggers.ADDRESS_REWRITE_LOGGER.invalidAddressProvidedUseItWithoutRewriting(address, "");
            return address;
        }
    }

    public static boolean isAutoRewriteOn(SOAPAddressRewriteMetadata sarm) {
        return sarm.isModifySOAPAddress() && "jbossws.undefined.host".equals(sarm.getWebServiceHost());
    }

    private static boolean isRewriteRequired(SOAPAddressRewriteMetadata sarm, String address) {
        if (sarm.isModifySOAPAddress()) {
            Loggers.ADDRESS_REWRITE_LOGGER.addressRewriteRequiredBecauseOfServerConf(address);
            return true;
        }
        if (SoapAddressRewriteHelper.isInvalidAddress(address)) {
            Loggers.ADDRESS_REWRITE_LOGGER.addressRewriteRequiredBecauseOfInvalidAddress(address);
            return true;
        }
        Loggers.ADDRESS_REWRITE_LOGGER.rewriteNotRequired(address);
        return false;
    }

    private static boolean isInvalidAddress(String address) {
        if (address == null) {
            return true;
        }
        String s = address.trim();
        if (s.length() == 0 || s.contains("REPLACE_WITH_ACTUAL_URL")) {
            return true;
        }
        try {
            new URL(s);
        }
        catch (MalformedURLException e) {
            return true;
        }
        return false;
    }

    private static String rewriteSoapAddress(SOAPAddressRewriteMetadata sarm, String origAddress, String newAddress, String uriScheme) {
        try {
            URL url = new URL(newAddress);
            String path = url.getPath();
            String host = sarm.getWebServiceHost();
            String port = SoapAddressRewriteHelper.getDotPortNumber(uriScheme, sarm);
            StringBuilder sb = new StringBuilder(uriScheme);
            sb.append("://");
            sb.append(host);
            sb.append(port);
            if (SoapAddressRewriteHelper.isPathRewriteRequired(sarm)) {
                sb.append(SEDProcessor.newInstance(sarm.getWebServicePathRewriteRule()).processLine(path));
            } else {
                sb.append(path);
            }
            String urlStr = sb.toString();
            Loggers.ADDRESS_REWRITE_LOGGER.addressRewritten(origAddress, urlStr);
            return urlStr;
        }
        catch (MalformedURLException e) {
            Loggers.ADDRESS_REWRITE_LOGGER.invalidAddressProvidedUseItWithoutRewriting(newAddress, origAddress);
            return origAddress;
        }
    }

    private static String getDotPortNumber(String uriScheme, SOAPAddressRewriteMetadata sarm) {
        String port = "";
        if (HTTPS.equals(uriScheme)) {
            int portNo = sarm.getWebServiceSecurePort();
            if (portNo != 443) {
                port = ":" + portNo;
            }
        } else {
            int portNo = sarm.getWebServicePort();
            if (portNo != 80) {
                port = ":" + portNo;
            }
        }
        return port;
    }

    private static String getUriScheme(String address) {
        try {
            URI addrURI = new URI(address);
            String scheme = addrURI.getScheme();
            return scheme != null ? scheme : HTTP;
        }
        catch (URISyntaxException e) {
            return HTTP;
        }
    }

    public static boolean isPathRewriteRequired(SOAPAddressRewriteMetadata sarm) {
        if (!sarm.isModifySOAPAddress()) {
            return false;
        }
        String pathRewriteRule = sarm.getWebServicePathRewriteRule();
        return pathRewriteRule != null && !pathRewriteRule.isEmpty();
    }

    public static boolean isSchemeRewriteRequired(SOAPAddressRewriteMetadata sarm) {
        if (!sarm.isModifySOAPAddress()) {
            return false;
        }
        return sarm.getWebServiceUriScheme() != null;
    }

    private static String rewriteUriScheme(SOAPAddressRewriteMetadata sarm, String origUriScheme, String newUriScheme) {
        String uriScheme = HTTPS.equals(origUriScheme) || HTTPS.equals(newUriScheme) ? HTTPS : HTTP;
        String serverUriScheme = sarm.getWebServiceUriScheme();
        if (serverUriScheme != null) {
            uriScheme = serverUriScheme;
        }
        return uriScheme;
    }
}

