/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.metadata.services;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;

public class DDJmsAddressBean {
    private final String portName;
    private final Properties properties;
    private final boolean isRequest;

    public DDJmsAddressBean(String portName, boolean isRequest, Properties properties) {
        this.portName = portName;
        this.isRequest = isRequest;
        this.properties = properties;
    }

    public void writeTo(Writer writer) throws IOException {
        if (this.isRequest) {
            writer.write("<jms:destination name='" + this.portName + ".jms-destination'>");
        } else {
            writer.write("<jms:conduit name='" + this.portName + ".jms-conduit'>");
        }
        writer.write("<jms:address");
        for (String name : this.properties.stringPropertyNames()) {
            writer.write(" " + name + "='" + this.properties.getProperty(name) + "'");
        }
        writer.write("/>");
        if (this.isRequest) {
            writer.write("</jms:destination>");
        } else {
            writer.write("</jms:conduit>");
        }
    }

    public String toString() {
        StringWriter strWriter = new StringWriter();
        strWriter.write("JMSAddressing");
        strWriter.write("\n portName=" + this.portName);
        strWriter.write("\n isRequest=" + this.isRequest);
        strWriter.write("\n");
        this.properties.list(new PrintWriter(strWriter));
        return strWriter.toString();
    }
}

