/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.jwt;

import java.io.Serializable;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

public class JsonWebToken
implements Serializable {
    @JsonProperty(value="jti")
    protected String id;
    @JsonProperty(value="exp")
    protected long expiration;
    @JsonProperty(value="nbf")
    protected long notBefore;
    @JsonProperty(value="iat")
    protected long issuedAt;
    @JsonProperty(value="iss")
    protected String issuer;
    @JsonProperty(value="aud")
    protected String audience;
    @JsonProperty(value="prn")
    protected String principal;
    @JsonProperty(value="typ")
    protected String type;

    public String getId() {
        return this.id;
    }

    public JsonWebToken id(String id) {
        this.id = id;
        return this;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public JsonWebToken expiration(long expiration) {
        this.expiration = expiration;
        return this;
    }

    @JsonIgnore
    public boolean isExpired() {
        long time = System.currentTimeMillis() / 1000L;
        return time > this.expiration;
    }

    public long getNotBefore() {
        return this.notBefore;
    }

    public JsonWebToken notBefore(long notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    @JsonIgnore
    public boolean isNotBefore() {
        return System.currentTimeMillis() / 1000L >= this.notBefore;
    }

    @JsonIgnore
    public boolean isActive() {
        return !(this.isExpired() && this.expiration != 0L || !this.isNotBefore() && this.notBefore != 0L);
    }

    public long getIssuedAt() {
        return this.issuedAt;
    }

    @JsonIgnore
    public JsonWebToken issuedNow() {
        this.issuedAt = System.currentTimeMillis() / 1000L;
        return this;
    }

    public JsonWebToken issuedAt(long issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public JsonWebToken issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String getAudience() {
        return this.audience;
    }

    public JsonWebToken audience(String audience) {
        this.audience = audience;
        return this;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public JsonWebToken principal(String principal) {
        this.principal = principal;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public JsonWebToken type(String type) {
        this.type = type;
        return this;
    }
}

