/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.JdbcRowSetResourceBundle;
import com.sun.rowset.WebRowSetImpl;
import com.sun.rowset.internal.Row;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.RowSetMetaDataImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlReaderContentHandler
extends DefaultHandler {
    private HashMap propMap;
    private HashMap colDefMap;
    private HashMap dataMap;
    private HashMap typeMap;
    private Vector updates;
    private Vector keyCols;
    private String columnValue;
    private String propertyValue;
    private String metaDataValue;
    private int tag;
    private int state;
    private WebRowSetImpl rs;
    private boolean nullVal;
    private boolean emptyStringVal;
    private RowSetMetaData md;
    private int idx;
    private String lastval;
    private String Key_map;
    private String Value_map;
    private String tempStr;
    private String tempUpdate;
    private String tempCommand;
    private Object[] upd;
    private String[] properties = new String[]{"command", "concurrency", "datasource", "escape-processing", "fetch-direction", "fetch-size", "isolation-level", "key-columns", "map", "max-field-size", "max-rows", "query-timeout", "read-only", "rowset-type", "show-deleted", "table-name", "url", "null", "column", "type", "class", "sync-provider", "sync-provider-name", "sync-provider-vendor", "sync-provider-version", "sync-provider-grade", "data-source-lock"};
    private static final int CommandTag = 0;
    private static final int ConcurrencyTag = 1;
    private static final int DatasourceTag = 2;
    private static final int EscapeProcessingTag = 3;
    private static final int FetchDirectionTag = 4;
    private static final int FetchSizeTag = 5;
    private static final int IsolationLevelTag = 6;
    private static final int KeycolsTag = 7;
    private static final int MapTag = 8;
    private static final int MaxFieldSizeTag = 9;
    private static final int MaxRowsTag = 10;
    private static final int QueryTimeoutTag = 11;
    private static final int ReadOnlyTag = 12;
    private static final int RowsetTypeTag = 13;
    private static final int ShowDeletedTag = 14;
    private static final int TableNameTag = 15;
    private static final int UrlTag = 16;
    private static final int PropNullTag = 17;
    private static final int PropColumnTag = 18;
    private static final int PropTypeTag = 19;
    private static final int PropClassTag = 20;
    private static final int SyncProviderTag = 21;
    private static final int SyncProviderNameTag = 22;
    private static final int SyncProviderVendorTag = 23;
    private static final int SyncProviderVersionTag = 24;
    private static final int SyncProviderGradeTag = 25;
    private static final int DataSourceLock = 26;
    private String[] colDef = new String[]{"column-count", "column-definition", "column-index", "auto-increment", "case-sensitive", "currency", "nullable", "signed", "searchable", "column-display-size", "column-label", "column-name", "schema-name", "column-precision", "column-scale", "table-name", "catalog-name", "column-type", "column-type-name", "null"};
    private static final int ColumnCountTag = 0;
    private static final int ColumnDefinitionTag = 1;
    private static final int ColumnIndexTag = 2;
    private static final int AutoIncrementTag = 3;
    private static final int CaseSensitiveTag = 4;
    private static final int CurrencyTag = 5;
    private static final int NullableTag = 6;
    private static final int SignedTag = 7;
    private static final int SearchableTag = 8;
    private static final int ColumnDisplaySizeTag = 9;
    private static final int ColumnLabelTag = 10;
    private static final int ColumnNameTag = 11;
    private static final int SchemaNameTag = 12;
    private static final int ColumnPrecisionTag = 13;
    private static final int ColumnScaleTag = 14;
    private static final int MetaTableNameTag = 15;
    private static final int CatalogNameTag = 16;
    private static final int ColumnTypeTag = 17;
    private static final int ColumnTypeNameTag = 18;
    private static final int MetaNullTag = 19;
    private String[] data = new String[]{"currentRow", "columnValue", "insertRow", "deleteRow", "insdel", "updateRow", "null", "emptyString"};
    private static final int RowTag = 0;
    private static final int ColTag = 1;
    private static final int InsTag = 2;
    private static final int DelTag = 3;
    private static final int InsDelTag = 4;
    private static final int UpdTag = 5;
    private static final int NullTag = 6;
    private static final int EmptyStringTag = 7;
    private static final int INITIAL = 0;
    private static final int PROPERTIES = 1;
    private static final int METADATA = 2;
    private static final int DATA = 3;
    private JdbcRowSetResourceBundle resBundle;

    public XmlReaderContentHandler(RowSet r) {
        this.rs = (WebRowSetImpl)r;
        this.initMaps();
        this.updates = new Vector();
        this.columnValue = "";
        this.propertyValue = "";
        this.metaDataValue = "";
        this.nullVal = false;
        this.idx = 0;
        this.tempStr = "";
        this.tempUpdate = "";
        this.tempCommand = "";
        try {
            this.resBundle = JdbcRowSetResourceBundle.getJdbcRowSetResourceBundle();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void initMaps() {
        int i;
        this.propMap = new HashMap();
        int items = this.properties.length;
        for (i = 0; i < items; ++i) {
            this.propMap.put(this.properties[i], i);
        }
        this.colDefMap = new HashMap();
        items = this.colDef.length;
        for (i = 0; i < items; ++i) {
            this.colDefMap.put(this.colDef[i], i);
        }
        this.dataMap = new HashMap();
        items = this.data.length;
        for (i = 0; i < items; ++i) {
            this.dataMap.put(this.data[i], i);
        }
        this.typeMap = new HashMap();
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String lName, String qName, Attributes attributes) throws SAXException {
        String name = "";
        name = lName;
        switch (this.getState()) {
            case 1: {
                this.tempCommand = "";
                int tag = (Integer)this.propMap.get(name);
                if (tag == 17) {
                    this.setNullValue(true);
                    break;
                }
                this.setTag(tag);
                break;
            }
            case 2: {
                int tag = (Integer)this.colDefMap.get(name);
                if (tag == 19) {
                    this.setNullValue(true);
                    break;
                }
                this.setTag(tag);
                break;
            }
            case 3: {
                this.tempStr = "";
                this.tempUpdate = "";
                int tag = this.dataMap.get(name) == null ? 6 : ((Integer)this.dataMap.get(name) == 7 ? 7 : (Integer)this.dataMap.get(name));
                if (tag == 6) {
                    this.setNullValue(true);
                    break;
                }
                if (tag == 7) {
                    this.setEmptyStringValue(true);
                    break;
                }
                this.setTag(tag);
                if (tag != 0 && tag != 3 && tag != 2) break;
                this.idx = 0;
                try {
                    this.rs.moveToInsertRow();
                }
                catch (SQLException ex) {}
                break;
            }
            default: {
                this.setState(name);
            }
        }
    }

    @Override
    public void endElement(String uri, String lName, String qName) throws SAXException {
        String name = "";
        name = lName;
        block10 : switch (this.getState()) {
            case 1: {
                if (name.equals("properties")) {
                    this.state = 0;
                    break;
                }
                try {
                    int tag = (Integer)this.propMap.get(name);
                    switch (tag) {
                        case 7: {
                            if (this.keyCols == null) break;
                            int[] i = new int[this.keyCols.size()];
                            for (int j = 0; j < i.length; ++j) {
                                i[j] = Integer.parseInt((String)this.keyCols.elementAt(j));
                            }
                            this.rs.setKeyColumns(i);
                            break;
                        }
                        case 20: {
                            try {
                                this.typeMap.put(this.Key_map, Class.forName(this.Value_map));
                                break;
                            }
                            catch (ClassNotFoundException ex) {
                                throw new SAXException(MessageFormat.format(this.resBundle.handleGetObject("xmlrch.errmap").toString(), ex.getMessage()));
                            }
                        }
                        case 8: {
                            this.rs.setTypeMap(this.typeMap);
                            break;
                        }
                    }
                    if (this.getNullValue()) {
                        this.setPropertyValue(null);
                        this.setNullValue(false);
                    } else {
                        this.setPropertyValue(this.propertyValue);
                    }
                }
                catch (SQLException ex) {
                    throw new SAXException(ex.getMessage());
                }
                this.propertyValue = "";
                this.setTag(-1);
                break;
            }
            case 2: {
                if (name.equals("metadata")) {
                    try {
                        this.rs.setMetaData(this.md);
                        this.state = 0;
                    }
                    catch (SQLException ex) {
                        throw new SAXException(MessageFormat.format(this.resBundle.handleGetObject("xmlrch.errmetadata").toString(), ex.getMessage()));
                    }
                }
                try {
                    if (this.getNullValue()) {
                        this.setMetaDataValue(null);
                        this.setNullValue(false);
                    } else {
                        this.setMetaDataValue(this.metaDataValue);
                    }
                }
                catch (SQLException ex) {
                    throw new SAXException(MessageFormat.format(this.resBundle.handleGetObject("xmlrch.errmetadata").toString(), ex.getMessage()));
                }
                this.metaDataValue = "";
                this.setTag(-1);
                break;
            }
            case 3: {
                if (name.equals("data")) {
                    this.state = 0;
                    return;
                }
                int tag = this.dataMap.get(name) == null ? 6 : (Integer)this.dataMap.get(name);
                switch (tag) {
                    case 1: {
                        try {
                            ++this.idx;
                            if (this.getNullValue()) {
                                this.insertValue(null);
                                this.setNullValue(false);
                            } else {
                                this.insertValue(this.tempStr);
                            }
                            this.columnValue = "";
                            break block10;
                        }
                        catch (SQLException ex) {
                            throw new SAXException(MessageFormat.format(this.resBundle.handleGetObject("xmlrch.errinsertval").toString(), ex.getMessage()));
                        }
                    }
                    case 0: {
                        try {
                            this.rs.insertRow();
                            this.rs.moveToCurrentRow();
                            this.rs.next();
                            this.rs.setOriginalRow();
                            this.applyUpdates();
                            break block10;
                        }
                        catch (SQLException ex) {
                            throw new SAXException(MessageFormat.format(this.resBundle.handleGetObject("xmlrch.errconstr").toString(), ex.getMessage()));
                        }
                    }
                    case 3: {
                        try {
                            this.rs.insertRow();
                            this.rs.moveToCurrentRow();
                            this.rs.next();
                            this.rs.setOriginalRow();
                            this.applyUpdates();
                            break block10;
                        }
                        catch (SQLException ex) {
                            throw new SAXException(MessageFormat.format(this.resBundle.handleGetObject("xmlrch.errdel").toString(), ex.getMessage()));
                        }
                    }
                    case 2: {
                        try {
                            this.rs.insertRow();
                            this.rs.moveToCurrentRow();
                            this.rs.next();
                            this.applyUpdates();
                            break block10;
                        }
                        catch (SQLException ex) {
                            throw new SAXException(MessageFormat.format(this.resBundle.handleGetObject("xmlrch.errinsert").toString(), ex.getMessage()));
                        }
                    }
                    case 4: {
                        try {
                            this.rs.insertRow();
                            this.rs.moveToCurrentRow();
                            this.rs.next();
                            this.rs.setOriginalRow();
                            this.applyUpdates();
                            break block10;
                        }
                        catch (SQLException ex) {
                            throw new SAXException(MessageFormat.format(this.resBundle.handleGetObject("xmlrch.errinsdel").toString(), ex.getMessage()));
                        }
                    }
                    case 5: {
                        try {
                            if (this.getNullValue()) {
                                this.insertValue(null);
                                this.setNullValue(false);
                                break block10;
                            }
                            if (this.getEmptyStringValue()) {
                                this.insertValue("");
                                this.setEmptyStringValue(false);
                                break block10;
                            }
                            this.updates.add(this.upd);
                            break block10;
                        }
                        catch (SQLException ex) {
                            throw new SAXException(MessageFormat.format(this.resBundle.handleGetObject("xmlrch.errupdate").toString(), ex.getMessage()));
                        }
                    }
                }
            }
        }
    }

    private void applyUpdates() throws SAXException {
        if (this.updates.size() > 0) {
            try {
                for (Object[] upd : this.updates) {
                    this.idx = (Integer)upd[0];
                    if (this.lastval.equals(upd[1])) continue;
                    this.insertValue((String)upd[1]);
                }
                this.rs.updateRow();
            }
            catch (SQLException ex) {
                throw new SAXException(MessageFormat.format(this.resBundle.handleGetObject("xmlrch.errupdrow").toString(), ex.getMessage()));
            }
            this.updates.removeAllElements();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            switch (this.getState()) {
                case 1: {
                    this.propertyValue = new String(ch, start, length);
                    this.propertyValue = this.tempCommand = this.tempCommand.concat(this.propertyValue);
                    if (this.tag == 19) {
                        this.Key_map = this.propertyValue;
                        break;
                    }
                    if (this.tag != 20) break;
                    this.Value_map = this.propertyValue;
                    break;
                }
                case 2: {
                    if (this.tag == -1) break;
                    this.metaDataValue = new String(ch, start, length);
                    break;
                }
                case 3: {
                    this.setDataValue(ch, start, length);
                    break;
                }
            }
        }
        catch (SQLException ex) {
            throw new SAXException(this.resBundle.handleGetObject("xmlrch.chars").toString() + ex.getMessage());
        }
    }

    private void setState(String s) throws SAXException {
        if (s.equals("webRowSet")) {
            this.state = 0;
        } else if (s.equals("properties")) {
            this.state = this.state != 1 ? 1 : 0;
        } else if (s.equals("metadata")) {
            this.state = this.state != 2 ? 2 : 0;
        } else if (s.equals("data")) {
            this.state = this.state != 3 ? 3 : 0;
        }
    }

    private int getState() {
        return this.state;
    }

    private void setTag(int t) {
        this.tag = t;
    }

    private int getTag() {
        return this.tag;
    }

    private void setNullValue(boolean n) {
        this.nullVal = n;
    }

    private boolean getNullValue() {
        return this.nullVal;
    }

    private void setEmptyStringValue(boolean e) {
        this.emptyStringVal = e;
    }

    private boolean getEmptyStringValue() {
        return this.emptyStringVal;
    }

    private String getStringValue(String s) {
        return s;
    }

    private int getIntegerValue(String s) {
        return Integer.parseInt(s);
    }

    private boolean getBooleanValue(String s) {
        return Boolean.valueOf(s);
    }

    private BigDecimal getBigDecimalValue(String s) {
        return new BigDecimal(s);
    }

    private byte getByteValue(String s) {
        return Byte.parseByte(s);
    }

    private short getShortValue(String s) {
        return Short.parseShort(s);
    }

    private long getLongValue(String s) {
        return Long.parseLong(s);
    }

    private float getFloatValue(String s) {
        return Float.parseFloat(s);
    }

    private double getDoubleValue(String s) {
        return Double.parseDouble(s);
    }

    private byte[] getBinaryValue(String s) {
        return s.getBytes();
    }

    private Date getDateValue(String s) {
        return new Date(this.getLongValue(s));
    }

    private Time getTimeValue(String s) {
        return new Time(this.getLongValue(s));
    }

    private Timestamp getTimestampValue(String s) {
        return new Timestamp(this.getLongValue(s));
    }

    private void setPropertyValue(String s) throws SQLException {
        boolean nullValue = this.getNullValue();
        switch (this.getTag()) {
            case 0: {
                if (nullValue) break;
                this.rs.setCommand(s);
                break;
            }
            case 1: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue").toString());
                }
                this.rs.setConcurrency(this.getIntegerValue(s));
                break;
            }
            case 2: {
                if (nullValue) {
                    this.rs.setDataSourceName(null);
                    break;
                }
                this.rs.setDataSourceName(s);
                break;
            }
            case 3: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue").toString());
                }
                this.rs.setEscapeProcessing(this.getBooleanValue(s));
                break;
            }
            case 4: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue").toString());
                }
                this.rs.setFetchDirection(this.getIntegerValue(s));
                break;
            }
            case 5: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue").toString());
                }
                this.rs.setFetchSize(this.getIntegerValue(s));
                break;
            }
            case 6: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue").toString());
                }
                this.rs.setTransactionIsolation(this.getIntegerValue(s));
                break;
            }
            case 7: {
                break;
            }
            case 18: {
                if (this.keyCols == null) {
                    this.keyCols = new Vector();
                }
                this.keyCols.add(s);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue").toString());
                }
                this.rs.setMaxFieldSize(this.getIntegerValue(s));
                break;
            }
            case 10: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue").toString());
                }
                this.rs.setMaxRows(this.getIntegerValue(s));
                break;
            }
            case 11: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue").toString());
                }
                this.rs.setQueryTimeout(this.getIntegerValue(s));
                break;
            }
            case 12: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue").toString());
                }
                this.rs.setReadOnly(this.getBooleanValue(s));
                break;
            }
            case 13: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue").toString());
                }
                String strType = this.getStringValue(s);
                int iType = 0;
                if (strType.trim().equals("ResultSet.TYPE_SCROLL_INSENSITIVE")) {
                    iType = 1004;
                } else if (strType.trim().equals("ResultSet.TYPE_SCROLL_SENSITIVE")) {
                    iType = 1005;
                } else if (strType.trim().equals("ResultSet.TYPE_FORWARD_ONLY")) {
                    iType = 1003;
                }
                this.rs.setType(iType);
                break;
            }
            case 14: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue").toString());
                }
                this.rs.setShowDeleted(this.getBooleanValue(s));
                break;
            }
            case 15: {
                if (nullValue) break;
                this.rs.setTableName(s);
                break;
            }
            case 16: {
                if (nullValue) {
                    this.rs.setUrl(null);
                    break;
                }
                this.rs.setUrl(s);
                break;
            }
            case 22: {
                if (nullValue) {
                    this.rs.setSyncProvider(null);
                    break;
                }
                String str = s.substring(0, s.indexOf("@") + 1);
                this.rs.setSyncProvider(str);
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
        }
    }

    private void setMetaDataValue(String s) throws SQLException {
        boolean nullValue = this.getNullValue();
        switch (this.getTag()) {
            case 0: {
                this.md = new RowSetMetaDataImpl();
                this.idx = 0;
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue1").toString());
                }
                this.md.setColumnCount(this.getIntegerValue(s));
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                ++this.idx;
                break;
            }
            case 3: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue1").toString());
                }
                this.md.setAutoIncrement(this.idx, this.getBooleanValue(s));
                break;
            }
            case 4: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue1").toString());
                }
                this.md.setCaseSensitive(this.idx, this.getBooleanValue(s));
                break;
            }
            case 5: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue1").toString());
                }
                this.md.setCurrency(this.idx, this.getBooleanValue(s));
                break;
            }
            case 6: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue1").toString());
                }
                this.md.setNullable(this.idx, this.getIntegerValue(s));
                break;
            }
            case 7: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue1").toString());
                }
                this.md.setSigned(this.idx, this.getBooleanValue(s));
                break;
            }
            case 8: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue1").toString());
                }
                this.md.setSearchable(this.idx, this.getBooleanValue(s));
                break;
            }
            case 9: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue1").toString());
                }
                this.md.setColumnDisplaySize(this.idx, this.getIntegerValue(s));
                break;
            }
            case 10: {
                if (nullValue) {
                    this.md.setColumnLabel(this.idx, null);
                    break;
                }
                this.md.setColumnLabel(this.idx, s);
                break;
            }
            case 11: {
                if (nullValue) {
                    this.md.setColumnName(this.idx, null);
                    break;
                }
                this.md.setColumnName(this.idx, s);
                break;
            }
            case 12: {
                if (nullValue) {
                    this.md.setSchemaName(this.idx, null);
                    break;
                }
                this.md.setSchemaName(this.idx, s);
                break;
            }
            case 13: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue1").toString());
                }
                this.md.setPrecision(this.idx, this.getIntegerValue(s));
                break;
            }
            case 14: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue1").toString());
                }
                this.md.setScale(this.idx, this.getIntegerValue(s));
                break;
            }
            case 15: {
                if (nullValue) {
                    this.md.setTableName(this.idx, null);
                    break;
                }
                this.md.setTableName(this.idx, s);
                break;
            }
            case 16: {
                if (nullValue) {
                    this.md.setCatalogName(this.idx, null);
                    break;
                }
                this.md.setCatalogName(this.idx, s);
                break;
            }
            case 17: {
                if (nullValue) {
                    throw new SQLException(this.resBundle.handleGetObject("xmlrch.badvalue1").toString());
                }
                this.md.setColumnType(this.idx, this.getIntegerValue(s));
                break;
            }
            case 18: {
                if (nullValue) {
                    this.md.setColumnTypeName(this.idx, null);
                    break;
                }
                this.md.setColumnTypeName(this.idx, s);
                break;
            }
        }
    }

    private void setDataValue(char[] ch, int start, int len) throws SQLException {
        switch (this.getTag()) {
            case 1: {
                this.columnValue = new String(ch, start, len);
                this.tempStr = this.tempStr.concat(this.columnValue);
                break;
            }
            case 5: {
                this.upd = new Object[2];
                this.tempUpdate = this.tempUpdate.concat(new String(ch, start, len));
                this.upd[0] = this.idx;
                this.upd[1] = this.tempUpdate;
                this.lastval = (String)this.upd[1];
                break;
            }
        }
    }

    private void insertValue(String s) throws SQLException {
        if (this.getNullValue()) {
            this.rs.updateNull(this.idx);
            return;
        }
        int type = this.rs.getMetaData().getColumnType(this.idx);
        switch (type) {
            case -7: {
                this.rs.updateBoolean(this.idx, this.getBooleanValue(s));
                break;
            }
            case 16: {
                this.rs.updateBoolean(this.idx, this.getBooleanValue(s));
                break;
            }
            case -6: 
            case 5: {
                this.rs.updateShort(this.idx, this.getShortValue(s));
                break;
            }
            case 4: {
                this.rs.updateInt(this.idx, this.getIntegerValue(s));
                break;
            }
            case -5: {
                this.rs.updateLong(this.idx, this.getLongValue(s));
                break;
            }
            case 6: 
            case 7: {
                this.rs.updateFloat(this.idx, this.getFloatValue(s));
                break;
            }
            case 8: {
                this.rs.updateDouble(this.idx, this.getDoubleValue(s));
                break;
            }
            case 2: 
            case 3: {
                this.rs.updateObject(this.idx, (Object)this.getBigDecimalValue(s));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.rs.updateBytes(this.idx, this.getBinaryValue(s));
                break;
            }
            case 91: {
                this.rs.updateDate(this.idx, this.getDateValue(s));
                break;
            }
            case 92: {
                this.rs.updateTime(this.idx, this.getTimeValue(s));
                break;
            }
            case 93: {
                this.rs.updateTimestamp(this.idx, this.getTimestampValue(s));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.rs.updateString(this.idx, this.getStringValue(s));
                break;
            }
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        throw e;
    }

    @Override
    public void warning(SAXParseException err) throws SAXParseException {
        System.out.println(MessageFormat.format(this.resBundle.handleGetObject("xmlrch.warning").toString(), err.getMessage(), err.getLineNumber(), err.getSystemId()));
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
    }

    private Row getPresentRow(WebRowSetImpl rs) throws SQLException {
        return null;
    }
}

