/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.jberet;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.TransactionManager;
import org.jberet.repository.JobRepository;
import org.jberet.spi.ArtifactFactory;
import org.jberet.spi.BatchEnvironment;
import org.jberet.spi.JobXmlResolver;
import org.wildfly.jberet._private.WildFlyBatchLogger;
import org.wildfly.security.manager.WildFlySecurityManager;

public class BatchEnvironmentFactory {
    private final ConcurrentMap<ClassLoader, BatchEnvironment> environments = new ConcurrentHashMap<ClassLoader, BatchEnvironment>();
    private static final BatchEnvironment INVALID_BATCH_ENV = new BatchEnvironment(){

        public ClassLoader getClassLoader() {
            throw WildFlyBatchLogger.LOGGER.invalidBatchEnvironment();
        }

        public ArtifactFactory getArtifactFactory() {
            throw WildFlyBatchLogger.LOGGER.invalidBatchEnvironment();
        }

        public void submitTask(Runnable runnable) {
            throw WildFlyBatchLogger.LOGGER.invalidBatchEnvironment();
        }

        public TransactionManager getTransactionManager() {
            throw WildFlyBatchLogger.LOGGER.invalidBatchEnvironment();
        }

        public JobRepository getJobRepository() {
            throw WildFlyBatchLogger.LOGGER.invalidBatchEnvironment();
        }

        public JobXmlResolver getJobXmlResolver() {
            throw WildFlyBatchLogger.LOGGER.invalidBatchEnvironment();
        }

        @Deprecated
        public Properties getBatchConfigurationProperties() {
            throw WildFlyBatchLogger.LOGGER.invalidBatchEnvironment();
        }
    };

    public static BatchEnvironmentFactory getInstance() {
        return Holder.INSTANCE;
    }

    public BatchEnvironment getBatchEnvironment() {
        return this.getBatchEnvironment(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged());
    }

    public BatchEnvironment getBatchEnvironment(ClassLoader cl) {
        BatchEnvironment result = (BatchEnvironment)this.environments.get(cl);
        if (result == null) {
            result = INVALID_BATCH_ENV;
        }
        return result;
    }

    public void add(BatchEnvironment batchEnvironment) {
        this.add(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged(), batchEnvironment);
    }

    public void add(ClassLoader cl, BatchEnvironment batchEnvironment) {
        this.environments.putIfAbsent(cl, batchEnvironment);
    }

    public BatchEnvironment remove() {
        return this.remove(WildFlySecurityManager.getCurrentContextClassLoaderPrivileged());
    }

    public BatchEnvironment remove(ClassLoader cl) {
        return (BatchEnvironment)this.environments.remove(cl);
    }

    private static class Holder {
        static final BatchEnvironmentFactory INSTANCE = new BatchEnvironmentFactory();

        private Holder() {
        }
    }
}

