/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.action;

import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.EncryptionActionToken;
import org.apache.wss4j.common.SecurityActionToken;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.action.AbstractDerivedAction;
import org.apache.wss4j.dom.action.Action;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandler;
import org.apache.wss4j.dom.message.WSSecDKEncrypt;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.token.SecurityContextToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptionDerivedAction
extends AbstractDerivedAction
implements Action {
    @Override
    public void execute(WSHandler handler, SecurityActionToken actionToken, Document doc, RequestData reqData) throws WSSecurityException {
        CallbackHandler callbackHandler = reqData.getCallbackHandler();
        if (callbackHandler == null) {
            callbackHandler = handler.getPasswordCallbackHandler(reqData);
        }
        EncryptionActionToken encryptionToken = null;
        if (actionToken instanceof EncryptionActionToken) {
            encryptionToken = (EncryptionActionToken)actionToken;
        }
        if (encryptionToken == null) {
            encryptionToken = reqData.getEncryptionToken();
        }
        WSPasswordCallback passwordCallback = handler.getPasswordCB(encryptionToken.getUser(), 65536, callbackHandler, reqData);
        WSSecDKEncrypt wsEncrypt = new WSSecDKEncrypt(reqData.getWssConfig());
        if (encryptionToken.getKeyIdentifierId() != 0) {
            wsEncrypt.setKeyIdentifierType(encryptionToken.getKeyIdentifierId());
        }
        if (encryptionToken.getSymmetricAlgorithm() != null) {
            wsEncrypt.setSymmetricEncAlgorithm(encryptionToken.getSymmetricAlgorithm());
        }
        wsEncrypt.setUserInfo(encryptionToken.getUser(), passwordCallback.getPassword());
        if (reqData.isUse200512Namespace()) {
            wsEncrypt.setWscVersion(2);
        } else {
            wsEncrypt.setWscVersion(1);
        }
        if (encryptionToken.getDerivedKeyLength() > 0) {
            wsEncrypt.setDerivedKeyLength(encryptionToken.getDerivedKeyLength());
        }
        Element tokenElement = this.setupTokenReference(reqData, encryptionToken, wsEncrypt, passwordCallback, doc);
        wsEncrypt.setAttachmentCallbackHandler(reqData.getAttachmentCallbackHandler());
        try {
            ArrayList<WSEncryptionPart> parts = encryptionToken.getParts();
            if (parts == null || parts.isEmpty()) {
                WSEncryptionPart encP = new WSEncryptionPart(reqData.getSoapConstants().getBodyQName().getLocalPart(), reqData.getSoapConstants().getEnvelopeURI(), "Content");
                parts = new ArrayList<WSEncryptionPart>();
                parts.add(encP);
            }
            wsEncrypt.setParts((List<WSEncryptionPart>)parts);
            wsEncrypt.prepare(doc);
            Element externRefList = wsEncrypt.encryptForExternalRef(null, (List<WSEncryptionPart>)parts);
            Node nextSibling = null;
            if (tokenElement == null && "EncryptedKey".equals(encryptionToken.getDerivedKeyTokenReference())) {
                nextSibling = this.findEncryptedKeySibling(reqData);
            } else if (tokenElement == null && "SecurityContextToken".equals(encryptionToken.getDerivedKeyTokenReference())) {
                nextSibling = this.findSCTSibling(reqData);
            }
            if (nextSibling == null) {
                wsEncrypt.prependDKElementToHeader(reqData.getSecHeader());
            } else {
                reqData.getSecHeader().getSecurityHeader().insertBefore(wsEncrypt.getdktElement(), nextSibling);
            }
            wsEncrypt.addExternalRefElement(externRefList, reqData.getSecHeader());
            if (tokenElement != null) {
                WSSecurityUtil.prependChildElement(reqData.getSecHeader().getSecurityHeader(), tokenElement);
            }
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "empty", (Exception)((Object)e), new Object[]{"Error during Encryption: "});
        }
    }

    private Element setupTokenReference(RequestData reqData, EncryptionActionToken encryptionToken, WSSecDKEncrypt wsEncrypt, WSPasswordCallback passwordCallback, Document doc) throws WSSecurityException {
        String derivedKeyTokenReference = encryptionToken.getDerivedKeyTokenReference();
        if ("SecurityContextToken".equals(derivedKeyTokenReference)) {
            if (reqData.isUse200512Namespace()) {
                wsEncrypt.setCustomValueType("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct");
            } else {
                wsEncrypt.setCustomValueType("http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
            }
            if (reqData.getSignatureToken() != null && reqData.getSignatureToken().getKey() != null && reqData.getSignatureToken().getKeyIdentifier() != null) {
                byte[] secret = reqData.getSignatureToken().getKey();
                String tokenIdentifier = reqData.getSignatureToken().getKeyIdentifier();
                wsEncrypt.setExternalKey(secret, tokenIdentifier);
                return null;
            }
            String tokenIdentifier = IDGenerator.generateID((String)"uuid:");
            wsEncrypt.setExternalKey(passwordCallback.getKey(), tokenIdentifier);
            encryptionToken.setKey(passwordCallback.getKey());
            encryptionToken.setKeyIdentifier(tokenIdentifier);
            int version = 2;
            if (!reqData.isUse200512Namespace()) {
                version = 1;
            }
            SecurityContextToken sct = new SecurityContextToken(version, doc, tokenIdentifier);
            return sct.getElement();
        }
        wsEncrypt.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        if (reqData.getSignatureToken() != null && reqData.getSignatureToken().getKey() != null && reqData.getSignatureToken().getKeyIdentifier() != null) {
            byte[] ek = reqData.getSignatureToken().getKey();
            String tokenIdentifier = reqData.getSignatureToken().getKeyIdentifier();
            wsEncrypt.setExternalKey(ek, tokenIdentifier);
            return null;
        }
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey();
        encrKeyBuilder.setUserInfo(encryptionToken.getUser());
        if (encryptionToken.getDerivedKeyIdentifier() != 0) {
            encrKeyBuilder.setKeyIdentifierType(encryptionToken.getDerivedKeyIdentifier());
        } else {
            encrKeyBuilder.setKeyIdentifierType(8);
        }
        if (encryptionToken.getKeyTransportAlgorithm() != null) {
            encrKeyBuilder.setKeyEncAlgo(encryptionToken.getKeyTransportAlgorithm());
        }
        if (encryptionToken.getDigestAlgorithm() != null) {
            encrKeyBuilder.setDigestAlgorithm(encryptionToken.getDigestAlgorithm());
        }
        if (encryptionToken.getMgfAlgorithm() != null) {
            encrKeyBuilder.setMGFAlgorithm(encryptionToken.getMgfAlgorithm());
        }
        encrKeyBuilder.prepare(doc, encryptionToken.getCrypto());
        byte[] ek = encrKeyBuilder.getEphemeralKey();
        String tokenIdentifier = encrKeyBuilder.getId();
        wsEncrypt.setExternalKey(ek, tokenIdentifier);
        encryptionToken.setKey(ek);
        encryptionToken.setKeyIdentifier(tokenIdentifier);
        return encrKeyBuilder.getEncryptedKeyElement();
    }
}

