/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.validate;

import java.security.Key;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.kerberos.KerberosServiceContext;
import org.apache.wss4j.common.kerberos.KerberosServiceExceptionAction;
import org.apache.wss4j.common.kerberos.KerberosTokenDecoder;
import org.apache.wss4j.common.kerberos.KerberosTokenDecoderException;
import org.apache.wss4j.common.kerberos.KerberosTokenDecoderImpl;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.message.token.KerberosSecurity;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosTokenValidator
implements Validator {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosTokenValidator.class);
    private String serviceName;
    private CallbackHandler callbackHandler;
    private String contextName;
    private KerberosTokenDecoder kerberosTokenDecoder;
    private boolean isUsernameServiceNameForm;
    private boolean spnego;

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public KerberosTokenDecoder getKerberosTokenDecoder() {
        return this.kerberosTokenDecoder;
    }

    public void setKerberosTokenDecoder(KerberosTokenDecoder kerberosTokenDecoder) {
        this.kerberosTokenDecoder = kerberosTokenDecoder;
    }

    @Override
    public Credential validate(Credential credential, RequestData data) throws WSSecurityException {
        if (credential == null || credential.getBinarySecurityToken() == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCredential", new Object[0]);
        }
        BinarySecurity binarySecurity = credential.getBinarySecurityToken();
        if (!(binarySecurity instanceof KerberosSecurity)) {
            return credential;
        }
        if (LOG.isDebugEnabled()) {
            try {
                String jaasAuth = System.getProperty("java.security.auth.login.config");
                String krbConf = System.getProperty("java.security.krb5.conf");
                LOG.debug("KerberosTokenValidator - Using JAAS auth login file: " + jaasAuth);
                LOG.debug("KerberosTokenValidator - Using KRB conf file: " + krbConf);
            }
            catch (SecurityException ex) {
                LOG.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        LoginContext loginContext = null;
        try {
            loginContext = this.callbackHandler != null ? new LoginContext(this.getContextName(), this.callbackHandler) : (data.getCallbackHandler() != null ? new LoginContext(this.getContextName(), data.getCallbackHandler()) : new LoginContext(this.getContextName()));
            loginContext.login();
        }
        catch (LoginException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(ex.getMessage(), (Throwable)ex);
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosLoginError", (Exception)ex, new Object[]{ex.getMessage()});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully authenticated to the TGT");
        }
        byte[] token = binarySecurity.getToken();
        Subject subject = loginContext.getSubject();
        String service = this.serviceName;
        if (service == null) {
            Set<Principal> principals = subject.getPrincipals();
            if (principals.isEmpty()) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosLoginError", new Object[]{"No Client principals found after login"});
            }
            service = principals.iterator().next().getName();
        }
        KerberosServiceExceptionAction action = new KerberosServiceExceptionAction(token, service, this.isUsernameServiceNameForm(), this.spnego);
        KerberosServiceContext krbServiceCtx = null;
        try {
            krbServiceCtx = (KerberosServiceContext)Subject.doAs(subject, action);
        }
        catch (PrivilegedActionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof WSSecurityException) {
                throw (WSSecurityException)cause;
            }
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "kerberosTicketValidationError", new Object[]{new Object[0], cause});
        }
        credential.setPrincipal(krbServiceCtx.getPrincipal());
        credential.setDelegationCredential(krbServiceCtx.getDelegationCredential());
        LOG.debug("Trying to obtain the Session Key from the KerberosServiceContext.");
        Key sessionKey = krbServiceCtx.getSessionKey();
        if (null != sessionKey) {
            LOG.debug("Found session key in the KerberosServiceContext.");
            credential.setSecretKey(sessionKey.getEncoded());
        } else {
            LOG.debug("Session key is not found in the KerberosServiceContext.");
        }
        if (null == credential.getSecretKey()) {
            KerberosTokenDecoder kerberosTokenDecoder = this.kerberosTokenDecoder;
            if (kerberosTokenDecoder == null) {
                kerberosTokenDecoder = new KerberosTokenDecoderImpl();
            }
            LOG.debug("KerberosTokenDecoder is set.Trying to obtain the session key from it.");
            kerberosTokenDecoder.clear();
            kerberosTokenDecoder.setToken(token);
            kerberosTokenDecoder.setSubject(subject);
            try {
                byte[] key = kerberosTokenDecoder.getSessionKey();
                if (null != key) {
                    LOG.debug("Session key obtained from the KerberosTokenDecoder.");
                    credential.setSecretKey(key);
                }
                LOG.debug("Session key could not be obtained from the KerberosTokenDecoder.");
            }
            catch (KerberosTokenDecoderException e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "Error retrieving session key.", (Exception)((Object)e));
            }
        } else {
            LOG.debug("KerberosTokenDecoder is not set.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully validated a ticket");
        }
        return credential;
    }

    public boolean isUsernameServiceNameForm() {
        return this.isUsernameServiceNameForm;
    }

    public void setUsernameServiceNameForm(boolean isUsernameServiceNameForm) {
        this.isUsernameServiceNameForm = isUsernameServiceNameForm;
    }

    public boolean isSpnego() {
        return this.spnego;
    }

    public void setSpnego(boolean spnego) {
        this.spnego = spnego;
    }
}

