/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan;

import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.manager.EmbeddedCacheManager;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.web.IdentifierFactory;

public class AffinityIdentifierFactory<K>
implements IdentifierFactory<K>,
KeyGenerator<K> {
    private final IdentifierFactory<K> factory;
    private final KeyAffinityService<K> affinity;
    private final EmbeddedCacheManager manager;

    public AffinityIdentifierFactory(IdentifierFactory<K> factory, Cache<K, ?> cache, KeyAffinityServiceFactory affinityFactory) {
        this.factory = factory;
        this.affinity = affinityFactory.createService(cache, (KeyGenerator)this);
        this.manager = cache.getCacheManager();
    }

    public K createIdentifier() {
        return (K)this.affinity.getKeyForAddress(this.manager.getAddress());
    }

    public K getKey() {
        return (K)this.factory.createIdentifier();
    }

    public void start() {
        this.factory.start();
        this.affinity.start();
    }

    public void stop() {
        this.affinity.stop();
        this.factory.stop();
    }
}

