/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.settings.FileAccessPermission;
import org.jboss.aesh.history.InMemoryHistory;
import org.jboss.aesh.util.LoggerUtil;

public class FileHistory
extends InMemoryHistory {
    private String historyFile;
    private static final Logger LOGGER = LoggerUtil.getLogger(FileHistory.class.getName());
    private final FileAccessPermission historyFilePermission;

    public FileHistory(String fileName, int maxSize, FileAccessPermission historyFilePermission) throws IOException {
        super(maxSize);
        this.historyFile = fileName;
        this.historyFilePermission = historyFilePermission;
        this.readFile();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void start() {
                try {
                    FileHistory.this.writeFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void readFile() {
        if (new File(this.historyFile).exists()) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(this.historyFile));
                while ((line = reader.readLine()) != null) {
                    this.push(line);
                }
                reader.close();
            }
            catch (IOException e) {
                LOGGER.warning("Failed to write to history file; " + e.getMessage());
            }
        }
    }

    private void writeFile() throws IOException {
        new File(this.historyFile).delete();
        FileWriter fw = new FileWriter(this.historyFile);
        for (int i = 0; i < this.size(); ++i) {
            fw.write(this.get(i) + Config.getLineSeparator());
        }
        if (this.historyFilePermission != null) {
            File file = new File(this.historyFile);
            file.setReadable(false, false);
            file.setReadable(this.historyFilePermission.isReadable(), this.historyFilePermission.isReadableOwnerOnly());
            file.setWritable(false, false);
            file.setWritable(this.historyFilePermission.isWritable(), this.historyFilePermission.isWritableOwnerOnly());
            file.setExecutable(false, false);
            file.setExecutable(this.historyFilePermission.isExecutable(), this.historyFilePermission.isExecutableOwnerOnly());
        }
        fw.flush();
        fw.close();
    }

    public void stop() {
        try {
            this.writeFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

