/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.dmr.ModelNode;

class ServerRequireRestartTask
implements Callable<OperationResponse> {
    public static final String OPERATION_NAME = "server-set-restart-required";
    public static final ModelNode OPERATION;
    private final ServerIdentity identity;
    private final ProxyController controller;
    private final OperationResponse originalResult;

    public ServerRequireRestartTask(ServerIdentity identity, ProxyController controller, OperationResponse originalResult) {
        this.identity = identity;
        this.controller = controller;
        this.originalResult = originalResult;
    }

    @Override
    public OperationResponse call() throws Exception {
        try {
            final AtomicReference txRef = new AtomicReference();
            ProxyController.ProxyOperationControl proxyControl = new ProxyController.ProxyOperationControl(){

                public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                    txRef.set(transaction);
                }

                public void operationFailed(ModelNode response) {
                    DomainControllerLogger.HOST_CONTROLLER_LOGGER.debugf("server restart required operation failed: %s", response);
                }

                public void operationCompleted(OperationResponse response) {
                }
            };
            ModelNode operation = ServerRequireRestartTask.createOperation(this.identity);
            this.controller.execute(operation, OperationMessageHandler.DISCARD, proxyControl, OperationAttachments.EMPTY);
            ModelController.OperationTransaction tx = (ModelController.OperationTransaction)txRef.get();
            if (tx != null) {
                tx.commit();
            } else {
                DomainControllerLogger.HOST_CONTROLLER_LOGGER.failedToSetServerInRestartRequireState(this.identity.getServerName());
            }
        }
        catch (Exception e) {
            DomainControllerLogger.HOST_CONTROLLER_LOGGER.debugf(e, "failed to send the server restart required operation", new Object[0]);
        }
        return this.originalResult;
    }

    private static ModelNode createOperation(ServerIdentity identity) {
        ModelNode address = new ModelNode();
        address.add("host", identity.getHostName());
        address.add("server", identity.getServerName());
        ModelNode operation = OPERATION.clone();
        operation.get("address").set(address);
        return operation;
    }

    static {
        ModelNode operation = new ModelNode();
        operation.get("operation").set(OPERATION_NAME);
        operation.get("address").setEmptyList();
        operation.protect();
        OPERATION = operation;
    }
}

