/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.AdvancedCacheConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.Mode;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public abstract class ClusteredCacheAddHandler
extends CacheAddHandler {
    ClusteredCacheAddHandler(CacheMode mode) {
        super(mode);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        super.populateModel(operation, model);
        for (AttributeDefinition attribute : ClusteredCacheResourceDefinition.ATTRIBUTES) {
            attribute.validateAndSet(operation, model);
        }
    }

    @Override
    void processModelNode(OperationContext context, String containerName, ModelNode containerModel, ModelNode cache, AdvancedCacheConfigurationBuilder configBuilder) throws OperationFailedException {
        super.processModelNode(context, containerName, containerModel, cache, configBuilder);
        ConfigurationBuilder builder = configBuilder.getConfigurationBuilder();
        Mode mode = Mode.valueOf(ClusteredCacheResourceDefinition.MODE.resolveModelAttribute(context, cache).asString());
        int queueSize = ClusteredCacheResourceDefinition.QUEUE_SIZE.resolveModelAttribute(context, cache).asInt();
        CacheMode cacheMode = mode.apply(this.mode);
        builder.clustering().cacheMode(cacheMode);
        if (cacheMode.isSynchronous()) {
            builder.clustering().sync().replTimeout(ClusteredCacheResourceDefinition.REMOTE_TIMEOUT.resolveModelAttribute(context, cache).asLong());
        } else {
            builder.clustering().async().useReplQueue(queueSize > 0).replQueueMaxElements(queueSize).replQueueInterval(ClusteredCacheResourceDefinition.QUEUE_FLUSH_INTERVAL.resolveModelAttribute(context, cache).asLong());
            if (ClusteredCacheResourceDefinition.ASYNC_MARSHALLING.resolveModelAttribute(context, cache).asBoolean()) {
                builder.clustering().async().asyncMarshalling();
            } else {
                builder.clustering().async().syncMarshalling();
            }
        }
    }
}

