/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.StoreAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreAddHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;

public enum StoreType {
    FILE("file-store", "FILE_STORE", new FileStoreAddHandler(), (AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE),
    REMOTE("remote-store", "REMOTE_STORE", new RemoteStoreAddHandler(), (AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE),
    STRING_KEYED_JDBC("string-keyed-jdbc-store", "STRING_KEYED_JDBC_STORE", new StringKeyedJDBCStoreAddHandler(), (AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE),
    BINARY_KEYED_JDBC("binary-keyed-jdbc-store", "BINARY_KEYED_JDBC_STORE", new BinaryKeyedJDBCStoreAddHandler(), (AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE),
    MIXED_KEYED_JDBC("mixed-keyed-jdbc-store", "MIXED_KEYED_JDBC_STORE", new MixedKeyedJDBCStoreAddHandler(), (AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE),
    CUSTOM("store", "STORE", new CustomStoreAddHandler(), (AbstractRemoveStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);

    private static final Map<String, StoreType> TYPES;
    private final PathElement path;
    private final StoreAddHandler addHandler;
    private final AbstractRemoveStepHandler removeHandler;

    static StoreType forName(String key) {
        return TYPES.get(key);
    }

    private StoreType(String key, String value, StoreAddHandler addHandler, AbstractRemoveStepHandler removeHandler) {
        this.path = PathElement.pathElement((String)key, (String)value);
        this.addHandler = addHandler;
        this.removeHandler = removeHandler;
    }

    public ResourceDescriptionResolver getResourceDescriptionResolver() {
        return new InfinispanResourceDescriptionResolver(this.path.getKey());
    }

    public PathElement pathElement() {
        return this.path;
    }

    public StoreAddHandler getAddHandler() {
        return this.addHandler;
    }

    public AbstractRemoveStepHandler getRemoveHandler() {
        return this.removeHandler;
    }

    static {
        TYPES = new HashMap<String, StoreType>();
        for (StoreType type : StoreType.values()) {
            TYPES.put(type.path.getKey(), type);
        }
    }
}

