/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.remote;

import java.io.IOException;
import java.util.Hashtable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.naming.Context;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.remote.RemoteNamingLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.naming.remote.server.RemoteNamingServerLogger;
import org.jboss.naming.remote.server.RemoteNamingService;
import org.jboss.remoting3.Endpoint;

public class RemoteNamingServerService
implements Service<RemoteNamingService> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"naming", "remote"});
    private final InjectedValue<ExecutorService> executorService = new InjectedValue();
    private final InjectedValue<Endpoint> endpoint = new InjectedValue();
    private final InjectedValue<NamingStore> namingStore = new InjectedValue();
    private RemoteNamingService remoteNamingService;

    public synchronized void start(StartContext context) throws StartException {
        try {
            NamingContext namingContext = new NamingContext((NamingStore)this.namingStore.getValue(), new Hashtable());
            this.remoteNamingService = new RemoteNamingService((Context)namingContext, (Executor)this.executorService.getValue(), (RemoteNamingServerLogger)RemoteNamingLogger.INSTANCE);
            this.remoteNamingService.start((Endpoint)this.endpoint.getValue());
        }
        catch (Exception e) {
            throw new StartException("Failed to start remote naming service", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        try {
            this.remoteNamingService.stop();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to stop remote naming service", e);
        }
    }

    public synchronized RemoteNamingService getValue() throws IllegalStateException, IllegalArgumentException {
        return this.remoteNamingService;
    }

    public Injector<ExecutorService> getExecutorServiceInjector() {
        return this.executorService;
    }

    public Injector<Endpoint> getEndpointInjector() {
        return this.endpoint;
    }

    public Injector<NamingStore> getNamingStoreInjector() {
        return this.namingStore;
    }
}

