package org.jboss.as.weld.logging;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.weld.resources.spi.ClassFileInfoException;
import javax.annotation.Generated;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.io.IOException;
import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import java.net.URL;
import java.lang.Exception;
import java.lang.reflect.Type;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.ClassLoader;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import java.lang.Object;
import org.jboss.modules.ModuleIdentifier;
import java.util.Arrays;
import java.lang.reflect.Member;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-02-15T15:49:33+0000")
public class WeldLogger_$logger extends DelegatingBasicLogger implements WeldLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = WeldLogger_$logger.class.getName();
    public WeldLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void failedToSetupWeldContexts(final Throwable throwable) {
        super.log.logf(FQCN, ERROR, throwable, failedToSetupWeldContexts$str());
    }
    private static final String failedToSetupWeldContexts = "WFLYWELD0001: Failed to setup Weld contexts";
    protected String failedToSetupWeldContexts$str() {
        return failedToSetupWeldContexts;
    }
    @Override
    public final void failedToTearDownWeldContexts(final Throwable throwable) {
        super.log.logf(FQCN, ERROR, throwable, failedToTearDownWeldContexts$str());
    }
    private static final String failedToTearDownWeldContexts = "WFLYWELD0002: Failed to tear down Weld contexts";
    protected String failedToTearDownWeldContexts$str() {
        return failedToTearDownWeldContexts;
    }
    @Override
    public final void processingWeldDeployment(final String deployment) {
        super.log.logf(FQCN, INFO, null, processingWeldDeployment$str(), deployment);
    }
    private static final String processingWeldDeployment = "WFLYWELD0003: Processing weld deployment %s";
    protected String processingWeldDeployment$str() {
        return processingWeldDeployment;
    }
    @Override
    public final void couldNotFindBeanManagerForDeployment(final String beanManager) {
        super.log.logf(FQCN, ERROR, null, couldNotFindBeanManagerForDeployment$str(), beanManager);
    }
    private static final String couldNotFindBeanManagerForDeployment = "WFLYWELD0005: Could not find BeanManager for deployment %s";
    protected String couldNotFindBeanManagerForDeployment$str() {
        return couldNotFindBeanManagerForDeployment;
    }
    @Override
    public final void startingServicesForCDIDeployment(final String deploymentName) {
        super.log.logf(FQCN, DEBUG, null, startingServicesForCDIDeployment$str(), deploymentName);
    }
    private static final String startingServicesForCDIDeployment = "WFLYWELD0006: Starting Services for CDI deployment: %s";
    protected String startingServicesForCDIDeployment$str() {
        return startingServicesForCDIDeployment;
    }
    @Override
    public final void couldNotLoadPortableExceptionClass(final String className, final Throwable throwable) {
        super.log.logf(FQCN, WARN, throwable, couldNotLoadPortableExceptionClass$str(), className);
    }
    private static final String couldNotLoadPortableExceptionClass = "WFLYWELD0007: Could not load portable extension class %s";
    protected String couldNotLoadPortableExceptionClass$str() {
        return couldNotLoadPortableExceptionClass;
    }
    @Override
    public final void injectionTypeNotValue(final String type, final Member injectionPoint) {
        super.log.logf(FQCN, WARN, null, injectionTypeNotValue$str(), type, injectionPoint);
    }
    private static final String injectionTypeNotValue = "WFLYWELD0008: @Resource injection of type %s is not supported for non-ejb components. Injection point: %s";
    protected String injectionTypeNotValue$str() {
        return injectionTypeNotValue;
    }
    @Override
    public final void startingWeldService(final String deploymentName) {
        super.log.logf(FQCN, DEBUG, null, startingWeldService$str(), deploymentName);
    }
    private static final String startingWeldService = "WFLYWELD0009: Starting weld service for deployment %s";
    protected String startingWeldService$str() {
        return startingWeldService;
    }
    @Override
    public final void stoppingWeldService(final String deploymentName) {
        super.log.logf(FQCN, DEBUG, null, stoppingWeldService$str(), deploymentName);
    }
    private static final String stoppingWeldService = "WFLYWELD0010: Stopping weld service for deployment %s";
    protected String stoppingWeldService$str() {
        return stoppingWeldService;
    }
    @Override
    public final void beansXmlValidationWarning(final URL file, final int line, final String message) {
        super.log.logf(FQCN, WARN, null, beansXmlValidationWarning$str(), file, line, message);
    }
    private static final String beansXmlValidationWarning = "WFLYWELD0011: Warning while parsing %s:%s %s";
    protected String beansXmlValidationWarning$str() {
        return beansXmlValidationWarning;
    }
    @Override
    public final void beansXmlValidationError(final URL file, final int line, final String message) {
        super.log.logf(FQCN, WARN, null, beansXmlValidationError$str(), file, line, message);
    }
    private static final String beansXmlValidationError = "WFLYWELD0012: Warning while parsing %s:%s %s";
    protected String beansXmlValidationError$str() {
        return beansXmlValidationError;
    }
    @Override
    public final void cdiAnnotationsButNotBeanArchive(final String deploymentUnit) {
        super.log.logf(FQCN, WARN, null, cdiAnnotationsButNotBeanArchive$str(), deploymentUnit);
    }
    private static final String cdiAnnotationsButNotBeanArchive = "WFLYWELD0013: Deployment %s contains CDI annotations but no bean archive was found (no beans.xml or class with bean defining annotations was present).";
    protected String cdiAnnotationsButNotBeanArchive$str() {
        return cdiAnnotationsButNotBeanArchive;
    }
    @Override
    public final void exceptionClearingThreadState(final Exception e) {
        super.log.logf(FQCN, ERROR, e, exceptionClearingThreadState$str());
    }
    private static final String exceptionClearingThreadState = "WFLYWELD0014: Exception tearing down thread state";
    protected String exceptionClearingThreadState$str() {
        return exceptionClearingThreadState;
    }
    @Override
    public final void couldNotReadEntries(final IOException ioe) {
        super.log.logf(FQCN, ERROR, ioe, couldNotReadEntries$str());
    }
    private static final String couldNotReadEntries = "WFLYWELD0016: Could not read entries";
    protected String couldNotReadEntries$str() {
        return couldNotReadEntries;
    }
    @Override
    public final void doNotUnderstandProtocol(final URL url) {
        super.log.logf(FQCN, WARN, null, doNotUnderstandProtocol$str(), url);
    }
    private static final String doNotUnderstandProtocol = "WFLYWELD0017: URL scanner does not understand the URL protocol %s, CDI beans will not be scanned.";
    protected String doNotUnderstandProtocol$str() {
        return doNotUnderstandProtocol;
    }
    @Override
    public final void duplicateBeansXml() {
        super.log.logf(FQCN, WARN, null, duplicateBeansXml$str());
    }
    private static final String duplicateBeansXml = "WFLYWELD0018: Found both WEB-INF/beans.xml and WEB-INF/classes/META-INF/beans.xml. It is not portable to use both locations at the same time. Weld is going to use the former location for this deployment.";
    protected String duplicateBeansXml$str() {
        return duplicateBeansXml;
    }
    private static final String couldNotGetBeansXmlAsURL = "WFLYWELD0019: Could get beans.xml file as URL when processing file: %s";
    protected String couldNotGetBeansXmlAsURL$str() {
        return couldNotGetBeansXmlAsURL;
    }
    @Override
    public final DeploymentUnitProcessingException couldNotGetBeansXmlAsURL(final String beansXml, final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), couldNotGetBeansXmlAsURL$str(), beansXml), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotLoadInterceptorClass = "WFLYWELD0020: Could not load interceptor class : %s";
    protected String couldNotLoadInterceptorClass$str() {
        return couldNotLoadInterceptorClass;
    }
    @Override
    public final DeploymentUnitProcessingException couldNotLoadInterceptorClass(final String interceptorClass, final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), couldNotLoadInterceptorClass$str(), interceptorClass), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String extensionDoesNotImplementExtension = "WFLYWELD0021: Service %s didn't implement the javax.enterprise.inject.spi.Extension interface";
    protected String extensionDoesNotImplementExtension$str() {
        return extensionDoesNotImplementExtension;
    }
    @Override
    public final DeploymentUnitProcessingException extensionDoesNotImplementExtension(final Class<?> clazz) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), extensionDoesNotImplementExtension$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String viewNotFoundOnEJB = "WFLYWELD0022: View of type %s not found on EJB %s";
    protected String viewNotFoundOnEJB$str() {
        return viewNotFoundOnEJB;
    }
    @Override
    public final IllegalArgumentException viewNotFoundOnEJB(final String viewType, final String ejb) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), viewNotFoundOnEJB$str(), viewType, ejb));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownInterceptorClassForCDIInjection = "WFLYWELD0030: Unknown interceptor class for CDI injection %s";
    protected String unknownInterceptorClassForCDIInjection$str() {
        return unknownInterceptorClassForCDIInjection;
    }
    @Override
    public final IllegalArgumentException unknownInterceptorClassForCDIInjection(final Class<?> interceptorClass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownInterceptorClassForCDIInjection$str(), interceptorClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parameterCannotBeNull = "WFLYWELD0031: %s cannot be null";
    protected String parameterCannotBeNull$str() {
        return parameterCannotBeNull;
    }
    @Override
    public final IllegalArgumentException parameterCannotBeNull(final String param) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parameterCannotBeNull$str(), param));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String injectionPointNotAJavabean = "WFLYWELD0032: Injection point represents a method which doesn't follow JavaBean conventions (must have exactly one parameter) %s";
    protected String injectionPointNotAJavabean$str() {
        return injectionPointNotAJavabean;
    }
    @Override
    public final IllegalArgumentException injectionPointNotAJavabean(final Method method) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), injectionPointNotAJavabean$str(), method));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String annotationNotFound = "WFLYWELD0033: %s annotation not found on %s";
    protected String annotationNotFound$str() {
        return annotationNotFound;
    }
    @Override
    public final IllegalArgumentException annotationNotFound(final Class<? extends java.lang.annotation.Annotation> type, final Member member) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), annotationNotFound$str(), type, member));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ejbNotResolved = "WFLYWELD0034: Could not resolve @EJB injection for %s on %s";
    protected String ejbNotResolved$str() {
        return ejbNotResolved;
    }
    @Override
    public final IllegalStateException ejbNotResolved(final Object ejb, final Member member) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ejbNotResolved$str(), ejb, member));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moreThanOneEjbResolved = "WFLYWELD0035: Resolved more than one EJB for @EJB injection of %s on %s. Found %s";
    protected String moreThanOneEjbResolved$str() {
        return moreThanOneEjbResolved;
    }
    @Override
    public final IllegalStateException moreThanOneEjbResolved(final Object ejb, final Member member, final java.util.Set<org.jboss.as.ee.component.ViewDescription> viewService) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), moreThanOneEjbResolved$str(), ejb, member, viewService));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotDetermineUnderlyingType = "WFLYWELD0036: Could not determine bean class from injection point type of %s";
    protected String couldNotDetermineUnderlyingType$str() {
        return couldNotDetermineUnderlyingType;
    }
    @Override
    public final IllegalArgumentException couldNotDetermineUnderlyingType(final Type type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotDetermineUnderlyingType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotFindPersistenceUnit = "WFLYWELD0037: Error injecting persistence unit into CDI managed bean. Can't find a persistence unit named '%s' in deployment %s for injection point %s";
    protected String couldNotFindPersistenceUnit$str() {
        return couldNotFindPersistenceUnit;
    }
    @Override
    public final IllegalArgumentException couldNotFindPersistenceUnit(final String unitName, final String deployment, final Member injectionPoint) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotFindPersistenceUnit$str(), unitName, deployment, injectionPoint));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String securityNotEnabled = "WFLYWELD0038: Could not inject SecurityManager, security is not enabled";
    protected String securityNotEnabled$str() {
        return securityNotEnabled;
    }
    @Override
    public final IllegalStateException securityNotEnabled() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), securityNotEnabled$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String singletonNotSet = "WFLYWELD0039: Singleton not set for %s. This means that you are trying to access a weld deployment with a Thread Context ClassLoader that is not associated with the deployment.";
    protected String singletonNotSet$str() {
        return singletonNotSet;
    }
    @Override
    public final IllegalStateException singletonNotSet(final ClassLoader classLoader) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), singletonNotSet$str(), classLoader));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String alreadyRunning = "WFLYWELD0040: %s is already running";
    protected String alreadyRunning$str() {
        return alreadyRunning;
    }
    @Override
    public final IllegalStateException alreadyRunning(final String object) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), alreadyRunning$str(), object));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notStarted = "WFLYWELD0041: %s is not started";
    protected String notStarted$str() {
        return notStarted;
    }
    @Override
    public final IllegalStateException notStarted(final String object) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notStarted$str(), object));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String beanDeploymentNotFound = "WFLYWELD0043: BeanDeploymentArchive with id %s not found in deployment";
    protected String beanDeploymentNotFound$str() {
        return beanDeploymentNotFound;
    }
    @Override
    public final IllegalArgumentException beanDeploymentNotFound(final String beanDeploymentId) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), beanDeploymentNotFound$str(), beanDeploymentId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotFindResource1 = "WFLYWELD0044: Error injecting resource into CDI managed bean. Can't find a resource named %s";
    protected String couldNotFindResource1$str() {
        return couldNotFindResource1;
    }
    @Override
    public final IllegalArgumentException couldNotFindResource(final String resourceName, final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotFindResource1$str(), resourceName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotDetermineResourceName = "WFLYWELD0045: Cannot determine resource name. Both jndiName and mappedName are null";
    protected String cannotDetermineResourceName$str() {
        return cannotDetermineResourceName;
    }
    @Override
    public final IllegalArgumentException cannotDetermineResourceName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotDetermineResourceName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInject = "WFLYWELD0046: Cannot inject injection point %s";
    protected String cannotInject$str() {
        return cannotInject;
    }
    @Override
    public final IllegalArgumentException cannotInject(final InjectionPoint ip) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotInject$str(), ip));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotUseAtRuntime = "WFLYWELD0047: %s cannot be used at runtime";
    protected String cannotUseAtRuntime$str() {
        return cannotUseAtRuntime;
    }
    @Override
    public final IllegalStateException cannotUseAtRuntime(final String description) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotUseAtRuntime$str(), description));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rejectAttributesMustBeTrue = "WFLYWELD0048: These attributes must be 'true' for use with CDI 1.0 '%s'";
    protected String rejectAttributesMustBeTrue$str() {
        return rejectAttributesMustBeTrue;
    }
    @Override
    public final String rejectAttributesMustBeTrue(final java.util.Set<String> keySet) {
        return String.format(getLoggingLocale(), rejectAttributesMustBeTrue$str(), keySet);
    }
    private static final String couldNotFindResource2 = "WFLYWELD0049: Error injecting resource into CDI managed bean. Can't find a resource named %s defined on %s";
    protected String couldNotFindResource2$str() {
        return couldNotFindResource2;
    }
    @Override
    public final IllegalArgumentException couldNotFindResource(final String resourceName, final String member, final Throwable cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotFindResource2$str(), resourceName, member), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void beanArchiveDiscovered(final BeanDeploymentArchive bda) {
        super.log.logf(FQCN, DEBUG, null, beanArchiveDiscovered$str(), bda);
    }
    private static final String beanArchiveDiscovered = "Discovered %s";
    protected String beanArchiveDiscovered$str() {
        return beanArchiveDiscovered;
    }
    private static final String nameNotFoundInIndex = "WFLYWELD0050: %s was not found in composite index";
    protected String nameNotFoundInIndex$str() {
        return nameNotFoundInIndex;
    }
    @Override
    public final ClassFileInfoException nameNotFoundInIndex(final String name) {
        final ClassFileInfoException result = new ClassFileInfoException(String.format(getLoggingLocale(), nameNotFoundInIndex$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToLoadAnnotation(final String annotationClassName) {
        super.log.logf(FQCN, DEBUG, null, unableToLoadAnnotation$str(), annotationClassName);
    }
    private static final String unableToLoadAnnotation = "Unable to load annotation %s";
    protected String unableToLoadAnnotation$str() {
        return unableToLoadAnnotation;
    }
    private static final String cannotLoadClass = "WFLYWELD0051: Cannot load %s";
    protected String cannotLoadClass$str() {
        return cannotLoadClass;
    }
    @Override
    public final ClassFileInfoException cannotLoadClass(final String name, final Throwable throwable) {
        final ClassFileInfoException result = new ClassFileInfoException(String.format(getLoggingLocale(), cannotLoadClass$str(), name), throwable);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void loadingProxiesUsingDeploymentClassLoader(final ModuleIdentifier moduleIdentifier, final String dependencies) {
        super.log.logf(FQCN, WARN, null, loadingProxiesUsingDeploymentClassLoader$str(), moduleIdentifier, dependencies);
    }
    private static final String loadingProxiesUsingDeploymentClassLoader = "WFLYWELD0052: Using deployment classloader to load proxy classes for module %s. Package-private access will not work. To fix this the module should declare dependencies on %s";
    protected String loadingProxiesUsingDeploymentClassLoader$str() {
        return loadingProxiesUsingDeploymentClassLoader;
    }
    private static final String componentInterceptorSupportNotAvailable = "WFLYWELD0053: Component interceptor support not available for: %s";
    protected String componentInterceptorSupportNotAvailable$str() {
        return componentInterceptorSupportNotAvailable;
    }
    @Override
    public final IllegalStateException componentInterceptorSupportNotAvailable(final Object componentClass) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), componentInterceptorSupportNotAvailable$str(), componentClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotLoadAnnotationIndexOfExternalBeanArchive(final Object indexUrl) {
        super.log.logf(FQCN, WARN, null, cannotLoadAnnotationIndexOfExternalBeanArchive$str(), indexUrl);
    }
    private static final String cannotLoadAnnotationIndexOfExternalBeanArchive = "WFLYWELD0054: Could not read provided index of an external bean archive: %s";
    protected String cannotLoadAnnotationIndexOfExternalBeanArchive$str() {
        return cannotLoadAnnotationIndexOfExternalBeanArchive;
    }
    @Override
    public final void cannotIndexClassName(final Object name, final Object bda) {
        super.log.logf(FQCN, WARN, null, cannotIndexClassName$str(), name, bda);
    }
    private static final String cannotIndexClassName = "WFLYWELD0055: Could not index class [%s] from an external bean archive: %s";
    protected String cannotIndexClassName$str() {
        return cannotIndexClassName;
    }
}
