/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.integration.lazy.loading;

import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.appserver.integration.common.clients.WebAppAdminClient;
import org.wso2.appserver.integration.common.utils.ASIntegrationTest;
import org.wso2.appserver.integration.lazy.loading.util.LazyLoadingTestException;
import org.wso2.appserver.integration.lazy.loading.util.TenantStatusBean;
import org.wso2.appserver.integration.lazy.loading.util.WebAppStatusBean;
import org.wso2.carbon.application.mgt.stub.ApplicationAdminExceptionException;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.automation.test.utils.http.client.HttpURLConnectionClient;
import org.wso2.carbon.integration.common.admin.client.ApplicationAdminClient;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

public abstract class LazyLoadingBaseTest
extends ASIntegrationTest {
    protected static final String TENANT_DOMAIN_1_KEY = "tenant1";
    protected static final String TENANT_DOMAIN_2_KEY = "tenant2";
    protected static final String SUPER_TENANT_DOMAIN_KEY = "superTenant";
    protected static final String CARBON_HOME = FrameworkPathUtil.getCarbonHome();
    protected String ARTIFACTS_LOCATION = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AS" + File.separator + "ghost" + File.separator;
    protected static final String CARBON_XML = "carbon.xml";
    protected static final String CARBON_REPOSITORY_LOCATION = FrameworkPathUtil.getCarbonServerConfLocation() + File.separator + "carbon.xml";
    private static final String PRODUCT_GROUP_NAME = "AS";
    private static final String INSTANCE_NAME = "appServerInstance0001";
    private static final String ADMIN_USER_KEY = "admin";
    private static final String TENANT_INFO_SERVICE = "lazy-loading-info";
    private static final String TENANT_INFO_SERVICE_FILE_NAME = "lazy-loading-info.war";
    private static final String IS_TENANT_LOADED_METHOD_URL = "lazy-loading-info/tenant-status";
    private static final String IS_WEB_APP_LOADED_METHOD_URL = "lazy-loading-info/webapp-status";
    private static final String TENANT_IDLE_XPATH = "//listenerExtensions/platformExecutionManager/extentionClasses/*[name()='class']/*[name()='parameter'][@name='-Dtenant.idle.time']/@value";
    private static final String WEB_APP_IDLE_XPATH = "//listenerExtensions/platformExecutionManager/extentionClasses/*[name()='class']/*[name()='parameter'][@name='-Dwebapp.idle.time']/@value";
    private static final long MAX_THRESHOLD_TIME = 120000L;
    private static final long DEPLOYMENT_DELAY_IN_MILLISECONDS = 90000L;
    protected static final int CONCURRENT_THREAD_COUNT = 40;
    private static final Log log = LogFactory.getLog(LazyLoadingBaseTest.class);
    protected static final String ADMIN = "admin";
    private static final String DEFAULT = "default";
    private long webAppIdleTime;
    private long tenantIdleTime;
    protected String superTenantDomain;
    protected String tenantDomain1;
    protected String tenantDomain2;
    protected WebAppAdminClient webAppAdminClient;
    protected ServerConfigurationManager serverManager;
    protected String hostURL;
    protected String artifactsLocation;
    protected ApplicationAdminClient appAdminClient;
    protected String supperTenantWebAppURL;
    protected String carbonArtifactLocation;

    public void init() throws Exception {
        super.init();
        this.supperTenantWebAppURL = this.webAppURL;
        this.hostURL = (String)this.asServer.getInstance().getHosts().get(DEFAULT);
        this.serverManager = new ServerConfigurationManager(this.asServer);
        this.webAppAdminClient = new WebAppAdminClient(this.backendURL, this.sessionCookie);
        this.appAdminClient = new ApplicationAdminClient(this.backendURL, this.sessionCookie);
        this.tenantIdleTime = Long.parseLong(this.asServer.getConfigurationNode(TENANT_IDLE_XPATH).getNodeValue()) * 60L * 1000L;
        this.webAppIdleTime = Long.parseLong(this.asServer.getConfigurationNode(WEB_APP_IDLE_XPATH).getNodeValue()) * 60L * 1000L;
        this.artifactsLocation = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + PRODUCT_GROUP_NAME + File.separator + "ghost" + File.separator;
        String tenantInfoServiceArtifactLocation = this.artifactsLocation + TENANT_INFO_SERVICE_FILE_NAME;
        String carbonArtifactLocation = this.artifactsLocation + CARBON_XML;
        File sourceFile = new File(carbonArtifactLocation);
        File targetFile = new File(CARBON_REPOSITORY_LOCATION);
        this.superTenantDomain = new AutomationContext(PRODUCT_GROUP_NAME, INSTANCE_NAME, SUPER_TENANT_DOMAIN_KEY, "admin").getSuperTenant().getDomain();
        this.tenantDomain1 = new AutomationContext(PRODUCT_GROUP_NAME, INSTANCE_NAME, TENANT_DOMAIN_1_KEY, "admin").getContextTenant().getDomain();
        this.tenantDomain2 = new AutomationContext(PRODUCT_GROUP_NAME, INSTANCE_NAME, TENANT_DOMAIN_2_KEY, "admin").getContextTenant().getDomain();
        this.serverManager.applyConfigurationWithoutRestart(sourceFile, targetFile, true);
        log.info((Object)("carbon.xml replaced with :" + carbonArtifactLocation));
        this.webAppAdminClient.uploadWarFile(tenantInfoServiceArtifactLocation);
        this.serverManager.restartGracefully();
        log.info((Object)"Server Restarted after applying carbon.xml and tenant information utility web application");
    }

    public void init(String domainKey, String userKey) throws Exception {
        super.init(domainKey, userKey);
        this.hostURL = (String)this.asServer.getInstance().getHosts().get(DEFAULT);
        try {
            this.appAdminClient = new ApplicationAdminClient(this.backendURL, this.sessionCookie);
            this.webAppAdminClient = new WebAppAdminClient(this.backendURL, this.sessionCookie);
        }
        catch (AxisFault axisFault) {
            String customErrorMessage = "AxisFault Exception has thrown. backend URL:" + this.backendURL + " Session Cookie: " + this.sessionCookie;
            log.error((Object)customErrorMessage, (Throwable)axisFault);
            throw new LazyLoadingTestException(customErrorMessage, axisFault);
        }
    }

    protected TenantStatusBean getTenantStatus(String tenantDomain) throws LazyLoadingTestException {
        TenantStatusBean tenantStatus;
        String requestUrl = this.supperTenantWebAppURL + "/" + IS_TENANT_LOADED_METHOD_URL + "/" + tenantDomain;
        try {
            HttpResponse response = HttpURLConnectionClient.sendGetRequest((String)requestUrl, null);
            JSONObject tenantStatusJSON = new JSONObject(response.getData());
            tenantStatus = new TenantStatusBean(tenantStatusJSON.getJSONObject("TenantStatus").getBoolean("tenantContextLoaded"));
        }
        catch (IOException ioException) {
            String customErrorMessage = "IOException when sending the Get request to:" + requestUrl;
            log.error((Object)customErrorMessage, (Throwable)ioException);
            throw new LazyLoadingTestException(customErrorMessage, ioException);
        }
        catch (JSONException jsonException) {
            String customErrorMessage = "JSONException when retrieving the values from json object TenantStatus" + requestUrl;
            log.error((Object)customErrorMessage, (Throwable)jsonException);
            throw new LazyLoadingTestException(customErrorMessage, jsonException);
        }
        return tenantStatus;
    }

    protected WebAppStatusBean getWebAppStatus(String tenantDomain, String webAppName) throws LazyLoadingTestException {
        WebAppStatusBean webAppStatus;
        String requestUrl = this.supperTenantWebAppURL + "/" + IS_WEB_APP_LOADED_METHOD_URL + "/" + tenantDomain + "/" + webAppName;
        try {
            HttpResponse response = HttpURLConnectionClient.sendGetRequest((String)requestUrl, null);
            JSONObject webAppStatusJSON = new JSONObject(response.getData()).getJSONObject("WebAppStatus");
            boolean isTenantLoaded = webAppStatusJSON.getJSONObject("tenantStatus").getBoolean("tenantContextLoaded");
            boolean isWebAppStarted = webAppStatusJSON.getBoolean("webAppStarted");
            boolean isWebAppGhost = webAppStatusJSON.getBoolean("webAppGhost");
            webAppStatus = new WebAppStatusBean(new TenantStatusBean(isTenantLoaded), isWebAppStarted, isWebAppGhost);
        }
        catch (IOException ioException) {
            String customErrorMessage = "IOException when sending the Get request to:" + requestUrl;
            log.error((Object)customErrorMessage, (Throwable)ioException);
            throw new LazyLoadingTestException(customErrorMessage, ioException);
        }
        catch (JSONException jsonException) {
            String customErrorMessage = "JSONException when retrieving the values from json object WebAppStatus" + requestUrl;
            log.error((Object)customErrorMessage, (Throwable)jsonException);
            throw new LazyLoadingTestException(customErrorMessage, jsonException);
        }
        return webAppStatus;
    }

    protected boolean isJaggeryAppDeployed(String appName) throws LazyLoadingTestException {
        long time;
        boolean isWebAppDeployed = false;
        boolean doLoop = true;
        log.info((Object)("waiting for " + appName + " deployment. Max wait time :" + 90000L + " milliseconds"));
        long startTime = System.currentTimeMillis();
        while ((time = System.currentTimeMillis() - startTime) < 90000L && doLoop) {
            String customErrorMessage;
            List faultyWebAppList;
            List webAppList;
            try {
                webAppList = this.webAppAdminClient.getWebApplist(appName);
                faultyWebAppList = this.webAppAdminClient.getFaultyWebAppList(appName);
            }
            catch (RemoteException remoteException) {
                customErrorMessage = "remoteException Exception when calling methods in WebAppAdminClient";
                log.error((Object)customErrorMessage, (Throwable)remoteException);
                throw new LazyLoadingTestException(customErrorMessage, remoteException);
            }
            for (String faultWebAppName : faultyWebAppList) {
                if (!faultWebAppName.equalsIgnoreCase(appName)) continue;
                isWebAppDeployed = false;
                log.info((Object)(appName + "- Jaggery Application is faulty"));
                doLoop = false;
                break;
            }
            for (String webAppName : webAppList) {
                if (!webAppName.equalsIgnoreCase(appName)) continue;
                isWebAppDeployed = true;
                log.info((Object)(appName + " Jaggery Application deployed in " + time + " millis"));
                doLoop = false;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                customErrorMessage = "InterruptedException occurs when sleeping 500 milliseconds and while waiting for Jaggery Application to get deployed ";
                log.warn((Object)customErrorMessage, (Throwable)interruptedException);
            }
        }
        return isWebAppDeployed;
    }

    protected boolean isCarbonAppListed(String appName) throws LazyLoadingTestException {
        long time;
        boolean isAppListed = false;
        log.info((Object)("waiting for " + appName + " Carbon application to list. Max wait time :" + 90000L + " milliseconds"));
        long startTime = System.currentTimeMillis();
        while ((time = System.currentTimeMillis() - startTime) < 90000L) {
            String customErrorMessage;
            String[] appList;
            try {
                appList = this.appAdminClient.listAllApplications();
            }
            catch (ApplicationAdminExceptionException applicationAdminExceptionException) {
                customErrorMessage = "ApplicationAdminExceptionException Exception when when calling listAllApplications() methods in WebAppAdminClient";
                log.error((Object)customErrorMessage, (Throwable)applicationAdminExceptionException);
                throw new LazyLoadingTestException(customErrorMessage, applicationAdminExceptionException);
            }
            catch (RemoteException remoteException) {
                customErrorMessage = "RemoteException Exception when calling listAllApplications() methods in WebAppAdminClient";
                log.error((Object)customErrorMessage, (Throwable)remoteException);
                throw new LazyLoadingTestException(customErrorMessage, remoteException);
            }
            if (Arrays.asList(appList).contains(appName)) {
                isAppListed = true;
                log.info((Object)(appName + " Carbon Application is listed in" + time + " millis"));
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                customErrorMessage = "InterruptedException occurs when sleeping 500 milliseconds and while waiting for Carbon Application to  listed in ApplicationAdminClient.";
                log.warn((Object)customErrorMessage, (Throwable)interruptedException);
            }
        }
        return isAppListed;
    }

    protected boolean checkTenantAutoUnloading(String tenantDomain) throws LazyLoadingTestException {
        boolean isTenantUnloaded = false;
        long totalSleepTime = 0L;
        log.info((Object)("Sleeping  for " + this.tenantIdleTime + " milliseconds (Tenant idle time)."));
        try {
            Thread.sleep(this.tenantIdleTime);
        }
        catch (InterruptedException interruptedException) {
            String customErrorMessage = "InterruptedException occurs when sleeping for tenantIdleTime" + interruptedException.getMessage();
            log.warn((Object)customErrorMessage, (Throwable)interruptedException);
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 120000L) {
            isTenantUnloaded = !this.getTenantStatus(tenantDomain).isTenantContextLoaded();
            totalSleepTime = System.currentTimeMillis() - startTime + this.tenantIdleTime;
            if (isTenantUnloaded) {
                log.info((Object)("Tenant " + tenantDomain + " is unloaded in " + totalSleepTime + "milliseconds. Tenant idle " + "time is :" + this.tenantIdleTime + "milliseconds."));
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                String customErrorMessage = "InterruptedException occurs when sleeping 1000 milliseconds and while waiting for tenant to auto unload" + interruptedException.getMessage();
                log.warn((Object)customErrorMessage, (Throwable)interruptedException);
            }
        }
        if (!isTenantUnloaded) {
            log.info((Object)("Tenant " + tenantDomain + " is not unloaded in " + totalSleepTime + "milliseconds. Tenant idle " + "time is :" + this.tenantIdleTime + "milliseconds."));
        }
        return isTenantUnloaded;
    }

    protected boolean checkWebAppAutoUnloadingToGhostState(String tenantDomain, String webAppName) throws LazyLoadingTestException {
        String customErrorMessage;
        boolean isTenantInGhostState = false;
        long totalSleepTime = 0L;
        log.info((Object)("Sleeping  for " + this.webAppIdleTime + " milliseconds (WebApp idle time)."));
        try {
            Thread.sleep(this.webAppIdleTime);
        }
        catch (InterruptedException interruptedException) {
            String customErrorMessage2 = "InterruptedException occurs when sleeping for webAppIdleTime";
            log.warn((Object)customErrorMessage2);
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 120000L) {
            isTenantInGhostState = this.getWebAppStatus(tenantDomain, webAppName).isWebAppGhost();
            totalSleepTime = System.currentTimeMillis() - startTime + this.webAppIdleTime;
            if (isTenantInGhostState) {
                log.info((Object)("Web App : " + webAppName + "in Tenant " + tenantDomain + " is unloaded in " + totalSleepTime + "milliseconds. Web App idle time is :" + this.webAppIdleTime + "milliseconds."));
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                customErrorMessage = "InterruptedException occurs when sleeping 1000 milliseconds and while waiting for Web-app to auto unload";
                log.warn((Object)customErrorMessage, (Throwable)interruptedException);
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            customErrorMessage = "InterruptedException occurs when sleeping 1000 milliseconds.";
            log.warn((Object)customErrorMessage, (Throwable)interruptedException);
        }
        if (!isTenantInGhostState) {
            log.info((Object)("Web App : " + webAppName + "in Tenant " + tenantDomain + " is not unloaded in " + totalSleepTime + "milliseconds. Web App idle time is :" + this.webAppIdleTime + "milliseconds."));
        }
        return isTenantInGhostState;
    }
}

