/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.appserver.integration.lazy.loading.tenants;

import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.appserver.integration.common.clients.WebAppAdminClient;
import org.wso2.appserver.integration.lazy.loading.LazyLoadingBaseTest;
import org.wso2.appserver.integration.lazy.loading.util.LazyLoadingTestException;

public class TenantLoadUnloadTestCase
extends LazyLoadingBaseTest {
    private static final Log log = LogFactory.getLog(TenantLoadUnloadTestCase.class);

    @Override
    @BeforeClass(alwaysRun=true)
    public void init() throws Exception {
        super.init();
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Login using  one tenant user. Before loginTenantUser  contexts of both users should not be loaded. After loginTenantUser  only the logged user context should get load.", alwaysRun=true)
    public void testTenantContextLoadInLogin() throws Exception {
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)"Tenant context is loaded before any action related to that tenant");
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain2).isTenantContextLoaded(), (String)"Tenant context is loaded before any action related to that tenant");
        log.info((Object)("Testing Tenant context loading  for :" + this.tenantDomain1));
        this.init("tenant1", "admin");
        try {
            this.webAppAdminClient = new WebAppAdminClient(this.backendURL, this.sessionCookie);
        }
        catch (AxisFault axisFault) {
            String customErrorMessage = "AxisFault Exception when  creating  WebAppAdminClient object, Backend URL:" + this.backendURL + " Session Cookie: " + this.sessionCookie + "\n" + axisFault.getMessage();
            log.error((Object)customErrorMessage, (Throwable)axisFault);
            throw new LazyLoadingTestException(customErrorMessage, axisFault);
        }
        Assert.assertTrue((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)"Tenant context is  not loaded after tenant loginTenantUser");
        Assert.assertFalse((boolean)this.getTenantStatus(this.tenantDomain2).isTenantContextLoaded(), (String)"Tenant context is loaded without loginTenantUser");
    }

    @Test(groups={"wso2.as.lazy.loading"}, description="Wait until the tenant idle time passing and  check for the tenant context unloading.", dependsOnMethods={"testTenantContextLoadInLogin"})
    public void testTenantContextUnLoadInTenantIdle() throws LazyLoadingTestException {
        Assert.assertTrue((boolean)this.getTenantStatus(this.tenantDomain1).isTenantContextLoaded(), (String)"Tenant context is  not loaded after tenant loginTenantUser");
        log.info((Object)("Waiting for Tenant context to un-load :" + this.tenantDomain1));
        Assert.assertTrue((boolean)this.checkTenantAutoUnloading(this.tenantDomain1), (String)"Tenant context is  not unloaded after idle time");
    }
}

