/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.relay.module.policy;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.PolicySubject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.All;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.xml.XmlPrimtiveAssertion;
import org.wso2.carbon.relay.RelayConstants;
import org.wso2.carbon.relay.module.RelayConfiguration;

public class PolicyProcessor {
    private static Log log = LogFactory.getLog(PolicyProcessor.class);

    public static RelayConfiguration processPolicy(PolicySubject policySubject) throws AxisFault {
        if (policySubject.getAttachedPolicyComponents().size() != 0) {
            RelayConfiguration relayConfig = new RelayConfiguration();
            Collection topLevelAssertionList = policySubject.getAttachedPolicyComponents();
            PolicyProcessor.handlePolicyComponents(relayConfig, topLevelAssertionList);
            return relayConfig;
        }
        return null;
    }

    private static boolean handlePolicyComponents(RelayConfiguration relayConfiguration, Collection topLevelAssertionList) throws AxisFault {
        for (Object topLevelAssertionObject : topLevelAssertionList) {
            if (topLevelAssertionObject instanceof Policy) {
                Policy policy = (Policy)topLevelAssertionObject;
                List policyComponents = policy.getPolicyComponents();
                PolicyProcessor.handlePolicyComponents(relayConfiguration, policyComponents);
                continue;
            }
            if (topLevelAssertionObject instanceof XmlPrimtiveAssertion) {
                XmlPrimtiveAssertion tlxa = (XmlPrimtiveAssertion)topLevelAssertionObject;
                QName qName = tlxa.getName();
                if (!qName.equals(RelayConstants.RELAY_ASSERSION_QNAME)) {
                    return false;
                }
                Policy rpc = PolicyEngine.getPolicy((OMElement)tlxa.getValue());
                for (Object configAssertion : rpc.getPolicyComponents()) {
                    if (!(configAssertion instanceof Policy)) {
                        return false;
                    }
                    Policy cachingPolicy = (Policy)configAssertion;
                    List childAssertionsList = cachingPolicy.getPolicyComponents();
                    for (Object configData : childAssertionsList) {
                        if (!(configData instanceof All)) {
                            PolicyProcessor.handleException("Unexpected relay policy, \"wsp:All\" expected");
                        }
                        All all = (All)configData;
                        List configDataList = all.getPolicyComponents();
                        for (Object configDtaObject : configDataList) {
                            XmlPrimtiveAssertion assertion;
                            if (!(configDtaObject instanceof XmlPrimtiveAssertion)) {
                                PolicyProcessor.handleException("Unexpected relay policy assertion for the relay module");
                            }
                            if ((assertion = (XmlPrimtiveAssertion)configDtaObject).getName().equals(RelayConstants.INCLUDE_HIDDEN_SERVICES_QNAME)) {
                                String value = assertion.getValue().getText();
                                relayConfiguration.setIncludeHiddenServices(Boolean.parseBoolean(value));
                            }
                            if (assertion.getName().equals(RelayConstants.BUILDERS_QNAME) && assertion.getValue() != null) {
                                PolicyProcessor.processBuilders(assertion.getValue(), relayConfiguration);
                            }
                            if (!assertion.getName().equals(RelayConstants.SERVICES_QNAME) || assertion.getValue() == null) continue;
                            PolicyProcessor.processServices(assertion.getValue(), relayConfiguration);
                        }
                    }
                }
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean processBuilders(OMElement builders, RelayConfiguration configuration) {
        Iterator itr = builders.getChildrenWithName(RelayConstants.MESSAGE_BUILDER_QNAME);
        while (itr.hasNext()) {
            OMElement e = (OMElement)itr.next();
            String contentType = e.getAttributeValue(RelayConstants.CONTENT_TYPE_QNAME);
            if (contentType == null) {
                return false;
            }
            String className = e.getAttributeValue(RelayConstants.CLASS_NAME_QNAME);
            if (className == null) {
                return false;
            }
            configuration.addBuilder(contentType, className);
            String formatterClass = e.getAttributeValue(RelayConstants.FORMATTER_CLASS_NAME_QNAME);
            if (formatterClass == null) continue;
            configuration.addFormatter(contentType, formatterClass);
        }
        return true;
    }

    private static boolean processServices(OMElement services, RelayConfiguration configuration) {
        Iterator itr = services.getChildrenWithName(RelayConstants.SERVICE_QNAME);
        while (itr.hasNext()) {
            OMElement e = (OMElement)itr.next();
            configuration.addService(e.getText());
        }
        return true;
    }

    public static void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }
}

