/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rest.api.ui.client;

import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rest.api.stub.RestApiAdminAPIException;
import org.wso2.carbon.rest.api.stub.RestApiAdminStub;
import org.wso2.carbon.rest.api.stub.types.carbon.APIData;
import org.wso2.carbon.rest.api.stub.types.carbon.ResourceData;

public class RestApiAdminClient {
    private static final Log log = LogFactory.getLog(RestApiAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.rest.api.ui.i18n.Resources";
    private static String CONF_LOCATION = "conf.location";
    private ResourceBundle bundle;
    private RestApiAdminStub stub;

    public RestApiAdminClient(ConfigurationContext configCtx, String backendServerURL, String cookie, Locale locale) throws AxisFault {
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        String serviceURL = backendServerURL + "RestApiAdmin";
        this.stub = new RestApiAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setTimeOutInMilliSeconds(900000L);
        options.setProperty("SO_TIMEOUT", (Object)900000);
        options.setProperty("CONNECTION_TIMEOUT", (Object)900000);
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public String[] getApiNames() throws AxisFault {
        try {
            String[] result = this.stub.getApiNames();
            if (result == null || result.length == 0 || result[0] == null) {
                return null;
            }
            return this.stub.getApiNames();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("unable.to.get.declared.apis"), e);
            return null;
        }
    }

    public APIData getApiByName(String apiName) throws AxisFault {
        try {
            return this.stub.getApiByName(apiName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("failed.to.find.api"), e);
            return null;
        }
    }

    public APIData[] getAPIsForListing(int pageNumber, int itemsPerPage) throws AxisFault {
        try {
            return this.stub.getAPIsForListing(pageNumber, itemsPerPage);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("failed.to.retrieve.apis"), e);
            return null;
        }
    }

    private boolean isApiSatisfySearchString(String searchString, String apiName) {
        if (searchString != null) {
            String regex = searchString.toLowerCase().replace("..?", ".?").replace("..*", ".*").replaceAll("\\?", ".?").replaceAll("\\*", ".*?");
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(apiName.toLowerCase());
            return regex.trim().length() == 0 || matcher.find();
        }
        return false;
    }

    public APIData[] getAPIsForSearchListing(int pageNumber, int itemsPerPage, String searchText) throws AxisFault {
        ArrayList<APIData> apis = new ArrayList<APIData>();
        try {
            APIData[] tempAPI = this.stub.getAPIsForListing(pageNumber, this.stub.getAPICount());
            if (tempAPI == null || tempAPI.length == 0 || tempAPI[0] == null) {
                return null;
            }
            for (APIData info : tempAPI) {
                if (!this.isApiSatisfySearchString(searchText, info.getName())) continue;
                APIData api = new APIData();
                api.setName(info.getName());
                api.setContext(info.getContext());
                api.setFileName(info.getFileName());
                api.setHost(info.getHost());
                api.setPort(info.getPort());
                api.setResources(info.getResources());
                api.setStatisticsEnable(info.getStatisticsEnable());
                api.setTracingEnable(info.getTracingEnable());
                if (info.isArtifactContainerNameSpecified()) {
                    api.setArtifactContainerName(info.getArtifactContainerName());
                }
                apis.add(api);
            }
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("failed.to.retrieve.apis"), e);
        }
        if (apis.size() > 0) {
            return apis.toArray(new APIData[apis.size()]);
        }
        return null;
    }

    public int getAPICount() throws AxisFault {
        try {
            return this.stub.getAPICount();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("failed.to.get.api.count"), e);
            return 0;
        }
    }

    public void deleteApi(String apiName) throws AxisFault {
        try {
            this.stub.deleteApi(apiName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.delete.api"), e);
        }
    }

    public void addApi(APIData apiData) throws AxisFault {
        try {
            this.stub.addApi(apiData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.add.api"), e);
        }
    }

    public void updateApi(APIData apiData) throws AxisFault {
        try {
            String apiName = apiData.getName();
            if (apiData.getVersion() != null && !apiData.getVersion().isEmpty()) {
                apiName = apiName + ":v" + apiData.getVersion();
            }
            this.stub.updateApi(apiName, apiData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.update.api"), e);
        }
    }

    public String[] getDefinedSequences() throws AxisFault {
        try {
            Object[] sequences = this.stub.getSequences();
            if (sequences != null && sequences.length != 0) {
                Arrays.sort(sequences);
            }
            return sequences;
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.get.sequences"), e);
            return null;
        }
    }

    public String getApiSource(APIData apiData) throws AxisFault {
        try {
            return this.stub.getApiSource(apiData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.get.api.source"), e);
            return null;
        }
    }

    public String getResourceSource(ResourceData resourceData) throws AxisFault {
        try {
            return this.stub.getResourceSource(resourceData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.get.resource.source"), e);
            return null;
        }
    }

    public void addApiFromString(String apiData) throws AxisFault {
        try {
            this.stub.addApiFromString(apiData);
        }
        catch (AxisFault af) {
            this.handleException(af.getMessage(), (Exception)((Object)af));
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.add.api"), e);
        }
    }

    public void updateApiFromString(String apiName, String apiData) throws AxisFault {
        try {
            this.stub.updateApiFromString(apiName, apiData);
        }
        catch (AxisFault af) {
            this.handleException(af.getMessage(), (Exception)((Object)af));
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.update.api"), e);
        }
    }

    private String ReadWSDLPrefix() throws AxisFault {
        try {
            OMNode value;
            String server;
            FileInputStream in;
            OMElement results;
            AXIOMXPath xpathExpression;
            List nodeList;
            String confPath = System.getProperty(CONF_LOCATION);
            if (confPath == null) {
                confPath = Paths.get("repository", "conf").toString();
            }
            if (!(nodeList = (xpathExpression = new AXIOMXPath("/axisconfig/transportReceiver/parameter[@name='WSDLEPRPrefix']")).selectNodes((Object)(results = OMXMLBuilderFactory.createOMBuilder((InputStream)(in = new FileInputStream(Paths.get(confPath, "axis2", "axis2.xml").toString()))).getDocumentElement()))).isEmpty() && ((server = ((OMElementImpl)(value = (OMNode)nodeList.get(0))).getText()).contains("http") || server.contains("https"))) {
                return server;
            }
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("failed.to.read.wsdl.prefix"), e);
        }
        return null;
    }

    public String getServerContext() throws AxisFault {
        try {
            String returnValue = this.ReadWSDLPrefix();
            if (returnValue != null && !returnValue.isEmpty()) {
                return returnValue;
            }
            return this.stub.getServerContext();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("failed.to.get.servercontext"), e);
            return null;
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }

    public void deleteSelectedApi(String[] apiNames) throws AxisFault {
        try {
            this.stub.deleteSelectedApi(apiNames);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.selected.delete.api"), e);
        }
    }

    public void deleteAllApi() throws AxisFault {
        try {
            this.stub.deleteAllApi();
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.All.delete.api"), e);
        }
    }

    public String enableStatistics(String apiName) throws AxisFault {
        try {
            this.stub.enableStatistics(apiName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.enable.api.statistics"), e);
        }
        return null;
    }

    public String disableStatistics(String apiName) throws AxisFault {
        try {
            this.stub.disableStatistics(apiName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.disable.api.statistics"), e);
        }
        return null;
    }

    public String enableTracing(String apiName) throws AxisFault {
        try {
            this.stub.enableTracing(apiName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.enable.api.statistics"), e);
        }
        return null;
    }

    public String disableTracing(String apiName) throws AxisFault {
        try {
            this.stub.disableTracing(apiName);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.disable.api.statistics"), e);
        }
        return null;
    }

    public String updateSwaggerDocument(String apiName, String swaggerDefinition, int tenantId) throws AxisFault {
        try {
            this.stub.updateSwaggerDocument(apiName, swaggerDefinition, tenantId);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.update.swagger.document"), e);
        }
        return null;
    }

    public String addSwaggerDocument(String apiName, String swaggerDefinition, int tenantId) throws AxisFault {
        try {
            this.stub.addSwaggerDocument(apiName, swaggerDefinition, tenantId);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.add.swagger.document"), e);
        }
        return null;
    }

    public String getSwaggerDocument(String apiName, int tenantId) throws AxisFault {
        String swaggerJsonString = null;
        try {
            swaggerJsonString = this.stub.getSwaggerDocument(apiName, tenantId);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("could.not.get.swagger.document"), e);
        }
        return swaggerJsonString;
    }

    public String generateAPIFromSwagger(String swaggerJsonString) throws AxisFault {
        String generatedAPI = null;
        try {
            generatedAPI = this.stub.generateAPIFromSwagger(swaggerJsonString);
        }
        catch (RemoteException | RestApiAdminAPIException e) {
            this.handleException(this.bundle.getString("could.not.generate.api"), (Exception)e);
        }
        return generatedAPI;
    }

    public String generateUpdatedAPIFromSwagger(String swaggerJsonString, String existingApiName) throws AxisFault {
        String generatedAPI = null;
        try {
            generatedAPI = this.stub.generateUpdatedAPIFromSwagger(swaggerJsonString, existingApiName);
        }
        catch (RemoteException | RestApiAdminAPIException e) {
            this.handleException(this.bundle.getString("could.not.generate.api"), (Exception)e);
        }
        return generatedAPI;
    }
}

