/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rest.api.ui.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.wso2.carbon.rest.api.stub.RestApiAdminStub;
import org.wso2.carbon.rest.api.ui.client.AuthAdminServiceClient;

public class TestClient {
    private static String resourceTemplate = "<resource xmlns=\"http://ws.apache.org/ns/synapse\" uri-template=\"[1]\" methods=\"[2]\" >\n\t\t    <inSequence>\n\t\t    \t<send>\n\t\t\t\t<endpoint name=\"Delecious\" xmlns=\"http://ws.apache.org/ns/synapse\">\n\t\t\t\t\t<address uri=\"[3]\"  />\n\t\t\t\t</endpoint>\n\t\t\t</send>\t\n\t\t    </inSequence>\n\t\t    <outSequence>\n\t\t    \t<send />\n\t\t    </outSequence>\n\t\t</resource>\t";
    private static String apiTemplate = "<api xmlns=\"http://ws.apache.org/ns/synapse\"  name=\"[1]\" context=\"[2]\">\t</api>";
    private static String handlersTemplate = "<handlers xmlns=\"http://ws.apache.org/ns/synapse\"> </handlers>";
    private static String handlerTemplate = "<handler xmlns=\"http://ws.apache.org/ns/synapse\" class=\"[1]\" />";
    private Map apiMappings;
    private List<Map> resourceMappings;
    private List<Map> handlerMappings;
    private RestApiAdminStub stub;
    public static final String KEY_FOR_API_NAME = "key_for_api_name";
    public static final String KEY_FOR_API_CONTEXT = "key_for_api_context";
    public static final String KEY_FOR_RESOURCE_URI_TEMPLATE = "key_for_resource_uri_template";
    public static final String KEY_FOR_RESOURCE_METHODS = "key_for_resource_methods";
    public static final String KEY_FOR_RESOURCE_URI = "key_for_resource_uri";
    public static final String KEY_FOR_HANDLER = "key_for_handler_class";

    public TestClient(Map apiMappings, List<Map> resourceMappings, List<Map> handlerMappings, String cookie) throws AxisFault {
        this.apiMappings = apiMappings;
        this.resourceMappings = resourceMappings;
        this.handlerMappings = handlerMappings;
        this.initStub(cookie);
    }

    private void initStub(String cookie) throws AxisFault {
        String serviceURL = "https://localhost:9443/services/RestApiAdmin";
        this.stub = new RestApiAdminStub(null, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options options = client.getOptions();
        options.setTimeOutInMilliSeconds(900000L);
        options.setProperty("SO_TIMEOUT", (Object)900000);
        options.setProperty("CONNECTION_TIMEOUT", (Object)900000);
        options.setManageSession(true);
        options.setProperty("Cookie", (Object)cookie);
    }

    public void addApi() throws AxisFault {
        try {
            String apiConfig = this.getConfigStringForTemplate();
            System.out.println(apiConfig);
            this.stub.addApiFromString(apiConfig);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getConfigStringForTemplate() {
        String configAPI = this.constructAPIConfig();
        OMElement configAPIOM = TestClient.createOMElementFrom(configAPI);
        assert (configAPIOM != null);
        List<String> configResources = this.constructResourceConfig();
        for (String configResource : configResources) {
            OMElement configResourceOM = TestClient.createOMElementFrom(configResource);
            if (configResourceOM == null) continue;
            configAPIOM.addChild((OMNode)configResourceOM);
        }
        List<String> handlerConfigs = this.constructHandlerConfig();
        OMElement hadlersConfigOM = TestClient.createOMElementFrom(handlersTemplate);
        for (String handlerConfig : handlerConfigs) {
            OMElement configSingleHandlerOM = TestClient.createOMElementFrom(handlerConfig);
            if (configSingleHandlerOM == null) continue;
            hadlersConfigOM.addChild((OMNode)configSingleHandlerOM);
        }
        configAPIOM.addChild((OMNode)hadlersConfigOM);
        return configAPIOM.toString();
    }

    private String constructAPIConfig() {
        StringBuffer apiTempl = new StringBuffer(apiTemplate);
        if (this.apiMappings.get(KEY_FOR_API_NAME) != null && this.apiMappings.get(KEY_FOR_API_CONTEXT) != null) {
            String apiConf = apiTempl.toString().replaceAll("\\[1\\]", (String)this.apiMappings.get(KEY_FOR_API_NAME)).replaceAll("\\[2\\]", (String)this.apiMappings.get(KEY_FOR_API_CONTEXT));
            return apiConf;
        }
        return null;
    }

    private List<String> constructHandlerConfig() {
        Iterator<Map> handlerMaps = this.handlerMappings.iterator();
        ArrayList<String> handlerListStr = new ArrayList<String>();
        while (handlerMaps.hasNext()) {
            Map singleHandler = handlerMaps.next();
            StringBuffer handlerTempl = new StringBuffer(handlerTemplate);
            if (singleHandler == null || singleHandler.get(KEY_FOR_HANDLER) == null) continue;
            String replacedStr = handlerTempl.toString().replaceAll("\\[1\\]", (String)singleHandler.get(KEY_FOR_HANDLER));
            handlerListStr.add(replacedStr);
        }
        return handlerListStr;
    }

    private List<String> constructResourceConfig() {
        Iterator<Map> resourceMaps = this.resourceMappings.iterator();
        ArrayList<String> resListStr = new ArrayList<String>();
        while (resourceMaps.hasNext()) {
            Map singleResMap = resourceMaps.next();
            StringBuffer resTempl = new StringBuffer(resourceTemplate);
            if (singleResMap == null || singleResMap.get(KEY_FOR_RESOURCE_METHODS) == null || singleResMap.get(KEY_FOR_RESOURCE_URI_TEMPLATE) == null || singleResMap.get(KEY_FOR_RESOURCE_URI) == null) continue;
            String replacedStr = resTempl.toString().replaceAll("\\[1\\]", (String)singleResMap.get(KEY_FOR_RESOURCE_URI_TEMPLATE)).replaceAll("\\[2\\]", (String)singleResMap.get(KEY_FOR_RESOURCE_METHODS)).replaceAll("\\[3\\]", (String)singleResMap.get(KEY_FOR_RESOURCE_URI));
            resListStr.add(replacedStr);
        }
        return resListStr;
    }

    public static OMElement createOMElementFrom(String omString) {
        try {
            return AXIOMUtil.stringToOM((String)omString);
        }
        catch (XMLStreamException xMLStreamException) {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> testAPIMappings = new HashMap<String, String>();
        testAPIMappings.put(KEY_FOR_API_NAME, "DelciousAPI3");
        testAPIMappings.put(KEY_FOR_API_CONTEXT, "/v3");
        HashMap<String, String> testResourceMappings_1 = new HashMap<String, String>();
        testResourceMappings_1.put(KEY_FOR_RESOURCE_URI_TEMPLATE, "/tags/get");
        testResourceMappings_1.put(KEY_FOR_RESOURCE_METHODS, "GET");
        testResourceMappings_1.put(KEY_FOR_RESOURCE_URI, "https://api.del.icio.us");
        HashMap<String, String> testResourceMappings_2 = new HashMap<String, String>();
        testResourceMappings_2.put(KEY_FOR_RESOURCE_URI_TEMPLATE, "/posts/get");
        testResourceMappings_2.put(KEY_FOR_RESOURCE_METHODS, "GET");
        testResourceMappings_2.put(KEY_FOR_RESOURCE_URI, "https://api.del.icio.us");
        HashMap<String, String> testResourceMappings_3 = new HashMap<String, String>();
        testResourceMappings_3.put(KEY_FOR_RESOURCE_URI_TEMPLATE, "/posts/delete?url={posturl}");
        testResourceMappings_3.put(KEY_FOR_RESOURCE_METHODS, "DELETE");
        testResourceMappings_3.put(KEY_FOR_RESOURCE_URI, "https://api.del.icio.us");
        HashMap<String, String> testResourceMappings_4 = new HashMap<String, String>();
        testResourceMappings_4.put(KEY_FOR_RESOURCE_URI_TEMPLATE, "/posts/add?url={posturl};description={desc}");
        testResourceMappings_4.put(KEY_FOR_RESOURCE_METHODS, "POST");
        testResourceMappings_4.put(KEY_FOR_RESOURCE_URI, "https://api.del.icio.us");
        ArrayList<Map> resourceMappings = new ArrayList<Map>();
        resourceMappings.add(testResourceMappings_1);
        resourceMappings.add(testResourceMappings_2);
        resourceMappings.add(testResourceMappings_3);
        resourceMappings.add(testResourceMappings_4);
        HashMap testHandlerMappings_1 = new HashMap();
        ArrayList<Map> handlerMappings = new ArrayList<Map>();
        handlerMappings.add(testHandlerMappings_1);
        String adminCookie = null;
        new AuthAdminServiceClient();
        adminCookie = AuthAdminServiceClient.login("localhost", "admin", "admin");
        if (adminCookie == null) {
            throw new RuntimeException("could not login to the back-end server.... /n  aborting...");
        }
        System.out.println("logged in to the back-end server successfully....");
        TestClient restAPIClient = new TestClient(testAPIMappings, resourceMappings, handlerMappings, adminCookie);
        restAPIClient.addApi();
    }
}

