/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rest.api.ui.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.wso2.carbon.rest.api.stub.types.carbon.APIData;
import org.wso2.carbon.rest.api.stub.types.carbon.ResourceData;
import org.wso2.carbon.utils.xml.XMLPrettyPrinter;

public class ApiEditorHelper {
    private static String PROTOCOL_HTTP = "http";
    private static String PROTOCOL_HTTPS = "https";

    public static String parseStringToPrettyfiedString(String ugly) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ugly.getBytes());
        XMLPrettyPrinter printer = new XMLPrettyPrinter((InputStream)byteArrayInputStream);
        return printer.xmlFormat();
    }

    public static APIData convertStringToAPIData(String xml) throws XMLStreamException {
        Iterator childIterator;
        OMAttribute versionType;
        OMAttribute port;
        OMAttribute host;
        OMAttribute context;
        APIData apiData = new APIData();
        OMElement apiOM = AXIOMUtil.stringToOM((String)xml);
        OMAttribute name = apiOM.getAttribute(new QName("name"));
        if (name != null) {
            apiData.setName(name.getAttributeValue());
        }
        if ((context = apiOM.getAttribute(new QName("context"))) != null) {
            apiData.setContext(context.getAttributeValue());
        }
        if ((host = apiOM.getAttribute(new QName("hostname"))) != null) {
            apiData.setHost(host.getAttributeValue());
        }
        if ((port = apiOM.getAttribute(new QName("port"))) != null) {
            apiData.setPort(Integer.parseInt(port.getAttributeValue()));
        } else {
            apiData.setPort(-1);
        }
        OMAttribute version = apiOM.getAttribute(new QName("version"));
        if (version != null) {
            apiData.setVersion(version.getAttributeValue());
        }
        if ((versionType = apiOM.getAttribute(new QName("version-type"))) != null) {
            apiData.setVersionType(versionType.getAttributeValue());
        }
        if ((childIterator = apiOM.getChildElements()) == null) {
            return apiData;
        }
        ArrayList<ResourceData> resources = new ArrayList<ResourceData>();
        while (childIterator.hasNext()) {
            OMElement resourceOM = (OMElement)childIterator.next();
            ResourceData resource = new ResourceData();
            ApiEditorHelper.convertResource(resourceOM, resource);
            resources.add(resource);
        }
        ResourceData[] resourceArray = new ResourceData[resources.size()];
        apiData.setResources(resources.toArray(resourceArray));
        return apiData;
    }

    public static ResourceData convertStringToResourceData(String xml) throws XMLStreamException {
        ResourceData resourceData = new ResourceData();
        OMElement resourceOM = AXIOMUtil.stringToOM((String)xml);
        ApiEditorHelper.convertResource(resourceOM, resourceData);
        return resourceData;
    }

    private static void convertResource(OMElement resourceOM, ResourceData resourceData) throws XMLStreamException {
        OMAttribute faultSequence;
        OMAttribute outSequence;
        OMAttribute inSequence;
        OMAttribute userAgent;
        OMAttribute protocol;
        OMAttribute contentType;
        OMAttribute urlMapping;
        OMAttribute uriTemplate;
        OMAttribute methods = resourceOM.getAttribute(new QName("methods"));
        if (methods != null) {
            resourceData.setMethods(methods.getAttributeValue().split(" "));
        }
        if ((uriTemplate = resourceOM.getAttribute(new QName("uri-template"))) != null) {
            resourceData.setUriTemplate(uriTemplate.getAttributeValue());
        }
        if ((urlMapping = resourceOM.getAttribute(new QName("url-mapping"))) != null) {
            resourceData.setUrlMapping(urlMapping.getAttributeValue());
        }
        if ((contentType = resourceOM.getAttribute(new QName("contentType"))) != null) {
            resourceData.setContentType(contentType.getAttributeValue());
        }
        if ((protocol = resourceOM.getAttribute(new QName("protocol"))) != null) {
            if (protocol.getAttributeValue().equals(PROTOCOL_HTTP)) {
                resourceData.setProtocol(1);
            } else if (protocol.getAttributeValue().equals(PROTOCOL_HTTPS)) {
                resourceData.setProtocol(2);
            } else {
                resourceData.setProtocol(Integer.parseInt(protocol.getAttributeValue()));
            }
        }
        if ((userAgent = resourceOM.getAttribute(new QName("userAgent"))) != null) {
            resourceData.setUserAgent(userAgent.getAttributeValue());
        }
        if ((inSequence = resourceOM.getAttribute(new QName("inSequence"))) != null) {
            resourceData.setInSequenceKey(inSequence.getAttributeValue());
        }
        if ((outSequence = resourceOM.getAttribute(new QName("outSequence"))) != null) {
            resourceData.setOutSequenceKey(outSequence.getAttributeValue());
        }
        if ((faultSequence = resourceOM.getAttribute(new QName("faultSequence"))) != null) {
            resourceData.setFaultSequenceKey(faultSequence.getAttributeValue());
        }
        if (resourceOM.getChildElements() != null) {
            Iterator iterator = resourceOM.getChildElements();
            while (iterator.hasNext()) {
                OMElement elem = (OMElement)iterator.next();
                if ("inSequence".equals(elem.getLocalName()) && inSequence == null) {
                    resourceData.setInSeqXml(elem.toString());
                    continue;
                }
                if ("outSequence".equals(elem.getLocalName()) && outSequence == null) {
                    resourceData.setOutSeqXml(elem.toString());
                    continue;
                }
                if (!"faultSequence".equals(elem.getLocalName()) || faultSequence != null) continue;
                resourceData.setFaultSeqXml(elem.toString());
            }
        }
    }
}

